/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.bds.model.CreateResourcePrincipalConfigurationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateResourcePrincipalConfigurationRequest
extends BmcRequest<CreateResourcePrincipalConfigurationDetails> {
    private String bdsInstanceId;
    private CreateResourcePrincipalConfigurationDetails createResourcePrincipalConfigurationDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public CreateResourcePrincipalConfigurationDetails getCreateResourcePrincipalConfigurationDetails() {
        return this.createResourcePrincipalConfigurationDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateResourcePrincipalConfigurationDetails getBody$() {
        return this.createResourcePrincipalConfigurationDetails;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).createResourcePrincipalConfigurationDetails(this.createResourcePrincipalConfigurationDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",createResourcePrincipalConfigurationDetails=").append(String.valueOf((Object)this.createResourcePrincipalConfigurationDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateResourcePrincipalConfigurationRequest)) {
            return false;
        }
        CreateResourcePrincipalConfigurationRequest other = (CreateResourcePrincipalConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals((Object)this.createResourcePrincipalConfigurationDetails, (Object)other.createResourcePrincipalConfigurationDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.createResourcePrincipalConfigurationDetails == null ? 43 : this.createResourcePrincipalConfigurationDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateResourcePrincipalConfigurationRequest, CreateResourcePrincipalConfigurationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private CreateResourcePrincipalConfigurationDetails createResourcePrincipalConfigurationDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder createResourcePrincipalConfigurationDetails(CreateResourcePrincipalConfigurationDetails createResourcePrincipalConfigurationDetails) {
            this.createResourcePrincipalConfigurationDetails = createResourcePrincipalConfigurationDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateResourcePrincipalConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.createResourcePrincipalConfigurationDetails(o.getCreateResourcePrincipalConfigurationDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateResourcePrincipalConfigurationRequest build() {
            CreateResourcePrincipalConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateResourcePrincipalConfigurationDetails body) {
            this.createResourcePrincipalConfigurationDetails(body);
            return this;
        }

        public CreateResourcePrincipalConfigurationRequest buildWithoutInvocationCallback() {
            CreateResourcePrincipalConfigurationRequest request = new CreateResourcePrincipalConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.createResourcePrincipalConfigurationDetails = this.createResourcePrincipalConfigurationDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

