/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetNodeBackupConfigurationRequest
extends BmcRequest<Void> {
    private String bdsInstanceId;
    private String nodeBackupConfigurationId;
    private String opcRequestId;

    public String getBdsInstanceId() {
        return this.bdsInstanceId;
    }

    public String getNodeBackupConfigurationId() {
        return this.nodeBackupConfigurationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().bdsInstanceId(this.bdsInstanceId).nodeBackupConfigurationId(this.nodeBackupConfigurationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bdsInstanceId=").append(String.valueOf(this.bdsInstanceId));
        sb.append(",nodeBackupConfigurationId=").append(String.valueOf(this.nodeBackupConfigurationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetNodeBackupConfigurationRequest)) {
            return false;
        }
        GetNodeBackupConfigurationRequest other = (GetNodeBackupConfigurationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bdsInstanceId, other.bdsInstanceId) && Objects.equals(this.nodeBackupConfigurationId, other.nodeBackupConfigurationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bdsInstanceId == null ? 43 : this.bdsInstanceId.hashCode());
        result = result * 59 + (this.nodeBackupConfigurationId == null ? 43 : this.nodeBackupConfigurationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetNodeBackupConfigurationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bdsInstanceId = null;
        private String nodeBackupConfigurationId = null;
        private String opcRequestId = null;

        public Builder bdsInstanceId(String bdsInstanceId) {
            this.bdsInstanceId = bdsInstanceId;
            return this;
        }

        public Builder nodeBackupConfigurationId(String nodeBackupConfigurationId) {
            this.nodeBackupConfigurationId = nodeBackupConfigurationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNodeBackupConfigurationRequest o) {
            this.bdsInstanceId(o.getBdsInstanceId());
            this.nodeBackupConfigurationId(o.getNodeBackupConfigurationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNodeBackupConfigurationRequest build() {
            GetNodeBackupConfigurationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetNodeBackupConfigurationRequest buildWithoutInvocationCallback() {
            GetNodeBackupConfigurationRequest request = new GetNodeBackupConfigurationRequest();
            request.bdsInstanceId = this.bdsInstanceId;
            request.nodeBackupConfigurationId = this.nodeBackupConfigurationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

