/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResourceSubTypeDetail
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subType")
    private final String subType;
    @JsonProperty(value="subTypeKey")
    private final String subTypeKey;
    @JsonProperty(value="subTypeStatus")
    private final SubTypeStatus subTypeStatus;

    @Deprecated
    @ConstructorProperties(value={"subType", "subTypeKey", "subTypeStatus"})
    public WorkRequestResourceSubTypeDetail(String subType, String subTypeKey, SubTypeStatus subTypeStatus) {
        this.subType = subType;
        this.subTypeKey = subTypeKey;
        this.subTypeStatus = subTypeStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSubType() {
        return this.subType;
    }

    public String getSubTypeKey() {
        return this.subTypeKey;
    }

    public SubTypeStatus getSubTypeStatus() {
        return this.subTypeStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResourceSubTypeDetail(");
        sb.append("super=").append(super.toString());
        sb.append("subType=").append(String.valueOf(this.subType));
        sb.append(", subTypeKey=").append(String.valueOf(this.subTypeKey));
        sb.append(", subTypeStatus=").append(String.valueOf((Object)this.subTypeStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResourceSubTypeDetail)) {
            return false;
        }
        WorkRequestResourceSubTypeDetail other = (WorkRequestResourceSubTypeDetail)((Object)o);
        return Objects.equals(this.subType, other.subType) && Objects.equals(this.subTypeKey, other.subTypeKey) && Objects.equals((Object)this.subTypeStatus, (Object)other.subTypeStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subType == null ? 43 : this.subType.hashCode());
        result = result * 59 + (this.subTypeKey == null ? 43 : this.subTypeKey.hashCode());
        result = result * 59 + (this.subTypeStatus == null ? 43 : this.subTypeStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SubTypeStatus implements BmcEnum
    {
        Created("CREATED"),
        Updated("UPDATED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SubTypeStatus> map;

        private SubTypeStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SubTypeStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SubTypeStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SubTypeStatus.class);
            map = new HashMap<String, SubTypeStatus>();
            for (SubTypeStatus v : SubTypeStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subType")
        private String subType;
        @JsonProperty(value="subTypeKey")
        private String subTypeKey;
        @JsonProperty(value="subTypeStatus")
        private SubTypeStatus subTypeStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subType(String subType) {
            this.subType = subType;
            this.__explicitlySet__.add("subType");
            return this;
        }

        public Builder subTypeKey(String subTypeKey) {
            this.subTypeKey = subTypeKey;
            this.__explicitlySet__.add("subTypeKey");
            return this;
        }

        public Builder subTypeStatus(SubTypeStatus subTypeStatus) {
            this.subTypeStatus = subTypeStatus;
            this.__explicitlySet__.add("subTypeStatus");
            return this;
        }

        public WorkRequestResourceSubTypeDetail build() {
            WorkRequestResourceSubTypeDetail model = new WorkRequestResourceSubTypeDetail(this.subType, this.subTypeKey, this.subTypeStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResourceSubTypeDetail model) {
            if (model.wasPropertyExplicitlySet("subType")) {
                this.subType(model.getSubType());
            }
            if (model.wasPropertyExplicitlySet("subTypeKey")) {
                this.subTypeKey(model.getSubTypeKey());
            }
            if (model.wasPropertyExplicitlySet("subTypeStatus")) {
                this.subTypeStatus(model.getSubTypeStatus());
            }
            return this;
        }
    }
}

