/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.blockchain.BlockchainPlatformPaginators;
import com.oracle.bmc.blockchain.BlockchainPlatformWaiters;
import com.oracle.bmc.blockchain.model.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.BlockchainPlatformCollection;
import com.oracle.bmc.blockchain.model.BlockchainPlatformPatchCollection;
import com.oracle.bmc.blockchain.model.Osn;
import com.oracle.bmc.blockchain.model.OsnCollection;
import com.oracle.bmc.blockchain.model.Peer;
import com.oracle.bmc.blockchain.model.PeerCollection;
import com.oracle.bmc.blockchain.model.ScaledBlockchainPlatformPreview;
import com.oracle.bmc.blockchain.model.WorkRequest;
import com.oracle.bmc.blockchain.model.WorkRequestCollection;
import com.oracle.bmc.blockchain.model.WorkRequestErrorCollection;
import com.oracle.bmc.blockchain.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.blockchain.requests.ChangeBlockchainPlatformCompartmentRequest;
import com.oracle.bmc.blockchain.requests.CreateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.CreateOsnRequest;
import com.oracle.bmc.blockchain.requests.CreatePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.DeleteOsnRequest;
import com.oracle.bmc.blockchain.requests.DeletePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformPatchesRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.ScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StartBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StopBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateOsnRequest;
import com.oracle.bmc.blockchain.requests.UpdatePeerRequest;
import com.oracle.bmc.blockchain.requests.UpgradeBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.responses.ChangeBlockchainPlatformCompartmentResponse;
import com.oracle.bmc.blockchain.responses.CreateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.CreateOsnResponse;
import com.oracle.bmc.blockchain.responses.CreatePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.DeleteOsnResponse;
import com.oracle.bmc.blockchain.responses.DeletePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformPatchesResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.ScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StartBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StopBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateOsnResponse;
import com.oracle.bmc.blockchain.responses.UpdatePeerResponse;
import com.oracle.bmc.blockchain.responses.UpgradeBlockchainPlatformResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockchainPlatformClient
extends BaseSyncClient
implements com.oracle.bmc.blockchain.BlockchainPlatform {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKCHAINPLATFORM").serviceEndpointPrefix("").serviceEndpointTemplate("https://blockchain.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainPlatformClient.class);
    private final BlockchainPlatformWaiters waiters;
    private final BlockchainPlatformPaginators paginators;

    BlockchainPlatformClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("BlockchainPlatform-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BlockchainPlatformWaiters(executorService, this);
        this.paginators = new BlockchainPlatformPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeBlockchainPlatformCompartmentResponse changeBlockchainPlatformCompartment(ChangeBlockchainPlatformCompartmentRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBlockchainPlatformCompartmentDetails(), "changeBlockchainPlatformCompartmentDetails is required");
        return (ChangeBlockchainPlatformCompartmentResponse)this.clientCall(request, ChangeBlockchainPlatformCompartmentResponse::builder).logger(LOG, "changeBlockchainPlatformCompartment").serviceDetails("BlockchainPlatform", "ChangeBlockchainPlatformCompartment", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ChangeBlockchainPlatformCompartment").method(Method.POST).requestBuilder(ChangeBlockchainPlatformCompartmentRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeBlockchainPlatformCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeBlockchainPlatformCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateBlockchainPlatformResponse createBlockchainPlatform(CreateBlockchainPlatformRequest request) {
        Objects.requireNonNull(request.getCreateBlockchainPlatformDetails(), "createBlockchainPlatformDetails is required");
        return (CreateBlockchainPlatformResponse)this.clientCall(request, CreateBlockchainPlatformResponse::builder).logger(LOG, "createBlockchainPlatform").serviceDetails("BlockchainPlatform", "CreateBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreateBlockchainPlatform").method(Method.POST).requestBuilder(CreateBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOsnResponse createOsn(CreateOsnRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOsnDetails(), "createOsnDetails is required");
        return (CreateOsnResponse)this.clientCall(request, CreateOsnResponse::builder).logger(LOG, "createOsn").serviceDetails("BlockchainPlatform", "CreateOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreateOsn").method(Method.POST).requestBuilder(CreateOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateOsnResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateOsnResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreatePeerResponse createPeer(CreatePeerRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePeerDetails(), "createPeerDetails is required");
        return (CreatePeerResponse)this.clientCall(request, CreatePeerResponse::builder).logger(LOG, "createPeer").serviceDetails("BlockchainPlatform", "CreatePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreatePeer").method(Method.POST).requestBuilder(CreatePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreatePeerResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePeerResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteBlockchainPlatformResponse deleteBlockchainPlatform(DeleteBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (DeleteBlockchainPlatformResponse)this.clientCall(request, DeleteBlockchainPlatformResponse::builder).logger(LOG, "deleteBlockchainPlatform").serviceDetails("BlockchainPlatform", "DeleteBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeleteBlockchainPlatform").method(Method.DELETE).requestBuilder(DeleteBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", DeleteBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOsnResponse deleteOsn(DeleteOsnRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        return (DeleteOsnResponse)this.clientCall(request, DeleteOsnResponse::builder).logger(LOG, "deleteOsn").serviceDetails("BlockchainPlatform", "DeleteOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeleteOsn").method(Method.DELETE).requestBuilder(DeleteOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteOsnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOsnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePeerResponse deletePeer(DeletePeerRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        return (DeletePeerResponse)this.clientCall(request, DeletePeerResponse::builder).logger(LOG, "deletePeer").serviceDetails("BlockchainPlatform", "DeletePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeletePeer").method(Method.DELETE).requestBuilder(DeletePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", DeletePeerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePeerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWorkRequestResponse deleteWorkRequest(DeleteWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteWorkRequestResponse)this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("BlockchainPlatform", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteWorkRequestResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetBlockchainPlatformResponse getBlockchainPlatform(GetBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (GetBlockchainPlatformResponse)this.clientCall(request, GetBlockchainPlatformResponse::builder).logger(LOG, "getBlockchainPlatform").serviceDetails("BlockchainPlatform", "GetBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/GetBlockchainPlatform").method(Method.GET).requestBuilder(GetBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatform.class, GetBlockchainPlatformResponse.Builder::blockchainPlatform).handleResponseHeaderString("etag", GetBlockchainPlatformResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOsnResponse getOsn(GetOsnRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        return (GetOsnResponse)this.clientCall(request, GetOsnResponse::builder).logger(LOG, "getOsn").serviceDetails("BlockchainPlatform", "GetOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Osn/GetOsn").method(Method.GET).requestBuilder(GetOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Osn.class, GetOsnResponse.Builder::osn).handleResponseHeaderString("etag", GetOsnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOsnResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPeerResponse getPeer(GetPeerRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        return (GetPeerResponse)this.clientCall(request, GetPeerResponse::builder).logger(LOG, "getPeer").serviceDetails("BlockchainPlatform", "GetPeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Peer/GetPeer").method(Method.GET).requestBuilder(GetPeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Peer.class, GetPeerResponse.Builder::peer).handleResponseHeaderString("etag", GetPeerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPeerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("BlockchainPlatform", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListBlockchainPlatformPatchesResponse listBlockchainPlatformPatches(ListBlockchainPlatformPatchesRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (ListBlockchainPlatformPatchesResponse)this.clientCall(request, ListBlockchainPlatformPatchesResponse::builder).logger(LOG, "listBlockchainPlatformPatches").serviceDetails("BlockchainPlatform", "ListBlockchainPlatformPatches", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ListBlockchainPlatformPatches").method(Method.GET).requestBuilder(ListBlockchainPlatformPatchesRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("patches").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatformPatchCollection.class, ListBlockchainPlatformPatchesResponse.Builder::blockchainPlatformPatchCollection).handleResponseHeaderString("opc-request-id", ListBlockchainPlatformPatchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlockchainPlatformPatchesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBlockchainPlatformsResponse listBlockchainPlatforms(ListBlockchainPlatformsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListBlockchainPlatformsResponse)this.clientCall(request, ListBlockchainPlatformsResponse::builder).logger(LOG, "listBlockchainPlatforms").serviceDetails("BlockchainPlatform", "ListBlockchainPlatforms", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ListBlockchainPlatforms").method(Method.GET).requestBuilder(ListBlockchainPlatformsRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatformCollection.class, ListBlockchainPlatformsResponse.Builder::blockchainPlatformCollection).handleResponseHeaderString("opc-request-id", ListBlockchainPlatformsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlockchainPlatformsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOsnsResponse listOsns(ListOsnsRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (ListOsnsResponse)this.clientCall(request, ListOsnsResponse::builder).logger(LOG, "listOsns").serviceDetails("BlockchainPlatform", "ListOsns", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Osn/ListOsns").method(Method.GET).requestBuilder(ListOsnsRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(OsnCollection.class, ListOsnsResponse.Builder::osnCollection).handleResponseHeaderString("opc-request-id", ListOsnsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOsnsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPeersResponse listPeers(ListPeersRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (ListPeersResponse)this.clientCall(request, ListPeersResponse::builder).logger(LOG, "listPeers").serviceDetails("BlockchainPlatform", "ListPeers", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Peer/ListPeers").method(Method.GET).requestBuilder(ListPeersRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(PeerCollection.class, ListPeersResponse.Builder::peerCollection).handleResponseHeaderString("opc-request-id", ListPeersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPeersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("BlockchainPlatform", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("BlockchainPlatform", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getBlockchainPlatformId(), "blockchainPlatformId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("BlockchainPlatform", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("blockchainPlatformId", (Object)request.getBlockchainPlatformId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PreviewScaleBlockchainPlatformResponse previewScaleBlockchainPlatform(PreviewScaleBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleBlockchainPlatformDetails(), "scaleBlockchainPlatformDetails is required");
        return (PreviewScaleBlockchainPlatformResponse)this.clientCall(request, PreviewScaleBlockchainPlatformResponse::builder).logger(LOG, "previewScaleBlockchainPlatform").serviceDetails("BlockchainPlatform", "PreviewScaleBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/PreviewScaleBlockchainPlatform").method(Method.POST).requestBuilder(PreviewScaleBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("scale").appendPathParam("preview").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ScaledBlockchainPlatformPreview.class, PreviewScaleBlockchainPlatformResponse.Builder::scaledBlockchainPlatformPreview).handleResponseHeaderString("etag", PreviewScaleBlockchainPlatformResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PreviewScaleBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScaleBlockchainPlatformResponse scaleBlockchainPlatform(ScaleBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleBlockchainPlatformDetails(), "scaleBlockchainPlatformDetails is required");
        return (ScaleBlockchainPlatformResponse)this.clientCall(request, ScaleBlockchainPlatformResponse::builder).logger(LOG, "scaleBlockchainPlatform").serviceDetails("BlockchainPlatform", "ScaleBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ScaleBlockchainPlatform").method(Method.POST).requestBuilder(ScaleBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("scale").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ScaleBlockchainPlatformResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ScaleBlockchainPlatformResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartBlockchainPlatformResponse startBlockchainPlatform(StartBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (StartBlockchainPlatformResponse)this.clientCall(request, StartBlockchainPlatformResponse::builder).logger(LOG, "startBlockchainPlatform").serviceDetails("BlockchainPlatform", "StartBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/StartBlockchainPlatform").method(Method.POST).requestBuilder(StartBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopBlockchainPlatformResponse stopBlockchainPlatform(StopBlockchainPlatformRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (StopBlockchainPlatformResponse)this.clientCall(request, StopBlockchainPlatformResponse::builder).logger(LOG, "stopBlockchainPlatform").serviceDetails("BlockchainPlatform", "StopBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/StopBlockchainPlatform").method(Method.POST).requestBuilder(StopBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBlockchainPlatformResponse updateBlockchainPlatform(UpdateBlockchainPlatformRequest request) {
        Objects.requireNonNull(request.getUpdateBlockchainPlatformDetails(), "updateBlockchainPlatformDetails is required");
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (UpdateBlockchainPlatformResponse)this.clientCall(request, UpdateBlockchainPlatformResponse::builder).logger(LOG, "updateBlockchainPlatform").serviceDetails("BlockchainPlatform", "UpdateBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdateBlockchainPlatform").method(Method.PUT).requestBuilder(UpdateBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateBlockchainPlatformResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateBlockchainPlatformResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateOsnResponse updateOsn(UpdateOsnRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOsnDetails(), "updateOsnDetails is required");
        return (UpdateOsnResponse)this.clientCall(request, UpdateOsnResponse::builder).logger(LOG, "updateOsn").serviceDetails("BlockchainPlatform", "UpdateOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdateOsn").method(Method.PUT).requestBuilder(UpdateOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateOsnResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateOsnResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdatePeerResponse updatePeer(UpdatePeerRequest request) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePeerDetails(), "updatePeerDetails is required");
        return (UpdatePeerResponse)this.clientCall(request, UpdatePeerResponse::builder).logger(LOG, "updatePeer").serviceDetails("BlockchainPlatform", "UpdatePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdatePeer").method(Method.PUT).requestBuilder(UpdatePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePeerResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePeerResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpgradeBlockchainPlatformResponse upgradeBlockchainPlatform(UpgradeBlockchainPlatformRequest request) {
        Objects.requireNonNull(request.getUpgradeBlockchainPlatformDetails(), "upgradeBlockchainPlatformDetails is required");
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return (UpgradeBlockchainPlatformResponse)this.clientCall(request, UpgradeBlockchainPlatformResponse::builder).logger(LOG, "upgradeBlockchainPlatform").serviceDetails("BlockchainPlatform", "UpgradeBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpgradeBlockchainPlatform").method(Method.POST).requestBuilder(UpgradeBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("upgrade").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeBlockchainPlatformResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public BlockchainPlatformWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BlockchainPlatformPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BlockchainPlatformClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BlockchainPlatformClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public BlockchainPlatformClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BlockchainPlatformClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockchainPlatformClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "blockchain";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"blockchain");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BlockchainPlatformClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BlockchainPlatformClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

