/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.Osn;
import com.oracle.bmc.blockchain.model.Peer;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BlockchainPlatformComponentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="osns")
    private final List<Osn> osns;
    @JsonProperty(value="peers")
    private final List<Peer> peers;

    @Deprecated
    @ConstructorProperties(value={"osns", "peers"})
    public BlockchainPlatformComponentDetails(List<Osn> osns, List<Peer> peers) {
        this.osns = osns;
        this.peers = peers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Osn> getOsns() {
        return this.osns;
    }

    public List<Peer> getPeers() {
        return this.peers;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockchainPlatformComponentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("osns=").append(String.valueOf(this.osns));
        sb.append(", peers=").append(String.valueOf(this.peers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockchainPlatformComponentDetails)) {
            return false;
        }
        BlockchainPlatformComponentDetails other = (BlockchainPlatformComponentDetails)((Object)o);
        return Objects.equals(this.osns, other.osns) && Objects.equals(this.peers, other.peers) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.osns == null ? 43 : this.osns.hashCode());
        result = result * 59 + (this.peers == null ? 43 : this.peers.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="osns")
        private List<Osn> osns;
        @JsonProperty(value="peers")
        private List<Peer> peers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder osns(List<Osn> osns) {
            this.osns = osns;
            this.__explicitlySet__.add("osns");
            return this;
        }

        public Builder peers(List<Peer> peers) {
            this.peers = peers;
            this.__explicitlySet__.add("peers");
            return this;
        }

        public BlockchainPlatformComponentDetails build() {
            BlockchainPlatformComponentDetails model = new BlockchainPlatformComponentDetails(this.osns, this.peers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BlockchainPlatformComponentDetails model) {
            if (model.wasPropertyExplicitlySet("osns")) {
                this.osns(model.getOsns());
            }
            if (model.wasPropertyExplicitlySet("peers")) {
                this.peers(model.getPeers());
            }
            return this;
        }
    }
}

