/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OcpuUtilizationInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="ocpuUtilizationNumber")
    private final Float ocpuUtilizationNumber;
    @JsonProperty(value="ocpuCapacityNumber")
    private final Float ocpuCapacityNumber;

    @Deprecated
    @ConstructorProperties(value={"host", "ocpuUtilizationNumber", "ocpuCapacityNumber"})
    public OcpuUtilizationInfo(String host, Float ocpuUtilizationNumber, Float ocpuCapacityNumber) {
        this.host = host;
        this.ocpuUtilizationNumber = ocpuUtilizationNumber;
        this.ocpuCapacityNumber = ocpuCapacityNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHost() {
        return this.host;
    }

    public Float getOcpuUtilizationNumber() {
        return this.ocpuUtilizationNumber;
    }

    public Float getOcpuCapacityNumber() {
        return this.ocpuCapacityNumber;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OcpuUtilizationInfo(");
        sb.append("super=").append(super.toString());
        sb.append("host=").append(String.valueOf(this.host));
        sb.append(", ocpuUtilizationNumber=").append(String.valueOf(this.ocpuUtilizationNumber));
        sb.append(", ocpuCapacityNumber=").append(String.valueOf(this.ocpuCapacityNumber));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OcpuUtilizationInfo)) {
            return false;
        }
        OcpuUtilizationInfo other = (OcpuUtilizationInfo)((Object)o);
        return Objects.equals(this.host, other.host) && Objects.equals(this.ocpuUtilizationNumber, other.ocpuUtilizationNumber) && Objects.equals(this.ocpuCapacityNumber, other.ocpuCapacityNumber) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.ocpuUtilizationNumber == null ? 43 : this.ocpuUtilizationNumber.hashCode());
        result = result * 59 + (this.ocpuCapacityNumber == null ? 43 : this.ocpuCapacityNumber.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="ocpuUtilizationNumber")
        private Float ocpuUtilizationNumber;
        @JsonProperty(value="ocpuCapacityNumber")
        private Float ocpuCapacityNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder ocpuUtilizationNumber(Float ocpuUtilizationNumber) {
            this.ocpuUtilizationNumber = ocpuUtilizationNumber;
            this.__explicitlySet__.add("ocpuUtilizationNumber");
            return this;
        }

        public Builder ocpuCapacityNumber(Float ocpuCapacityNumber) {
            this.ocpuCapacityNumber = ocpuCapacityNumber;
            this.__explicitlySet__.add("ocpuCapacityNumber");
            return this;
        }

        public OcpuUtilizationInfo build() {
            OcpuUtilizationInfo model = new OcpuUtilizationInfo(this.host, this.ocpuUtilizationNumber, this.ocpuCapacityNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OcpuUtilizationInfo model) {
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("ocpuUtilizationNumber")) {
                this.ocpuUtilizationNumber(model.getOcpuUtilizationNumber());
            }
            if (model.wasPropertyExplicitlySet("ocpuCapacityNumber")) {
                this.ocpuCapacityNumber(model.getOcpuCapacityNumber());
            }
            return this;
        }
    }
}

