/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.blockchain.BlockchainPlatformAsync;
import com.oracle.bmc.blockchain.model.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.BlockchainPlatformCollection;
import com.oracle.bmc.blockchain.model.BlockchainPlatformPatchCollection;
import com.oracle.bmc.blockchain.model.Osn;
import com.oracle.bmc.blockchain.model.OsnCollection;
import com.oracle.bmc.blockchain.model.Peer;
import com.oracle.bmc.blockchain.model.PeerCollection;
import com.oracle.bmc.blockchain.model.ScaledBlockchainPlatformPreview;
import com.oracle.bmc.blockchain.model.WorkRequest;
import com.oracle.bmc.blockchain.model.WorkRequestCollection;
import com.oracle.bmc.blockchain.model.WorkRequestErrorCollection;
import com.oracle.bmc.blockchain.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.blockchain.requests.ChangeBlockchainPlatformCompartmentRequest;
import com.oracle.bmc.blockchain.requests.CreateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.CreateOsnRequest;
import com.oracle.bmc.blockchain.requests.CreatePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.DeleteOsnRequest;
import com.oracle.bmc.blockchain.requests.DeletePeerRequest;
import com.oracle.bmc.blockchain.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.GetBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.GetOsnRequest;
import com.oracle.bmc.blockchain.requests.GetPeerRequest;
import com.oracle.bmc.blockchain.requests.GetWorkRequestRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformPatchesRequest;
import com.oracle.bmc.blockchain.requests.ListBlockchainPlatformsRequest;
import com.oracle.bmc.blockchain.requests.ListOsnsRequest;
import com.oracle.bmc.blockchain.requests.ListPeersRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.blockchain.requests.ListWorkRequestsRequest;
import com.oracle.bmc.blockchain.requests.PreviewScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.ScaleBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StartBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.StopBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.requests.UpdateOsnRequest;
import com.oracle.bmc.blockchain.requests.UpdatePeerRequest;
import com.oracle.bmc.blockchain.requests.UpgradeBlockchainPlatformRequest;
import com.oracle.bmc.blockchain.responses.ChangeBlockchainPlatformCompartmentResponse;
import com.oracle.bmc.blockchain.responses.CreateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.CreateOsnResponse;
import com.oracle.bmc.blockchain.responses.CreatePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.DeleteOsnResponse;
import com.oracle.bmc.blockchain.responses.DeletePeerResponse;
import com.oracle.bmc.blockchain.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.GetBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.GetOsnResponse;
import com.oracle.bmc.blockchain.responses.GetPeerResponse;
import com.oracle.bmc.blockchain.responses.GetWorkRequestResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformPatchesResponse;
import com.oracle.bmc.blockchain.responses.ListBlockchainPlatformsResponse;
import com.oracle.bmc.blockchain.responses.ListOsnsResponse;
import com.oracle.bmc.blockchain.responses.ListPeersResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.blockchain.responses.ListWorkRequestsResponse;
import com.oracle.bmc.blockchain.responses.PreviewScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.ScaleBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StartBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.StopBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateBlockchainPlatformResponse;
import com.oracle.bmc.blockchain.responses.UpdateOsnResponse;
import com.oracle.bmc.blockchain.responses.UpdatePeerResponse;
import com.oracle.bmc.blockchain.responses.UpgradeBlockchainPlatformResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockchainPlatformAsyncClient
extends BaseAsyncClient
implements BlockchainPlatformAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BLOCKCHAINPLATFORM").serviceEndpointPrefix("").serviceEndpointTemplate("https://blockchain.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainPlatformAsyncClient.class);

    BlockchainPlatformAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeBlockchainPlatformCompartmentResponse> changeBlockchainPlatformCompartment(ChangeBlockchainPlatformCompartmentRequest request, AsyncHandler<ChangeBlockchainPlatformCompartmentRequest, ChangeBlockchainPlatformCompartmentResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeBlockchainPlatformCompartmentDetails(), "changeBlockchainPlatformCompartmentDetails is required");
        return this.clientCall(request, ChangeBlockchainPlatformCompartmentResponse::builder).logger(LOG, "changeBlockchainPlatformCompartment").serviceDetails("BlockchainPlatform", "ChangeBlockchainPlatformCompartment", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ChangeBlockchainPlatformCompartment").method(Method.POST).requestBuilder(ChangeBlockchainPlatformCompartmentRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeBlockchainPlatformCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeBlockchainPlatformCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBlockchainPlatformResponse> createBlockchainPlatform(CreateBlockchainPlatformRequest request, AsyncHandler<CreateBlockchainPlatformRequest, CreateBlockchainPlatformResponse> handler) {
        Objects.requireNonNull(request.getCreateBlockchainPlatformDetails(), "createBlockchainPlatformDetails is required");
        return this.clientCall(request, CreateBlockchainPlatformResponse::builder).logger(LOG, "createBlockchainPlatform").serviceDetails("BlockchainPlatform", "CreateBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreateBlockchainPlatform").method(Method.POST).requestBuilder(CreateBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOsnResponse> createOsn(CreateOsnRequest request, AsyncHandler<CreateOsnRequest, CreateOsnResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOsnDetails(), "createOsnDetails is required");
        return this.clientCall(request, CreateOsnResponse::builder).logger(LOG, "createOsn").serviceDetails("BlockchainPlatform", "CreateOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreateOsn").method(Method.POST).requestBuilder(CreateOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateOsnResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateOsnResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePeerResponse> createPeer(CreatePeerRequest request, AsyncHandler<CreatePeerRequest, CreatePeerResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePeerDetails(), "createPeerDetails is required");
        return this.clientCall(request, CreatePeerResponse::builder).logger(LOG, "createPeer").serviceDetails("BlockchainPlatform", "CreatePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/CreatePeer").method(Method.POST).requestBuilder(CreatePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreatePeerResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreatePeerResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBlockchainPlatformResponse> deleteBlockchainPlatform(DeleteBlockchainPlatformRequest request, AsyncHandler<DeleteBlockchainPlatformRequest, DeleteBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBlockchainPlatformResponse::builder).logger(LOG, "deleteBlockchainPlatform").serviceDetails("BlockchainPlatform", "DeleteBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeleteBlockchainPlatform").method(Method.DELETE).requestBuilder(DeleteBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", DeleteBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOsnResponse> deleteOsn(DeleteOsnRequest request, AsyncHandler<DeleteOsnRequest, DeleteOsnResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOsnResponse::builder).logger(LOG, "deleteOsn").serviceDetails("BlockchainPlatform", "DeleteOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeleteOsn").method(Method.DELETE).requestBuilder(DeleteOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", DeleteOsnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOsnResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePeerResponse> deletePeer(DeletePeerRequest request, AsyncHandler<DeletePeerRequest, DeletePeerResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeletePeerResponse::builder).logger(LOG, "deletePeer").serviceDetails("BlockchainPlatform", "DeletePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/DeletePeer").method(Method.DELETE).requestBuilder(DeletePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", DeletePeerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePeerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("BlockchainPlatform", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteWorkRequestResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBlockchainPlatformResponse> getBlockchainPlatform(GetBlockchainPlatformRequest request, AsyncHandler<GetBlockchainPlatformRequest, GetBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBlockchainPlatformResponse::builder).logger(LOG, "getBlockchainPlatform").serviceDetails("BlockchainPlatform", "GetBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/GetBlockchainPlatform").method(Method.GET).requestBuilder(GetBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatform.class, GetBlockchainPlatformResponse.Builder::blockchainPlatform).handleResponseHeaderString("etag", GetBlockchainPlatformResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOsnResponse> getOsn(GetOsnRequest request, AsyncHandler<GetOsnRequest, GetOsnResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOsnResponse::builder).logger(LOG, "getOsn").serviceDetails("BlockchainPlatform", "GetOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Osn/GetOsn").method(Method.GET).requestBuilder(GetOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Osn.class, GetOsnResponse.Builder::osn).handleResponseHeaderString("etag", GetOsnResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOsnResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPeerResponse> getPeer(GetPeerRequest request, AsyncHandler<GetPeerRequest, GetPeerResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPeerResponse::builder).logger(LOG, "getPeer").serviceDetails("BlockchainPlatform", "GetPeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Peer/GetPeer").method(Method.GET).requestBuilder(GetPeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Peer.class, GetPeerResponse.Builder::peer).handleResponseHeaderString("etag", GetPeerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPeerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("BlockchainPlatform", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListBlockchainPlatformPatchesResponse> listBlockchainPlatformPatches(ListBlockchainPlatformPatchesRequest request, AsyncHandler<ListBlockchainPlatformPatchesRequest, ListBlockchainPlatformPatchesResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListBlockchainPlatformPatchesResponse::builder).logger(LOG, "listBlockchainPlatformPatches").serviceDetails("BlockchainPlatform", "ListBlockchainPlatformPatches", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ListBlockchainPlatformPatches").method(Method.GET).requestBuilder(ListBlockchainPlatformPatchesRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("patches").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatformPatchCollection.class, ListBlockchainPlatformPatchesResponse.Builder::blockchainPlatformPatchCollection).handleResponseHeaderString("opc-request-id", ListBlockchainPlatformPatchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlockchainPlatformPatchesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBlockchainPlatformsResponse> listBlockchainPlatforms(ListBlockchainPlatformsRequest request, AsyncHandler<ListBlockchainPlatformsRequest, ListBlockchainPlatformsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListBlockchainPlatformsResponse::builder).logger(LOG, "listBlockchainPlatforms").serviceDetails("BlockchainPlatform", "ListBlockchainPlatforms", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ListBlockchainPlatforms").method(Method.GET).requestBuilder(ListBlockchainPlatformsRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(BlockchainPlatformCollection.class, ListBlockchainPlatformsResponse.Builder::blockchainPlatformCollection).handleResponseHeaderString("opc-request-id", ListBlockchainPlatformsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlockchainPlatformsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListOsnsResponse> listOsns(ListOsnsRequest request, AsyncHandler<ListOsnsRequest, ListOsnsResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListOsnsResponse::builder).logger(LOG, "listOsns").serviceDetails("BlockchainPlatform", "ListOsns", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Osn/ListOsns").method(Method.GET).requestBuilder(ListOsnsRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(OsnCollection.class, ListOsnsResponse.Builder::osnCollection).handleResponseHeaderString("opc-request-id", ListOsnsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOsnsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPeersResponse> listPeers(ListPeersRequest request, AsyncHandler<ListPeersRequest, ListPeersResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListPeersResponse::builder).logger(LOG, "listPeers").serviceDetails("BlockchainPlatform", "ListPeers", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/Peer/ListPeers").method(Method.GET).requestBuilder(ListPeersRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleBody(PeerCollection.class, ListPeersResponse.Builder::peerCollection).handleResponseHeaderString("opc-request-id", ListPeersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPeersResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("BlockchainPlatform", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("BlockchainPlatform", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getBlockchainPlatformId(), "blockchainPlatformId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("BlockchainPlatform", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20191010").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("blockchainPlatformId", (Object)request.getBlockchainPlatformId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PreviewScaleBlockchainPlatformResponse> previewScaleBlockchainPlatform(PreviewScaleBlockchainPlatformRequest request, AsyncHandler<PreviewScaleBlockchainPlatformRequest, PreviewScaleBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleBlockchainPlatformDetails(), "scaleBlockchainPlatformDetails is required");
        return this.clientCall(request, PreviewScaleBlockchainPlatformResponse::builder).logger(LOG, "previewScaleBlockchainPlatform").serviceDetails("BlockchainPlatform", "PreviewScaleBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/PreviewScaleBlockchainPlatform").method(Method.POST).requestBuilder(PreviewScaleBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("scale").appendPathParam("preview").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ScaledBlockchainPlatformPreview.class, PreviewScaleBlockchainPlatformResponse.Builder::scaledBlockchainPlatformPreview).handleResponseHeaderString("etag", PreviewScaleBlockchainPlatformResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PreviewScaleBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ScaleBlockchainPlatformResponse> scaleBlockchainPlatform(ScaleBlockchainPlatformRequest request, AsyncHandler<ScaleBlockchainPlatformRequest, ScaleBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScaleBlockchainPlatformDetails(), "scaleBlockchainPlatformDetails is required");
        return this.clientCall(request, ScaleBlockchainPlatformResponse::builder).logger(LOG, "scaleBlockchainPlatform").serviceDetails("BlockchainPlatform", "ScaleBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/ScaleBlockchainPlatform").method(Method.POST).requestBuilder(ScaleBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("scale").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ScaleBlockchainPlatformResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ScaleBlockchainPlatformResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartBlockchainPlatformResponse> startBlockchainPlatform(StartBlockchainPlatformRequest request, AsyncHandler<StartBlockchainPlatformRequest, StartBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartBlockchainPlatformResponse::builder).logger(LOG, "startBlockchainPlatform").serviceDetails("BlockchainPlatform", "StartBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/StartBlockchainPlatform").method(Method.POST).requestBuilder(StartBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopBlockchainPlatformResponse> stopBlockchainPlatform(StopBlockchainPlatformRequest request, AsyncHandler<StopBlockchainPlatformRequest, StopBlockchainPlatformResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopBlockchainPlatformResponse::builder).logger(LOG, "stopBlockchainPlatform").serviceDetails("BlockchainPlatform", "StopBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/StopBlockchainPlatform").method(Method.POST).requestBuilder(StopBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBlockchainPlatformResponse> updateBlockchainPlatform(UpdateBlockchainPlatformRequest request, AsyncHandler<UpdateBlockchainPlatformRequest, UpdateBlockchainPlatformResponse> handler) {
        Objects.requireNonNull(request.getUpdateBlockchainPlatformDetails(), "updateBlockchainPlatformDetails is required");
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateBlockchainPlatformResponse::builder).logger(LOG, "updateBlockchainPlatform").serviceDetails("BlockchainPlatform", "UpdateBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdateBlockchainPlatform").method(Method.PUT).requestBuilder(UpdateBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateBlockchainPlatformResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateBlockchainPlatformResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateOsnResponse> updateOsn(UpdateOsnRequest request, AsyncHandler<UpdateOsnRequest, UpdateOsnResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOsnId(), (String)"osnId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOsnDetails(), "updateOsnDetails is required");
        return this.clientCall(request, UpdateOsnResponse::builder).logger(LOG, "updateOsn").serviceDetails("BlockchainPlatform", "UpdateOsn", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdateOsn").method(Method.PUT).requestBuilder(UpdateOsnRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("osns").appendPathParam(request.getOsnId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateOsnResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateOsnResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePeerResponse> updatePeer(UpdatePeerRequest request, AsyncHandler<UpdatePeerRequest, UpdatePeerResponse> handler) {
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeerId(), (String)"peerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePeerDetails(), "updatePeerDetails is required");
        return this.clientCall(request, UpdatePeerResponse::builder).logger(LOG, "updatePeer").serviceDetails("BlockchainPlatform", "UpdatePeer", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpdatePeer").method(Method.PUT).requestBuilder(UpdatePeerRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("peers").appendPathParam(request.getPeerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdatePeerResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdatePeerResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpgradeBlockchainPlatformResponse> upgradeBlockchainPlatform(UpgradeBlockchainPlatformRequest request, AsyncHandler<UpgradeBlockchainPlatformRequest, UpgradeBlockchainPlatformResponse> handler) {
        Objects.requireNonNull(request.getUpgradeBlockchainPlatformDetails(), "upgradeBlockchainPlatformDetails is required");
        Validate.notBlank((String)request.getBlockchainPlatformId(), (String)"blockchainPlatformId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpgradeBlockchainPlatformResponse::builder).logger(LOG, "upgradeBlockchainPlatform").serviceDetails("BlockchainPlatform", "UpgradeBlockchainPlatform", "https://docs.oracle.com/iaas/api/#/en/blockchain/20191010/BlockchainPlatform/UpgradeBlockchainPlatform").method(Method.POST).requestBuilder(UpgradeBlockchainPlatformRequest::builder).basePath("/20191010").appendPathParam("blockchainPlatforms").appendPathParam(request.getBlockchainPlatformId()).appendPathParam("actions").appendPathParam("upgrade").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpgradeBlockchainPlatformResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpgradeBlockchainPlatformResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BlockchainPlatformAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BlockchainPlatformAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BlockchainPlatformAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BlockchainPlatformAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BlockchainPlatformAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BlockchainPlatformAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public BlockchainPlatformAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BlockchainPlatformAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BlockchainPlatformAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "blockchain";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"blockchain");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BlockchainPlatformAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BlockchainPlatformAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

