/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.blockchain.model.BlockchainPlatform;
import com.oracle.bmc.blockchain.model.ReplicaDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateBlockchainPlatformDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="storageSizeInTBs")
    private final Double storageSizeInTBs;
    @JsonProperty(value="replicas")
    private final ReplicaDetails replicas;
    @JsonProperty(value="totalOcpuCapacity")
    private final Integer totalOcpuCapacity;
    @JsonProperty(value="loadBalancerShape")
    private final BlockchainPlatform.LoadBalancerShape loadBalancerShape;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"description", "storageSizeInTBs", "replicas", "totalOcpuCapacity", "loadBalancerShape", "freeformTags", "definedTags"})
    public UpdateBlockchainPlatformDetails(String description, Double storageSizeInTBs, ReplicaDetails replicas, Integer totalOcpuCapacity, BlockchainPlatform.LoadBalancerShape loadBalancerShape, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.description = description;
        this.storageSizeInTBs = storageSizeInTBs;
        this.replicas = replicas;
        this.totalOcpuCapacity = totalOcpuCapacity;
        this.loadBalancerShape = loadBalancerShape;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public Double getStorageSizeInTBs() {
        return this.storageSizeInTBs;
    }

    public ReplicaDetails getReplicas() {
        return this.replicas;
    }

    public Integer getTotalOcpuCapacity() {
        return this.totalOcpuCapacity;
    }

    public BlockchainPlatform.LoadBalancerShape getLoadBalancerShape() {
        return this.loadBalancerShape;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateBlockchainPlatformDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", storageSizeInTBs=").append(String.valueOf(this.storageSizeInTBs));
        sb.append(", replicas=").append(String.valueOf((Object)this.replicas));
        sb.append(", totalOcpuCapacity=").append(String.valueOf(this.totalOcpuCapacity));
        sb.append(", loadBalancerShape=").append(String.valueOf((Object)this.loadBalancerShape));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateBlockchainPlatformDetails)) {
            return false;
        }
        UpdateBlockchainPlatformDetails other = (UpdateBlockchainPlatformDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.storageSizeInTBs, other.storageSizeInTBs) && Objects.equals((Object)this.replicas, (Object)other.replicas) && Objects.equals(this.totalOcpuCapacity, other.totalOcpuCapacity) && Objects.equals((Object)this.loadBalancerShape, (Object)other.loadBalancerShape) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.storageSizeInTBs == null ? 43 : this.storageSizeInTBs.hashCode());
        result = result * 59 + (this.replicas == null ? 43 : this.replicas.hashCode());
        result = result * 59 + (this.totalOcpuCapacity == null ? 43 : this.totalOcpuCapacity.hashCode());
        result = result * 59 + (this.loadBalancerShape == null ? 43 : this.loadBalancerShape.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="storageSizeInTBs")
        private Double storageSizeInTBs;
        @JsonProperty(value="replicas")
        private ReplicaDetails replicas;
        @JsonProperty(value="totalOcpuCapacity")
        private Integer totalOcpuCapacity;
        @JsonProperty(value="loadBalancerShape")
        private BlockchainPlatform.LoadBalancerShape loadBalancerShape;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder storageSizeInTBs(Double storageSizeInTBs) {
            this.storageSizeInTBs = storageSizeInTBs;
            this.__explicitlySet__.add("storageSizeInTBs");
            return this;
        }

        public Builder replicas(ReplicaDetails replicas) {
            this.replicas = replicas;
            this.__explicitlySet__.add("replicas");
            return this;
        }

        public Builder totalOcpuCapacity(Integer totalOcpuCapacity) {
            this.totalOcpuCapacity = totalOcpuCapacity;
            this.__explicitlySet__.add("totalOcpuCapacity");
            return this;
        }

        public Builder loadBalancerShape(BlockchainPlatform.LoadBalancerShape loadBalancerShape) {
            this.loadBalancerShape = loadBalancerShape;
            this.__explicitlySet__.add("loadBalancerShape");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateBlockchainPlatformDetails build() {
            UpdateBlockchainPlatformDetails model = new UpdateBlockchainPlatformDetails(this.description, this.storageSizeInTBs, this.replicas, this.totalOcpuCapacity, this.loadBalancerShape, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateBlockchainPlatformDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("storageSizeInTBs")) {
                this.storageSizeInTBs(model.getStorageSizeInTBs());
            }
            if (model.wasPropertyExplicitlySet("replicas")) {
                this.replicas(model.getReplicas());
            }
            if (model.wasPropertyExplicitlySet("totalOcpuCapacity")) {
                this.totalOcpuCapacity(model.getTotalOcpuCapacity());
            }
            if (model.wasPropertyExplicitlySet("loadBalancerShape")) {
                this.loadBalancerShape(model.getLoadBalancerShape());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

