/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.blockchain.model.CreateOsnDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateOsnRequest
extends BmcRequest<CreateOsnDetails> {
    private String blockchainPlatformId;
    private CreateOsnDetails createOsnDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public CreateOsnDetails getCreateOsnDetails() {
        return this.createOsnDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateOsnDetails getBody$() {
        return this.createOsnDetails;
    }

    public Builder toBuilder() {
        return new Builder().blockchainPlatformId(this.blockchainPlatformId).createOsnDetails(this.createOsnDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",blockchainPlatformId=").append(String.valueOf(this.blockchainPlatformId));
        sb.append(",createOsnDetails=").append(String.valueOf((Object)this.createOsnDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOsnRequest)) {
            return false;
        }
        CreateOsnRequest other = (CreateOsnRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.blockchainPlatformId, other.blockchainPlatformId) && Objects.equals((Object)this.createOsnDetails, (Object)other.createOsnDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockchainPlatformId == null ? 43 : this.blockchainPlatformId.hashCode());
        result = result * 59 + (this.createOsnDetails == null ? 43 : this.createOsnDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateOsnRequest, CreateOsnDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String blockchainPlatformId = null;
        private CreateOsnDetails createOsnDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder createOsnDetails(CreateOsnDetails createOsnDetails) {
            this.createOsnDetails = createOsnDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateOsnRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.createOsnDetails(o.getCreateOsnDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateOsnRequest build() {
            CreateOsnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateOsnDetails body) {
            this.createOsnDetails(body);
            return this;
        }

        public CreateOsnRequest buildWithoutInvocationCallback() {
            CreateOsnRequest request = new CreateOsnRequest();
            request.blockchainPlatformId = this.blockchainPlatformId;
            request.createOsnDetails = this.createOsnDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

