/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.blockchain.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOsnRequest
extends BmcRequest<Void> {
    private String blockchainPlatformId;
    private String osnId;
    private String opcRequestId;

    public String getBlockchainPlatformId() {
        return this.blockchainPlatformId;
    }

    public String getOsnId() {
        return this.osnId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().blockchainPlatformId(this.blockchainPlatformId).osnId(this.osnId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",blockchainPlatformId=").append(String.valueOf(this.blockchainPlatformId));
        sb.append(",osnId=").append(String.valueOf(this.osnId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOsnRequest)) {
            return false;
        }
        GetOsnRequest other = (GetOsnRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.blockchainPlatformId, other.blockchainPlatformId) && Objects.equals(this.osnId, other.osnId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockchainPlatformId == null ? 43 : this.blockchainPlatformId.hashCode());
        result = result * 59 + (this.osnId == null ? 43 : this.osnId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOsnRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String blockchainPlatformId = null;
        private String osnId = null;
        private String opcRequestId = null;

        public Builder blockchainPlatformId(String blockchainPlatformId) {
            this.blockchainPlatformId = blockchainPlatformId;
            return this;
        }

        public Builder osnId(String osnId) {
            this.osnId = osnId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOsnRequest o) {
            this.blockchainPlatformId(o.getBlockchainPlatformId());
            this.osnId(o.getOsnId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOsnRequest build() {
            GetOsnRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOsnRequest buildWithoutInvocationCallback() {
            GetOsnRequest request = new GetOsnRequest();
            request.blockchainPlatformId = this.blockchainPlatformId;
            request.osnId = this.osnId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

