/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.budget.BudgetAsync;
import com.oracle.bmc.budget.model.AlertRule;
import com.oracle.bmc.budget.model.AlertRuleSummary;
import com.oracle.bmc.budget.model.Budget;
import com.oracle.bmc.budget.model.BudgetSummary;
import com.oracle.bmc.budget.requests.CreateAlertRuleRequest;
import com.oracle.bmc.budget.requests.CreateBudgetRequest;
import com.oracle.bmc.budget.requests.DeleteAlertRuleRequest;
import com.oracle.bmc.budget.requests.DeleteBudgetRequest;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.requests.UpdateAlertRuleRequest;
import com.oracle.bmc.budget.requests.UpdateBudgetRequest;
import com.oracle.bmc.budget.responses.CreateAlertRuleResponse;
import com.oracle.bmc.budget.responses.CreateBudgetResponse;
import com.oracle.bmc.budget.responses.DeleteAlertRuleResponse;
import com.oracle.bmc.budget.responses.DeleteBudgetResponse;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.budget.responses.UpdateAlertRuleResponse;
import com.oracle.bmc.budget.responses.UpdateBudgetResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BudgetAsyncClient
extends BaseAsyncClient
implements BudgetAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BUDGET").serviceEndpointPrefix("").serviceEndpointTemplate("https://usage.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(BudgetAsyncClient.class);

    BudgetAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateAlertRuleResponse> createAlertRule(CreateAlertRuleRequest request, AsyncHandler<CreateAlertRuleRequest, CreateAlertRuleResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateAlertRuleDetails(), "createAlertRuleDetails is required");
        return this.clientCall(request, CreateAlertRuleResponse::builder).logger(LOG, "createAlertRule").serviceDetails("Budget", "CreateAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/CreateAlertRule").method(Method.POST).requestBuilder(CreateAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AlertRule.class, CreateAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("opc-request-id", CreateAlertRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateAlertRuleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateBudgetResponse> createBudget(CreateBudgetRequest request, AsyncHandler<CreateBudgetRequest, CreateBudgetResponse> handler) {
        Objects.requireNonNull(request.getCreateBudgetDetails(), "createBudgetDetails is required");
        return this.clientCall(request, CreateBudgetResponse::builder).logger(LOG, "createBudget").serviceDetails("Budget", "CreateBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/CreateBudget").method(Method.POST).requestBuilder(CreateBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Budget.class, CreateBudgetResponse.Builder::budget).handleResponseHeaderString("opc-request-id", CreateBudgetResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateBudgetResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteAlertRuleResponse> deleteAlertRule(DeleteAlertRuleRequest request, AsyncHandler<DeleteAlertRuleRequest, DeleteAlertRuleResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAlertRuleResponse::builder).logger(LOG, "deleteAlertRule").serviceDetails("Budget", "DeleteAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/DeleteAlertRule").method(Method.DELETE).requestBuilder(DeleteAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAlertRuleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest request, AsyncHandler<DeleteBudgetRequest, DeleteBudgetResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteBudgetResponse::builder).logger(LOG, "deleteBudget").serviceDetails("Budget", "DeleteBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/DeleteBudget").method(Method.DELETE).requestBuilder(DeleteBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteBudgetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAlertRuleResponse> getAlertRule(GetAlertRuleRequest request, AsyncHandler<GetAlertRuleRequest, GetAlertRuleResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAlertRuleResponse::builder).logger(LOG, "getAlertRule").serviceDetails("Budget", "GetAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/GetAlertRule").method(Method.GET).requestBuilder(GetAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AlertRule.class, GetAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("etag", GetAlertRuleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAlertRuleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBudgetResponse> getBudget(GetBudgetRequest request, AsyncHandler<GetBudgetRequest, GetBudgetResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBudgetResponse::builder).logger(LOG, "getBudget").serviceDetails("Budget", "GetBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/GetBudget").method(Method.GET).requestBuilder(GetBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Budget.class, GetBudgetResponse.Builder::budget).handleResponseHeaderString("etag", GetBudgetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBudgetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAlertRulesResponse> listAlertRules(ListAlertRulesRequest request, AsyncHandler<ListAlertRulesRequest, ListAlertRulesResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAlertRulesResponse::builder).logger(LOG, "listAlertRules").serviceDetails("Budget", "ListAlertRules", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRuleSummary/ListAlertRules").method(Method.GET).requestBuilder(ListAlertRulesRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AlertRuleSummary.class, ListAlertRulesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListAlertRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAlertRulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListBudgetsResponse> listBudgets(ListBudgetsRequest request, AsyncHandler<ListBudgetsRequest, ListBudgetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListBudgetsResponse::builder).logger(LOG, "listBudgets").serviceDetails("Budget", "ListBudgets", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/BudgetSummary/ListBudgets").method(Method.GET).requestBuilder(ListBudgetsRequest::builder).basePath("/20190111").appendPathParam("budgets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("targetType", (BmcEnum)request.getTargetType()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(BudgetSummary.class, ListBudgetsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListBudgetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBudgetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateAlertRuleResponse> updateAlertRule(UpdateAlertRuleRequest request, AsyncHandler<UpdateAlertRuleRequest, UpdateAlertRuleResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAlertRuleId(), (String)"alertRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAlertRuleDetails(), "updateAlertRuleDetails is required");
        return this.clientCall(request, UpdateAlertRuleResponse::builder).logger(LOG, "updateAlertRule").serviceDetails("Budget", "UpdateAlertRule", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/AlertRule/UpdateAlertRule").method(Method.PUT).requestBuilder(UpdateAlertRuleRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).appendPathParam("alertRules").appendPathParam(request.getAlertRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AlertRule.class, UpdateAlertRuleResponse.Builder::alertRule).handleResponseHeaderString("opc-request-id", UpdateAlertRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateAlertRuleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest request, AsyncHandler<UpdateBudgetRequest, UpdateBudgetResponse> handler) {
        Validate.notBlank((String)request.getBudgetId(), (String)"budgetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBudgetDetails(), "updateBudgetDetails is required");
        return this.clientCall(request, UpdateBudgetResponse::builder).logger(LOG, "updateBudget").serviceDetails("Budget", "UpdateBudget", "https://docs.oracle.com/iaas/api/#/en/budgets/20190111/Budget/UpdateBudget").method(Method.PUT).requestBuilder(UpdateBudgetRequest::builder).basePath("/20190111").appendPathParam("budgets").appendPathParam(request.getBudgetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Budget.class, UpdateBudgetResponse.Builder::budget).handleResponseHeaderString("opc-request-id", UpdateBudgetResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateBudgetResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)BudgetAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(BudgetAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)BudgetAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)BudgetAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)BudgetAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)BudgetAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public BudgetAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)BudgetAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BudgetAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "budget";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"budget");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BudgetAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new BudgetAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

