/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.oracle.bmc.budget.Budget;
import com.oracle.bmc.budget.model.AlertRuleSummary;
import com.oracle.bmc.budget.model.BudgetSummary;
import com.oracle.bmc.budget.requests.ListAlertRulesRequest;
import com.oracle.bmc.budget.requests.ListBudgetsRequest;
import com.oracle.bmc.budget.responses.ListAlertRulesResponse;
import com.oracle.bmc.budget.responses.ListBudgetsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BudgetPaginators {
    private final Budget client;

    public BudgetPaginators(Budget client) {
        this.client = client;
    }

    public Iterable<ListAlertRulesResponse> listAlertRulesResponseIterator(final ListAlertRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAlertRulesRequest.Builder>(){

            @Override
            public ListAlertRulesRequest.Builder get() {
                return ListAlertRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, String>(){

            @Override
            public String apply(ListAlertRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertRulesRequest.Builder>, ListAlertRulesRequest>(){

            @Override
            public ListAlertRulesRequest apply(RequestBuilderAndToken<ListAlertRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlertRulesRequest, ListAlertRulesResponse>(){

            @Override
            public ListAlertRulesResponse apply(ListAlertRulesRequest request) {
                return BudgetPaginators.this.client.listAlertRules(request);
            }
        });
    }

    public Iterable<AlertRuleSummary> listAlertRulesRecordIterator(final ListAlertRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAlertRulesRequest.Builder>(){

            @Override
            public ListAlertRulesRequest.Builder get() {
                return ListAlertRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, String>(){

            @Override
            public String apply(ListAlertRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlertRulesRequest.Builder>, ListAlertRulesRequest>(){

            @Override
            public ListAlertRulesRequest apply(RequestBuilderAndToken<ListAlertRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlertRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlertRulesRequest, ListAlertRulesResponse>(){

            @Override
            public ListAlertRulesResponse apply(ListAlertRulesRequest request) {
                return BudgetPaginators.this.client.listAlertRules(request);
            }
        }, (Function)new Function<ListAlertRulesResponse, List<AlertRuleSummary>>(){

            @Override
            public List<AlertRuleSummary> apply(ListAlertRulesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBudgetsResponse> listBudgetsResponseIterator(final ListBudgetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBudgetsRequest.Builder>(){

            @Override
            public ListBudgetsRequest.Builder get() {
                return ListBudgetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBudgetsResponse, String>(){

            @Override
            public String apply(ListBudgetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBudgetsRequest.Builder>, ListBudgetsRequest>(){

            @Override
            public ListBudgetsRequest apply(RequestBuilderAndToken<ListBudgetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBudgetsRequest, ListBudgetsResponse>(){

            @Override
            public ListBudgetsResponse apply(ListBudgetsRequest request) {
                return BudgetPaginators.this.client.listBudgets(request);
            }
        });
    }

    public Iterable<BudgetSummary> listBudgetsRecordIterator(final ListBudgetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBudgetsRequest.Builder>(){

            @Override
            public ListBudgetsRequest.Builder get() {
                return ListBudgetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBudgetsResponse, String>(){

            @Override
            public String apply(ListBudgetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBudgetsRequest.Builder>, ListBudgetsRequest>(){

            @Override
            public ListBudgetsRequest apply(RequestBuilderAndToken<ListBudgetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBudgetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBudgetsRequest, ListBudgetsResponse>(){

            @Override
            public ListBudgetsResponse apply(ListBudgetsRequest request) {
                return BudgetPaginators.this.client.listBudgets(request);
            }
        }, (Function)new Function<ListBudgetsResponse, List<BudgetSummary>>(){

            @Override
            public List<BudgetSummary> apply(ListBudgetsResponse response) {
                return response.getItems();
            }
        });
    }
}

