/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget;

import com.oracle.bmc.budget.Budget;
import com.oracle.bmc.budget.model.LifecycleState;
import com.oracle.bmc.budget.requests.GetAlertRuleRequest;
import com.oracle.bmc.budget.requests.GetBudgetRequest;
import com.oracle.bmc.budget.responses.GetAlertRuleResponse;
import com.oracle.bmc.budget.responses.GetBudgetResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class BudgetWaiters {
    private final ExecutorService executorService;
    private final Budget client;

    public BudgetWaiters(ExecutorService executorService, Budget client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAlertRuleRequest, GetAlertRuleResponse> forAlertRule(GetAlertRuleRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlertRuleRequest, GetAlertRuleResponse> forAlertRule(GetAlertRuleRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlertRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlertRuleRequest, GetAlertRuleResponse> forAlertRule(GetAlertRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlertRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlertRuleRequest, GetAlertRuleResponse> forAlertRule(BmcGenericWaiter waiter, GetAlertRuleRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlertRuleRequest, GetAlertRuleResponse>(){

            @Override
            public GetAlertRuleResponse apply(GetAlertRuleRequest request) {
                return BudgetWaiters.this.client.getAlertRule(request);
            }
        }, (Predicate)new Predicate<GetAlertRuleResponse>(){

            @Override
            public boolean test(GetAlertRuleResponse response) {
                return targetStatesSet.contains((Object)response.getAlertRule().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetBudgetRequest, GetBudgetResponse> forBudget(GetBudgetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBudget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBudgetRequest, GetBudgetResponse> forBudget(GetBudgetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBudget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBudgetRequest, GetBudgetResponse> forBudget(GetBudgetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBudget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBudgetRequest, GetBudgetResponse> forBudget(BmcGenericWaiter waiter, GetBudgetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetBudgetRequest, GetBudgetResponse>(){

            @Override
            public GetBudgetResponse apply(GetBudgetRequest request) {
                return BudgetWaiters.this.client.getBudget(request);
            }
        }, (Predicate)new Predicate<GetBudgetResponse>(){

            @Override
            public boolean test(GetBudgetResponse response) {
                return targetStatesSet.contains((Object)response.getBudget().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

