/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.budget.model.LifecycleState;
import com.oracle.bmc.budget.model.ProcessingPeriodType;
import com.oracle.bmc.budget.model.ResetPeriod;
import com.oracle.bmc.budget.model.TargetType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Budget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetCompartmentId")
    private final String targetCompartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="amount")
    private final BigDecimal amount;
    @JsonProperty(value="resetPeriod")
    private final ResetPeriod resetPeriod;
    @JsonProperty(value="budgetProcessingPeriodStartOffset")
    private final Integer budgetProcessingPeriodStartOffset;
    @JsonProperty(value="processingPeriodType")
    private final ProcessingPeriodType processingPeriodType;
    @JsonProperty(value="startDate")
    private final Date startDate;
    @JsonProperty(value="endDate")
    private final Date endDate;
    @JsonProperty(value="targetType")
    private final TargetType targetType;
    @JsonProperty(value="targets")
    private final List<String> targets;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="alertRuleCount")
    private final Integer alertRuleCount;
    @JsonProperty(value="version")
    private final Integer version;
    @JsonProperty(value="actualSpend")
    private final BigDecimal actualSpend;
    @JsonProperty(value="forecastedSpend")
    private final BigDecimal forecastedSpend;
    @JsonProperty(value="timeSpendComputed")
    private final Date timeSpendComputed;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "targetCompartmentId", "displayName", "description", "amount", "resetPeriod", "budgetProcessingPeriodStartOffset", "processingPeriodType", "startDate", "endDate", "targetType", "targets", "lifecycleState", "alertRuleCount", "version", "actualSpend", "forecastedSpend", "timeSpendComputed", "timeCreated", "timeUpdated", "freeformTags", "definedTags"})
    public Budget(String id, String compartmentId, String targetCompartmentId, String displayName, String description, BigDecimal amount, ResetPeriod resetPeriod, Integer budgetProcessingPeriodStartOffset, ProcessingPeriodType processingPeriodType, Date startDate, Date endDate, TargetType targetType, List<String> targets, LifecycleState lifecycleState, Integer alertRuleCount, Integer version, BigDecimal actualSpend, BigDecimal forecastedSpend, Date timeSpendComputed, Date timeCreated, Date timeUpdated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.targetCompartmentId = targetCompartmentId;
        this.displayName = displayName;
        this.description = description;
        this.amount = amount;
        this.resetPeriod = resetPeriod;
        this.budgetProcessingPeriodStartOffset = budgetProcessingPeriodStartOffset;
        this.processingPeriodType = processingPeriodType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.targetType = targetType;
        this.targets = targets;
        this.lifecycleState = lifecycleState;
        this.alertRuleCount = alertRuleCount;
        this.version = version;
        this.actualSpend = actualSpend;
        this.forecastedSpend = forecastedSpend;
        this.timeSpendComputed = timeSpendComputed;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetCompartmentId() {
        return this.targetCompartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public ResetPeriod getResetPeriod() {
        return this.resetPeriod;
    }

    public Integer getBudgetProcessingPeriodStartOffset() {
        return this.budgetProcessingPeriodStartOffset;
    }

    public ProcessingPeriodType getProcessingPeriodType() {
        return this.processingPeriodType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getAlertRuleCount() {
        return this.alertRuleCount;
    }

    public Integer getVersion() {
        return this.version;
    }

    public BigDecimal getActualSpend() {
        return this.actualSpend;
    }

    public BigDecimal getForecastedSpend() {
        return this.forecastedSpend;
    }

    public Date getTimeSpendComputed() {
        return this.timeSpendComputed;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Budget(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetCompartmentId=").append(String.valueOf(this.targetCompartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", amount=").append(String.valueOf(this.amount));
        sb.append(", resetPeriod=").append(String.valueOf((Object)this.resetPeriod));
        sb.append(", budgetProcessingPeriodStartOffset=").append(String.valueOf(this.budgetProcessingPeriodStartOffset));
        sb.append(", processingPeriodType=").append(String.valueOf((Object)this.processingPeriodType));
        sb.append(", startDate=").append(String.valueOf(this.startDate));
        sb.append(", endDate=").append(String.valueOf(this.endDate));
        sb.append(", targetType=").append(String.valueOf((Object)this.targetType));
        sb.append(", targets=").append(String.valueOf(this.targets));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", alertRuleCount=").append(String.valueOf(this.alertRuleCount));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", actualSpend=").append(String.valueOf(this.actualSpend));
        sb.append(", forecastedSpend=").append(String.valueOf(this.forecastedSpend));
        sb.append(", timeSpendComputed=").append(String.valueOf(this.timeSpendComputed));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetCompartmentId, other.targetCompartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.amount, other.amount) && Objects.equals((Object)this.resetPeriod, (Object)other.resetPeriod) && Objects.equals(this.budgetProcessingPeriodStartOffset, other.budgetProcessingPeriodStartOffset) && Objects.equals((Object)this.processingPeriodType, (Object)other.processingPeriodType) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.endDate, other.endDate) && Objects.equals((Object)this.targetType, (Object)other.targetType) && Objects.equals(this.targets, other.targets) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.alertRuleCount, other.alertRuleCount) && Objects.equals(this.version, other.version) && Objects.equals(this.actualSpend, other.actualSpend) && Objects.equals(this.forecastedSpend, other.forecastedSpend) && Objects.equals(this.timeSpendComputed, other.timeSpendComputed) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetCompartmentId == null ? 43 : this.targetCompartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.amount == null ? 43 : this.amount.hashCode());
        result = result * 59 + (this.resetPeriod == null ? 43 : this.resetPeriod.hashCode());
        result = result * 59 + (this.budgetProcessingPeriodStartOffset == null ? 43 : this.budgetProcessingPeriodStartOffset.hashCode());
        result = result * 59 + (this.processingPeriodType == null ? 43 : this.processingPeriodType.hashCode());
        result = result * 59 + (this.startDate == null ? 43 : this.startDate.hashCode());
        result = result * 59 + (this.endDate == null ? 43 : this.endDate.hashCode());
        result = result * 59 + (this.targetType == null ? 43 : this.targetType.hashCode());
        result = result * 59 + (this.targets == null ? 43 : this.targets.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.alertRuleCount == null ? 43 : this.alertRuleCount.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.actualSpend == null ? 43 : this.actualSpend.hashCode());
        result = result * 59 + (this.forecastedSpend == null ? 43 : this.forecastedSpend.hashCode());
        result = result * 59 + (this.timeSpendComputed == null ? 43 : this.timeSpendComputed.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetCompartmentId")
        private String targetCompartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="amount")
        private BigDecimal amount;
        @JsonProperty(value="resetPeriod")
        private ResetPeriod resetPeriod;
        @JsonProperty(value="budgetProcessingPeriodStartOffset")
        private Integer budgetProcessingPeriodStartOffset;
        @JsonProperty(value="processingPeriodType")
        private ProcessingPeriodType processingPeriodType;
        @JsonProperty(value="startDate")
        private Date startDate;
        @JsonProperty(value="endDate")
        private Date endDate;
        @JsonProperty(value="targetType")
        private TargetType targetType;
        @JsonProperty(value="targets")
        private List<String> targets;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="alertRuleCount")
        private Integer alertRuleCount;
        @JsonProperty(value="version")
        private Integer version;
        @JsonProperty(value="actualSpend")
        private BigDecimal actualSpend;
        @JsonProperty(value="forecastedSpend")
        private BigDecimal forecastedSpend;
        @JsonProperty(value="timeSpendComputed")
        private Date timeSpendComputed;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetCompartmentId(String targetCompartmentId) {
            this.targetCompartmentId = targetCompartmentId;
            this.__explicitlySet__.add("targetCompartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            this.__explicitlySet__.add("amount");
            return this;
        }

        public Builder resetPeriod(ResetPeriod resetPeriod) {
            this.resetPeriod = resetPeriod;
            this.__explicitlySet__.add("resetPeriod");
            return this;
        }

        public Builder budgetProcessingPeriodStartOffset(Integer budgetProcessingPeriodStartOffset) {
            this.budgetProcessingPeriodStartOffset = budgetProcessingPeriodStartOffset;
            this.__explicitlySet__.add("budgetProcessingPeriodStartOffset");
            return this;
        }

        public Builder processingPeriodType(ProcessingPeriodType processingPeriodType) {
            this.processingPeriodType = processingPeriodType;
            this.__explicitlySet__.add("processingPeriodType");
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            this.__explicitlySet__.add("startDate");
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            this.__explicitlySet__.add("endDate");
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            this.__explicitlySet__.add("targetType");
            return this;
        }

        public Builder targets(List<String> targets) {
            this.targets = targets;
            this.__explicitlySet__.add("targets");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder alertRuleCount(Integer alertRuleCount) {
            this.alertRuleCount = alertRuleCount;
            this.__explicitlySet__.add("alertRuleCount");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder actualSpend(BigDecimal actualSpend) {
            this.actualSpend = actualSpend;
            this.__explicitlySet__.add("actualSpend");
            return this;
        }

        public Builder forecastedSpend(BigDecimal forecastedSpend) {
            this.forecastedSpend = forecastedSpend;
            this.__explicitlySet__.add("forecastedSpend");
            return this;
        }

        public Builder timeSpendComputed(Date timeSpendComputed) {
            this.timeSpendComputed = timeSpendComputed;
            this.__explicitlySet__.add("timeSpendComputed");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Budget build() {
            Budget model = new Budget(this.id, this.compartmentId, this.targetCompartmentId, this.displayName, this.description, this.amount, this.resetPeriod, this.budgetProcessingPeriodStartOffset, this.processingPeriodType, this.startDate, this.endDate, this.targetType, this.targets, this.lifecycleState, this.alertRuleCount, this.version, this.actualSpend, this.forecastedSpend, this.timeSpendComputed, this.timeCreated, this.timeUpdated, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Budget model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetCompartmentId")) {
                this.targetCompartmentId(model.getTargetCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("amount")) {
                this.amount(model.getAmount());
            }
            if (model.wasPropertyExplicitlySet("resetPeriod")) {
                this.resetPeriod(model.getResetPeriod());
            }
            if (model.wasPropertyExplicitlySet("budgetProcessingPeriodStartOffset")) {
                this.budgetProcessingPeriodStartOffset(model.getBudgetProcessingPeriodStartOffset());
            }
            if (model.wasPropertyExplicitlySet("processingPeriodType")) {
                this.processingPeriodType(model.getProcessingPeriodType());
            }
            if (model.wasPropertyExplicitlySet("startDate")) {
                this.startDate(model.getStartDate());
            }
            if (model.wasPropertyExplicitlySet("endDate")) {
                this.endDate(model.getEndDate());
            }
            if (model.wasPropertyExplicitlySet("targetType")) {
                this.targetType(model.getTargetType());
            }
            if (model.wasPropertyExplicitlySet("targets")) {
                this.targets(model.getTargets());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("alertRuleCount")) {
                this.alertRuleCount(model.getAlertRuleCount());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("actualSpend")) {
                this.actualSpend(model.getActualSpend());
            }
            if (model.wasPropertyExplicitlySet("forecastedSpend")) {
                this.forecastedSpend(model.getForecastedSpend());
            }
            if (model.wasPropertyExplicitlySet("timeSpendComputed")) {
                this.timeSpendComputed(model.getTimeSpendComputed());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

