/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.budget.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.budget.model.CreateAlertRuleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateAlertRuleRequest
extends BmcRequest<CreateAlertRuleDetails> {
    private String budgetId;
    private CreateAlertRuleDetails createAlertRuleDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getBudgetId() {
        return this.budgetId;
    }

    public CreateAlertRuleDetails getCreateAlertRuleDetails() {
        return this.createAlertRuleDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateAlertRuleDetails getBody$() {
        return this.createAlertRuleDetails;
    }

    public Builder toBuilder() {
        return new Builder().budgetId(this.budgetId).createAlertRuleDetails(this.createAlertRuleDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",budgetId=").append(String.valueOf(this.budgetId));
        sb.append(",createAlertRuleDetails=").append(String.valueOf((Object)this.createAlertRuleDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAlertRuleRequest)) {
            return false;
        }
        CreateAlertRuleRequest other = (CreateAlertRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.budgetId, other.budgetId) && Objects.equals((Object)this.createAlertRuleDetails, (Object)other.createAlertRuleDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.budgetId == null ? 43 : this.budgetId.hashCode());
        result = result * 59 + (this.createAlertRuleDetails == null ? 43 : this.createAlertRuleDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAlertRuleRequest, CreateAlertRuleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String budgetId = null;
        private CreateAlertRuleDetails createAlertRuleDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder createAlertRuleDetails(CreateAlertRuleDetails createAlertRuleDetails) {
            this.createAlertRuleDetails = createAlertRuleDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAlertRuleRequest o) {
            this.budgetId(o.getBudgetId());
            this.createAlertRuleDetails(o.getCreateAlertRuleDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAlertRuleRequest build() {
            CreateAlertRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateAlertRuleDetails body) {
            this.createAlertRuleDetails(body);
            return this;
        }

        public CreateAlertRuleRequest buildWithoutInvocationCallback() {
            CreateAlertRuleRequest request = new CreateAlertRuleRequest();
            request.budgetId = this.budgetId;
            request.createAlertRuleDetails = this.createAlertRuleDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

