/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.capacitymanagement.CapacityManagement;
import com.oracle.bmc.capacitymanagement.CapacityManagementPaginators;
import com.oracle.bmc.capacitymanagement.CapacityManagementWaiters;
import com.oracle.bmc.capacitymanagement.model.OccAvailabilityCatalog;
import com.oracle.bmc.capacitymanagement.model.OccAvailabilityCatalogCollection;
import com.oracle.bmc.capacitymanagement.model.OccAvailabilityCollection;
import com.oracle.bmc.capacitymanagement.model.OccCapacityRequest;
import com.oracle.bmc.capacitymanagement.model.OccCapacityRequestCollection;
import com.oracle.bmc.capacitymanagement.model.OccCustomer;
import com.oracle.bmc.capacitymanagement.model.OccCustomerGroup;
import com.oracle.bmc.capacitymanagement.model.OccCustomerGroupCollection;
import com.oracle.bmc.capacitymanagement.model.OccHandoverResourceBlockCollection;
import com.oracle.bmc.capacitymanagement.model.OccHandoverResourceBlockDetailCollection;
import com.oracle.bmc.capacitymanagement.model.OccOverviewCollection;
import com.oracle.bmc.capacitymanagement.requests.CreateOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.CreateOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.CreateOccCustomerGroupRequest;
import com.oracle.bmc.capacitymanagement.requests.CreateOccCustomerRequest;
import com.oracle.bmc.capacitymanagement.requests.DeleteOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.DeleteOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.DeleteOccCustomerGroupRequest;
import com.oracle.bmc.capacitymanagement.requests.DeleteOccCustomerRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccAvailabilityCatalogContentRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccCustomerGroupRequest;
import com.oracle.bmc.capacitymanagement.requests.ListInternalNamespaceOccOverviewsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListInternalOccHandoverResourceBlockDetailsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListInternalOccHandoverResourceBlocksRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccAvailabilitiesRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccAvailabilityCatalogsInternalRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccAvailabilityCatalogsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccCapacityRequestsInternalRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccCapacityRequestsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccCustomerGroupsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccHandoverResourceBlockDetailsRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccHandoverResourceBlocksRequest;
import com.oracle.bmc.capacitymanagement.requests.ListOccOverviewsRequest;
import com.oracle.bmc.capacitymanagement.requests.PatchInternalOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.PatchOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.PublishOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.UpdateInternalOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.UpdateOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.UpdateOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.UpdateOccCustomerGroupRequest;
import com.oracle.bmc.capacitymanagement.requests.UpdateOccCustomerRequest;
import com.oracle.bmc.capacitymanagement.responses.CreateOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.CreateOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.CreateOccCustomerGroupResponse;
import com.oracle.bmc.capacitymanagement.responses.CreateOccCustomerResponse;
import com.oracle.bmc.capacitymanagement.responses.DeleteOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.DeleteOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.DeleteOccCustomerGroupResponse;
import com.oracle.bmc.capacitymanagement.responses.DeleteOccCustomerResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccAvailabilityCatalogContentResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccCustomerGroupResponse;
import com.oracle.bmc.capacitymanagement.responses.ListInternalNamespaceOccOverviewsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListInternalOccHandoverResourceBlockDetailsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListInternalOccHandoverResourceBlocksResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccAvailabilitiesResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccAvailabilityCatalogsInternalResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccAvailabilityCatalogsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccCapacityRequestsInternalResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccCapacityRequestsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccCustomerGroupsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccHandoverResourceBlockDetailsResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccHandoverResourceBlocksResponse;
import com.oracle.bmc.capacitymanagement.responses.ListOccOverviewsResponse;
import com.oracle.bmc.capacitymanagement.responses.PatchInternalOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.PatchOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.PublishOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.UpdateInternalOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.UpdateOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.UpdateOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.UpdateOccCustomerGroupResponse;
import com.oracle.bmc.capacitymanagement.responses.UpdateOccCustomerResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityManagementClient
extends BaseSyncClient
implements CapacityManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CAPACITYMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://control-center-cp.{region}.oci.{secondLevelDomain}").endpointServiceName("control-center-cp").build();
    private static final Logger LOG = LoggerFactory.getLogger(CapacityManagementClient.class);
    private final CapacityManagementWaiters waiters;
    private final CapacityManagementPaginators paginators;

    CapacityManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    CapacityManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("CapacityManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new CapacityManagementWaiters(executorService, this);
        this.paginators = new CapacityManagementPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"CapacityManagementClient", (String)"getOccAvailabilityCatalogContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateOccAvailabilityCatalogResponse createOccAvailabilityCatalog(CreateOccAvailabilityCatalogRequest request) {
        Objects.requireNonNull(request.getCreateOccAvailabilityCatalogDetails(), "createOccAvailabilityCatalogDetails is required");
        return (CreateOccAvailabilityCatalogResponse)this.clientCall(request, CreateOccAvailabilityCatalogResponse::builder).logger(LOG, "createOccAvailabilityCatalog").serviceDetails("CapacityManagement", "CreateOccAvailabilityCatalog", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/CreateOccAvailabilityCatalog").method(Method.POST).requestBuilder(CreateOccAvailabilityCatalogRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccAvailabilityCatalog.class, CreateOccAvailabilityCatalogResponse.Builder::occAvailabilityCatalog).handleResponseHeaderString("etag", CreateOccAvailabilityCatalogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccAvailabilityCatalogResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", CreateOccAvailabilityCatalogResponse.Builder::retryAfter).callSync();
    }

    @Override
    public CreateOccCapacityRequestResponse createOccCapacityRequest(CreateOccCapacityRequestRequest request) {
        Objects.requireNonNull(request.getCreateOccCapacityRequestDetails(), "createOccCapacityRequestDetails is required");
        return (CreateOccCapacityRequestResponse)this.clientCall(request, CreateOccCapacityRequestResponse::builder).logger(LOG, "createOccCapacityRequest").serviceDetails("CapacityManagement", "CreateOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/CreateOccCapacityRequest").method(Method.POST).requestBuilder(CreateOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCapacityRequest.class, CreateOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("etag", CreateOccCapacityRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", CreateOccCapacityRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public CreateOccCustomerResponse createOccCustomer(CreateOccCustomerRequest request) {
        Objects.requireNonNull(request.getCreateOccCustomerDetails(), "createOccCustomerDetails is required");
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        return (CreateOccCustomerResponse)this.clientCall(request, CreateOccCustomerResponse::builder).logger(LOG, "createOccCustomer").serviceDetails("CapacityManagement", "CreateOccCustomer", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomer/CreateOccCustomer").method(Method.POST).requestBuilder(CreateOccCustomerRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).appendPathParam("occCustomers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCustomer.class, CreateOccCustomerResponse.Builder::occCustomer).handleResponseHeaderString("etag", CreateOccCustomerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccCustomerResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", CreateOccCustomerResponse.Builder::retryAfter).callSync();
    }

    @Override
    public CreateOccCustomerGroupResponse createOccCustomerGroup(CreateOccCustomerGroupRequest request) {
        Objects.requireNonNull(request.getCreateOccCustomerGroupDetails(), "createOccCustomerGroupDetails is required");
        return (CreateOccCustomerGroupResponse)this.clientCall(request, CreateOccCustomerGroupResponse::builder).logger(LOG, "createOccCustomerGroup").serviceDetails("CapacityManagement", "CreateOccCustomerGroup", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomerGroup/CreateOccCustomerGroup").method(Method.POST).requestBuilder(CreateOccCustomerGroupRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCustomerGroup.class, CreateOccCustomerGroupResponse.Builder::occCustomerGroup).handleResponseHeaderString("etag", CreateOccCustomerGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccCustomerGroupResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", CreateOccCustomerGroupResponse.Builder::retryAfter).callSync();
    }

    @Override
    public DeleteOccAvailabilityCatalogResponse deleteOccAvailabilityCatalog(DeleteOccAvailabilityCatalogRequest request) {
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (DeleteOccAvailabilityCatalogResponse)this.clientCall(request, DeleteOccAvailabilityCatalogResponse::builder).logger(LOG, "deleteOccAvailabilityCatalog").serviceDetails("CapacityManagement", "DeleteOccAvailabilityCatalog", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/DeleteOccAvailabilityCatalog").method(Method.DELETE).requestBuilder(DeleteOccAvailabilityCatalogRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteOccAvailabilityCatalogResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", DeleteOccAvailabilityCatalogResponse.Builder::retryAfter).callSync();
    }

    @Override
    public DeleteOccCapacityRequestResponse deleteOccCapacityRequest(DeleteOccCapacityRequestRequest request) {
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (DeleteOccCapacityRequestResponse)this.clientCall(request, DeleteOccCapacityRequestResponse::builder).logger(LOG, "deleteOccCapacityRequest").serviceDetails("CapacityManagement", "DeleteOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/DeleteOccCapacityRequest").method(Method.DELETE).requestBuilder(DeleteOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", DeleteOccCapacityRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public DeleteOccCustomerResponse deleteOccCustomer(DeleteOccCustomerRequest request) {
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOccCustomerId(), (String)"occCustomerId must not be blank", (Object[])new Object[0]);
        return (DeleteOccCustomerResponse)this.clientCall(request, DeleteOccCustomerResponse::builder).logger(LOG, "deleteOccCustomer").serviceDetails("CapacityManagement", "DeleteOccCustomer", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomer/DeleteOccCustomer").method(Method.DELETE).requestBuilder(DeleteOccCustomerRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).appendPathParam("occCustomers").appendPathParam(request.getOccCustomerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteOccCustomerResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", DeleteOccCustomerResponse.Builder::retryAfter).callSync();
    }

    @Override
    public DeleteOccCustomerGroupResponse deleteOccCustomerGroup(DeleteOccCustomerGroupRequest request) {
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteOccCustomerGroupResponse)this.clientCall(request, DeleteOccCustomerGroupResponse::builder).logger(LOG, "deleteOccCustomerGroup").serviceDetails("CapacityManagement", "DeleteOccCustomerGroup", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomerGroup/DeleteOccCustomerGroup").method(Method.DELETE).requestBuilder(DeleteOccCustomerGroupRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteOccCustomerGroupResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", DeleteOccCustomerGroupResponse.Builder::retryAfter).callSync();
    }

    @Override
    public GetOccAvailabilityCatalogResponse getOccAvailabilityCatalog(GetOccAvailabilityCatalogRequest request) {
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (GetOccAvailabilityCatalogResponse)this.clientCall(request, GetOccAvailabilityCatalogResponse::builder).logger(LOG, "getOccAvailabilityCatalog").serviceDetails("CapacityManagement", "GetOccAvailabilityCatalog", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/GetOccAvailabilityCatalog").method(Method.GET).requestBuilder(GetOccAvailabilityCatalogRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccAvailabilityCatalog.class, GetOccAvailabilityCatalogResponse.Builder::occAvailabilityCatalog).handleResponseHeaderString("etag", GetOccAvailabilityCatalogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOccAvailabilityCatalogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOccAvailabilityCatalogContentResponse getOccAvailabilityCatalogContent(GetOccAvailabilityCatalogContentRequest request) {
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (GetOccAvailabilityCatalogContentResponse)this.clientCall(request, GetOccAvailabilityCatalogContentResponse::builder).logger(LOG, "getOccAvailabilityCatalogContent").serviceDetails("CapacityManagement", "GetOccAvailabilityCatalogContent", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/GetOccAvailabilityCatalogContent").method(Method.GET).requestBuilder(GetOccAvailabilityCatalogContentRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).appendPathParam("content").accept(new String[]{"application/binary"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleBody(InputStream.class, GetOccAvailabilityCatalogContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetOccAvailabilityCatalogContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOccCapacityRequestResponse getOccCapacityRequest(GetOccCapacityRequestRequest request) {
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (GetOccCapacityRequestResponse)this.clientCall(request, GetOccCapacityRequestResponse::builder).logger(LOG, "getOccCapacityRequest").serviceDetails("CapacityManagement", "GetOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/GetOccCapacityRequest").method(Method.GET).requestBuilder(GetOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccCapacityRequest.class, GetOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("etag", GetOccCapacityRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOccCapacityRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOccCustomerGroupResponse getOccCustomerGroup(GetOccCustomerGroupRequest request) {
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        return (GetOccCustomerGroupResponse)this.clientCall(request, GetOccCustomerGroupResponse::builder).logger(LOG, "getOccCustomerGroup").serviceDetails("CapacityManagement", "GetOccCustomerGroup", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomerGroup/GetOccCustomerGroup").method(Method.GET).requestBuilder(GetOccCustomerGroupRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccCustomerGroup.class, GetOccCustomerGroupResponse.Builder::occCustomerGroup).handleResponseHeaderString("etag", GetOccCustomerGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOccCustomerGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListInternalNamespaceOccOverviewsResponse listInternalNamespaceOccOverviews(ListInternalNamespaceOccOverviewsRequest request) {
        Validate.notBlank((String)request.getNamespace().getValue(), (String)"namespace must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getOccCustomerGroupId(), "occCustomerGroupId is required");
        return (ListInternalNamespaceOccOverviewsResponse)this.clientCall(request, ListInternalNamespaceOccOverviewsResponse::builder).logger(LOG, "listInternalNamespaceOccOverviews").serviceDetails("CapacityManagement", "ListInternalNamespaceOccOverviews", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccOverviewCollection/ListInternalNamespaceOccOverviews").method(Method.GET).requestBuilder(ListInternalNamespaceOccOverviewsRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("namespace").appendPathParam(request.getNamespace().getValue()).appendPathParam("occOverview").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("occCustomerGroupId", (Object)request.getOccCustomerGroupId()).appendQueryParam("workloadType", (Object)request.getWorkloadType()).appendQueryParam("from", (Object)request.getFrom()).appendQueryParam("to", (Object)request.getTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccOverviewCollection.class, ListInternalNamespaceOccOverviewsResponse.Builder::occOverviewCollection).handleResponseHeaderString("opc-request-id", ListInternalNamespaceOccOverviewsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInternalNamespaceOccOverviewsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListInternalOccHandoverResourceBlockDetailsResponse listInternalOccHandoverResourceBlockDetails(ListInternalOccHandoverResourceBlockDetailsRequest request) {
        Objects.requireNonNull(request.getOccHandoverResourceBlockId(), "occHandoverResourceBlockId is required");
        return (ListInternalOccHandoverResourceBlockDetailsResponse)this.clientCall(request, ListInternalOccHandoverResourceBlockDetailsResponse::builder).logger(LOG, "listInternalOccHandoverResourceBlockDetails").serviceDetails("CapacityManagement", "ListInternalOccHandoverResourceBlockDetails", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccHandoverResourceBlockDetailCollection/ListInternalOccHandoverResourceBlockDetails").method(Method.GET).requestBuilder(ListInternalOccHandoverResourceBlockDetailsRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occHandoverResourceBlockDetails").appendQueryParam("occHandoverResourceBlockId", (Object)request.getOccHandoverResourceBlockId()).appendQueryParam("hostId", (Object)request.getHostId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccHandoverResourceBlockDetailCollection.class, ListInternalOccHandoverResourceBlockDetailsResponse.Builder::occHandoverResourceBlockDetailCollection).handleResponseHeaderString("opc-request-id", ListInternalOccHandoverResourceBlockDetailsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInternalOccHandoverResourceBlockDetailsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListInternalOccHandoverResourceBlocksResponse listInternalOccHandoverResourceBlocks(ListInternalOccHandoverResourceBlocksRequest request) {
        Objects.requireNonNull(request.getNamespace(), "namespace is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getOccCustomerGroupId(), "occCustomerGroupId is required");
        return (ListInternalOccHandoverResourceBlocksResponse)this.clientCall(request, ListInternalOccHandoverResourceBlocksResponse::builder).logger(LOG, "listInternalOccHandoverResourceBlocks").serviceDetails("CapacityManagement", "ListInternalOccHandoverResourceBlocks", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccHandoverResourceBlockCollection/ListInternalOccHandoverResourceBlocks").method(Method.GET).requestBuilder(ListInternalOccHandoverResourceBlocksRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occHandoverResourceBlocks").appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("occCustomerGroupId", (Object)request.getOccCustomerGroupId()).appendQueryParam("handoverResourceName", (Object)request.getHandoverResourceName()).appendQueryParam("handoverDateGreaterThanOrEqualTo", (Object)request.getHandoverDateGreaterThanOrEqualTo()).appendQueryParam("handoverDateLessThanOrEqualTo", (Object)request.getHandoverDateLessThanOrEqualTo()).appendQueryParam("occHandoverResourceBlockId", (Object)request.getOccHandoverResourceBlockId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccHandoverResourceBlockCollection.class, ListInternalOccHandoverResourceBlocksResponse.Builder::occHandoverResourceBlockCollection).handleResponseHeaderString("opc-request-id", ListInternalOccHandoverResourceBlocksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInternalOccHandoverResourceBlocksResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccAvailabilitiesResponse listOccAvailabilities(ListOccAvailabilitiesRequest request) {
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (ListOccAvailabilitiesResponse)this.clientCall(request, ListOccAvailabilitiesResponse::builder).logger(LOG, "listOccAvailabilities").serviceDetails("CapacityManagement", "ListOccAvailabilities", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCollection/ListOccAvailabilities").method(Method.GET).requestBuilder(ListOccAvailabilitiesRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).appendPathParam("occAvailabilities").appendQueryParam("dateExpectedCapacityHandover", (Object)request.getDateExpectedCapacityHandover()).appendQueryParam("resourceName", (Object)request.getResourceName()).appendQueryParam("resourceType", (Object)request.getResourceType()).appendQueryParam("workloadType", (Object)request.getWorkloadType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccAvailabilityCollection.class, ListOccAvailabilitiesResponse.Builder::occAvailabilityCollection).handleResponseHeaderString("opc-request-id", ListOccAvailabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccAvailabilitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccAvailabilityCatalogsResponse listOccAvailabilityCatalogs(ListOccAvailabilityCatalogsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOccAvailabilityCatalogsResponse)this.clientCall(request, ListOccAvailabilityCatalogsResponse::builder).logger(LOG, "listOccAvailabilityCatalogs").serviceDetails("CapacityManagement", "ListOccAvailabilityCatalogs", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalogCollection/ListOccAvailabilityCatalogs").method(Method.GET).requestBuilder(ListOccAvailabilityCatalogsRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("catalogState", (BmcEnum)request.getCatalogState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccAvailabilityCatalogCollection.class, ListOccAvailabilityCatalogsResponse.Builder::occAvailabilityCatalogCollection).handleResponseHeaderString("opc-request-id", ListOccAvailabilityCatalogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccAvailabilityCatalogsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccAvailabilityCatalogsInternalResponse listOccAvailabilityCatalogsInternal(ListOccAvailabilityCatalogsInternalRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getOccCustomerGroupId(), "occCustomerGroupId is required");
        return (ListOccAvailabilityCatalogsInternalResponse)this.clientCall(request, ListOccAvailabilityCatalogsInternalResponse::builder).logger(LOG, "listOccAvailabilityCatalogsInternal").serviceDetails("CapacityManagement", "ListOccAvailabilityCatalogsInternal", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalogCollection/ListOccAvailabilityCatalogsInternal").method(Method.GET).requestBuilder(ListOccAvailabilityCatalogsInternalRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occAvailabilityCatalogs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("catalogState", (BmcEnum)request.getCatalogState()).appendQueryParam("occCustomerGroupId", (Object)request.getOccCustomerGroupId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccAvailabilityCatalogCollection.class, ListOccAvailabilityCatalogsInternalResponse.Builder::occAvailabilityCatalogCollection).handleResponseHeaderString("opc-request-id", ListOccAvailabilityCatalogsInternalResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccAvailabilityCatalogsInternalResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccCapacityRequestsResponse listOccCapacityRequests(ListOccCapacityRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOccCapacityRequestsResponse)this.clientCall(request, ListOccCapacityRequestsResponse::builder).logger(LOG, "listOccCapacityRequests").serviceDetails("CapacityManagement", "ListOccCapacityRequests", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequestCollection/ListOccCapacityRequests").method(Method.GET).requestBuilder(ListOccCapacityRequestsRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("occAvailabilityCatalogId", (Object)request.getOccAvailabilityCatalogId()).appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendEnumQueryParam("requestType", (BmcEnum)request.getRequestType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccCapacityRequestCollection.class, ListOccCapacityRequestsResponse.Builder::occCapacityRequestCollection).handleResponseHeaderString("opc-request-id", ListOccCapacityRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccCapacityRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccCapacityRequestsInternalResponse listOccCapacityRequestsInternal(ListOccCapacityRequestsInternalRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getOccCustomerGroupId(), "occCustomerGroupId is required");
        return (ListOccCapacityRequestsInternalResponse)this.clientCall(request, ListOccCapacityRequestsInternalResponse::builder).logger(LOG, "listOccCapacityRequestsInternal").serviceDetails("CapacityManagement", "ListOccCapacityRequestsInternal", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequestCollection/ListOccCapacityRequestsInternal").method(Method.GET).requestBuilder(ListOccCapacityRequestsInternalRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occCapacityRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("occCustomerGroupId", (Object)request.getOccCustomerGroupId()).appendQueryParam("occAvailabilityCatalogId", (Object)request.getOccAvailabilityCatalogId()).appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("requestType", (BmcEnum)request.getRequestType()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccCapacityRequestCollection.class, ListOccCapacityRequestsInternalResponse.Builder::occCapacityRequestCollection).handleResponseHeaderString("opc-request-id", ListOccCapacityRequestsInternalResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccCapacityRequestsInternalResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccCustomerGroupsResponse listOccCustomerGroups(ListOccCustomerGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOccCustomerGroupsResponse)this.clientCall(request, ListOccCustomerGroupsResponse::builder).logger(LOG, "listOccCustomerGroups").serviceDetails("CapacityManagement", "ListOccCustomerGroups", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomerGroupCollection/ListOccCustomerGroups").method(Method.GET).requestBuilder(ListOccCustomerGroupsRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccCustomerGroupCollection.class, ListOccCustomerGroupsResponse.Builder::occCustomerGroupCollection).handleResponseHeaderString("opc-request-id", ListOccCustomerGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccCustomerGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccHandoverResourceBlockDetailsResponse listOccHandoverResourceBlockDetails(ListOccHandoverResourceBlockDetailsRequest request) {
        Objects.requireNonNull(request.getOccHandoverResourceBlockId(), "occHandoverResourceBlockId is required");
        return (ListOccHandoverResourceBlockDetailsResponse)this.clientCall(request, ListOccHandoverResourceBlockDetailsResponse::builder).logger(LOG, "listOccHandoverResourceBlockDetails").serviceDetails("CapacityManagement", "ListOccHandoverResourceBlockDetails", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccHandoverResourceBlockDetailCollection/ListOccHandoverResourceBlockDetails").method(Method.GET).requestBuilder(ListOccHandoverResourceBlockDetailsRequest::builder).basePath("/20231107").appendPathParam("occHandoverResourceBlockDetails").appendQueryParam("occHandoverResourceBlockId", (Object)request.getOccHandoverResourceBlockId()).appendQueryParam("hostId", (Object)request.getHostId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccHandoverResourceBlockDetailCollection.class, ListOccHandoverResourceBlockDetailsResponse.Builder::occHandoverResourceBlockDetailCollection).handleResponseHeaderString("opc-request-id", ListOccHandoverResourceBlockDetailsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccHandoverResourceBlockDetailsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccHandoverResourceBlocksResponse listOccHandoverResourceBlocks(ListOccHandoverResourceBlocksRequest request) {
        return (ListOccHandoverResourceBlocksResponse)this.clientCall(request, ListOccHandoverResourceBlocksResponse::builder).logger(LOG, "listOccHandoverResourceBlocks").serviceDetails("CapacityManagement", "ListOccHandoverResourceBlocks", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccHandoverResourceBlockCollection/ListOccHandoverResourceBlocks").method(Method.GET).requestBuilder(ListOccHandoverResourceBlocksRequest::builder).basePath("/20231107").appendPathParam("occHandoverResourceBlocks").appendEnumQueryParam("namespace", (BmcEnum)request.getNamespace()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("handoverResourceName", (Object)request.getHandoverResourceName()).appendQueryParam("handoverDateGreaterThanOrEqualTo", (Object)request.getHandoverDateGreaterThanOrEqualTo()).appendQueryParam("handoverDateLessThanOrEqualTo", (Object)request.getHandoverDateLessThanOrEqualTo()).appendQueryParam("occHandoverResourceBlockId", (Object)request.getOccHandoverResourceBlockId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccHandoverResourceBlockCollection.class, ListOccHandoverResourceBlocksResponse.Builder::occHandoverResourceBlockCollection).handleResponseHeaderString("opc-request-id", ListOccHandoverResourceBlocksResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccHandoverResourceBlocksResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListOccOverviewsResponse listOccOverviews(ListOccOverviewsRequest request) {
        Validate.notBlank((String)request.getNamespace().getValue(), (String)"namespace must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOccOverviewsResponse)this.clientCall(request, ListOccOverviewsResponse::builder).logger(LOG, "listOccOverviews").serviceDetails("CapacityManagement", "ListOccOverviews", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccOverviewCollection/ListOccOverviews").method(Method.GET).requestBuilder(ListOccOverviewsRequest::builder).basePath("/20231107").appendPathParam("namespace").appendPathParam(request.getNamespace().getValue()).appendPathParam("occOverview").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("from", (Object)request.getFrom()).appendQueryParam("to", (Object)request.getTo()).appendQueryParam("workloadType", (Object)request.getWorkloadType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccOverviewCollection.class, ListOccOverviewsResponse.Builder::occOverviewCollection).handleResponseHeaderString("opc-request-id", ListOccOverviewsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccOverviewsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PatchInternalOccCapacityRequestResponse patchInternalOccCapacityRequest(PatchInternalOccCapacityRequestRequest request) {
        Objects.requireNonNull(request.getPatchOccCapacityRequestDetails(), "patchOccCapacityRequestDetails is required");
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (PatchInternalOccCapacityRequestResponse)this.clientCall(request, PatchInternalOccCapacityRequestResponse::builder).logger(LOG, "patchInternalOccCapacityRequest").serviceDetails("CapacityManagement", "PatchInternalOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/PatchInternalOccCapacityRequest").method(Method.PATCH).requestBuilder(PatchInternalOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCapacityRequest.class, PatchInternalOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("opc-request-id", PatchInternalOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PatchInternalOccCapacityRequestResponse.Builder::etag).callSync();
    }

    @Override
    public PatchOccCapacityRequestResponse patchOccCapacityRequest(PatchOccCapacityRequestRequest request) {
        Objects.requireNonNull(request.getPatchOccCapacityRequestDetails(), "patchOccCapacityRequestDetails is required");
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (PatchOccCapacityRequestResponse)this.clientCall(request, PatchOccCapacityRequestResponse::builder).logger(LOG, "patchOccCapacityRequest").serviceDetails("CapacityManagement", "PatchOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/PatchOccCapacityRequest").method(Method.PATCH).requestBuilder(PatchOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCapacityRequest.class, PatchOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("opc-request-id", PatchOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PatchOccCapacityRequestResponse.Builder::etag).callSync();
    }

    @Override
    public PublishOccAvailabilityCatalogResponse publishOccAvailabilityCatalog(PublishOccAvailabilityCatalogRequest request) {
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (PublishOccAvailabilityCatalogResponse)this.clientCall(request, PublishOccAvailabilityCatalogResponse::builder).logger(LOG, "publishOccAvailabilityCatalog").serviceDetails("CapacityManagement", "PublishOccAvailabilityCatalog", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/PublishOccAvailabilityCatalog").method(Method.POST).requestBuilder(PublishOccAvailabilityCatalogRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).appendPathParam("actions").appendPathParam("publish").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", PublishOccAvailabilityCatalogResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateInternalOccCapacityRequestResponse updateInternalOccCapacityRequest(UpdateInternalOccCapacityRequestRequest request) {
        Objects.requireNonNull(request.getUpdateInternalOccCapacityRequestDetails(), "updateInternalOccCapacityRequestDetails is required");
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (UpdateInternalOccCapacityRequestResponse)this.clientCall(request, UpdateInternalOccCapacityRequestResponse::builder).logger(LOG, "updateInternalOccCapacityRequest").serviceDetails("CapacityManagement", "UpdateInternalOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/UpdateInternalOccCapacityRequest").method(Method.PUT).requestBuilder(UpdateInternalOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("internal").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCapacityRequest.class, UpdateInternalOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("etag", UpdateInternalOccCapacityRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInternalOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", UpdateInternalOccCapacityRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public UpdateOccAvailabilityCatalogResponse updateOccAvailabilityCatalog(UpdateOccAvailabilityCatalogRequest request) {
        Objects.requireNonNull(request.getUpdateOccAvailabilityCatalogDetails(), "updateOccAvailabilityCatalogDetails is required");
        Validate.notBlank((String)request.getOccAvailabilityCatalogId(), (String)"occAvailabilityCatalogId must not be blank", (Object[])new Object[0]);
        return (UpdateOccAvailabilityCatalogResponse)this.clientCall(request, UpdateOccAvailabilityCatalogResponse::builder).logger(LOG, "updateOccAvailabilityCatalog").serviceDetails("CapacityManagement", "UpdateOccAvailabilityCatalog", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccAvailabilityCatalog/UpdateOccAvailabilityCatalog").method(Method.PUT).requestBuilder(UpdateOccAvailabilityCatalogRequest::builder).basePath("/20231107").appendPathParam("occAvailabilityCatalogs").appendPathParam(request.getOccAvailabilityCatalogId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccAvailabilityCatalog.class, UpdateOccAvailabilityCatalogResponse.Builder::occAvailabilityCatalog).handleResponseHeaderString("etag", UpdateOccAvailabilityCatalogResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccAvailabilityCatalogResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", UpdateOccAvailabilityCatalogResponse.Builder::retryAfter).callSync();
    }

    @Override
    public UpdateOccCapacityRequestResponse updateOccCapacityRequest(UpdateOccCapacityRequestRequest request) {
        Objects.requireNonNull(request.getUpdateOccCapacityRequestDetails(), "updateOccCapacityRequestDetails is required");
        Validate.notBlank((String)request.getOccCapacityRequestId(), (String)"occCapacityRequestId must not be blank", (Object[])new Object[0]);
        return (UpdateOccCapacityRequestResponse)this.clientCall(request, UpdateOccCapacityRequestResponse::builder).logger(LOG, "updateOccCapacityRequest").serviceDetails("CapacityManagement", "UpdateOccCapacityRequest", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCapacityRequest/UpdateOccCapacityRequest").method(Method.PUT).requestBuilder(UpdateOccCapacityRequestRequest::builder).basePath("/20231107").appendPathParam("occCapacityRequests").appendPathParam(request.getOccCapacityRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCapacityRequest.class, UpdateOccCapacityRequestResponse.Builder::occCapacityRequest).handleResponseHeaderString("etag", UpdateOccCapacityRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccCapacityRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", UpdateOccCapacityRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public UpdateOccCustomerResponse updateOccCustomer(UpdateOccCustomerRequest request) {
        Objects.requireNonNull(request.getUpdateOccCustomerDetails(), "updateOccCustomerDetails is required");
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getOccCustomerId(), (String)"occCustomerId must not be blank", (Object[])new Object[0]);
        return (UpdateOccCustomerResponse)this.clientCall(request, UpdateOccCustomerResponse::builder).logger(LOG, "updateOccCustomer").serviceDetails("CapacityManagement", "UpdateOccCustomer", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomer/UpdateOccCustomer").method(Method.PUT).requestBuilder(UpdateOccCustomerRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).appendPathParam("occCustomers").appendPathParam(request.getOccCustomerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCustomer.class, UpdateOccCustomerResponse.Builder::occCustomer).handleResponseHeaderString("etag", UpdateOccCustomerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccCustomerResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", UpdateOccCustomerResponse.Builder::retryAfter).callSync();
    }

    @Override
    public UpdateOccCustomerGroupResponse updateOccCustomerGroup(UpdateOccCustomerGroupRequest request) {
        Objects.requireNonNull(request.getUpdateOccCustomerGroupDetails(), "updateOccCustomerGroupDetails is required");
        Validate.notBlank((String)request.getOccCustomerGroupId(), (String)"occCustomerGroupId must not be blank", (Object[])new Object[0]);
        return (UpdateOccCustomerGroupResponse)this.clientCall(request, UpdateOccCustomerGroupResponse::builder).logger(LOG, "updateOccCustomerGroup").serviceDetails("CapacityManagement", "UpdateOccCustomerGroup", "https://docs.oracle.com/iaas/api/#/en/occcm/20231107/OccCustomerGroup/UpdateOccCustomerGroup").method(Method.PUT).requestBuilder(UpdateOccCustomerGroupRequest::builder).basePath("/20231107").appendPathParam("occCustomerGroups").appendPathParam(request.getOccCustomerGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(OccCustomerGroup.class, UpdateOccCustomerGroupResponse.Builder::occCustomerGroup).handleResponseHeaderString("etag", UpdateOccCustomerGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccCustomerGroupResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", UpdateOccCustomerGroupResponse.Builder::retryAfter).callSync();
    }

    @Override
    public CapacityManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public CapacityManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public CapacityManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)CapacityManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(CapacityManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public CapacityManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CapacityManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CapacityManagementClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "capacitymanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"capacitymanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public CapacityManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new CapacityManagementClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

