/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement;

import com.oracle.bmc.capacitymanagement.CapacityManagement;
import com.oracle.bmc.capacitymanagement.model.OccAvailabilityCatalog;
import com.oracle.bmc.capacitymanagement.model.OccCapacityRequest;
import com.oracle.bmc.capacitymanagement.model.OccCustomerGroup;
import com.oracle.bmc.capacitymanagement.requests.GetOccAvailabilityCatalogRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccCapacityRequestRequest;
import com.oracle.bmc.capacitymanagement.requests.GetOccCustomerGroupRequest;
import com.oracle.bmc.capacitymanagement.responses.GetOccAvailabilityCatalogResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccCapacityRequestResponse;
import com.oracle.bmc.capacitymanagement.responses.GetOccCustomerGroupResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class CapacityManagementWaiters {
    private final ExecutorService executorService;
    private final CapacityManagement client;

    public CapacityManagementWaiters(ExecutorService executorService, CapacityManagement client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOccAvailabilityCatalogRequest, GetOccAvailabilityCatalogResponse> forOccAvailabilityCatalog(GetOccAvailabilityCatalogRequest request, OccAvailabilityCatalog.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOccAvailabilityCatalog(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOccAvailabilityCatalogRequest, GetOccAvailabilityCatalogResponse> forOccAvailabilityCatalog(GetOccAvailabilityCatalogRequest request, OccAvailabilityCatalog.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOccAvailabilityCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOccAvailabilityCatalogRequest, GetOccAvailabilityCatalogResponse> forOccAvailabilityCatalog(GetOccAvailabilityCatalogRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OccAvailabilityCatalog.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOccAvailabilityCatalog(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOccAvailabilityCatalogRequest, GetOccAvailabilityCatalogResponse> forOccAvailabilityCatalog(BmcGenericWaiter waiter, GetOccAvailabilityCatalogRequest request, OccAvailabilityCatalog.LifecycleState ... targetStates) {
        final HashSet<OccAvailabilityCatalog.LifecycleState> targetStatesSet = new HashSet<OccAvailabilityCatalog.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOccAvailabilityCatalogRequest, GetOccAvailabilityCatalogResponse>(){

            @Override
            public GetOccAvailabilityCatalogResponse apply(GetOccAvailabilityCatalogRequest request) {
                return CapacityManagementWaiters.this.client.getOccAvailabilityCatalog(request);
            }
        }, (Predicate)new Predicate<GetOccAvailabilityCatalogResponse>(){

            @Override
            public boolean test(GetOccAvailabilityCatalogResponse response) {
                return targetStatesSet.contains((Object)response.getOccAvailabilityCatalog().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OccAvailabilityCatalog.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOccCapacityRequestRequest, GetOccCapacityRequestResponse> forOccCapacityRequest(GetOccCapacityRequestRequest request, OccCapacityRequest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOccCapacityRequest(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOccCapacityRequestRequest, GetOccCapacityRequestResponse> forOccCapacityRequest(GetOccCapacityRequestRequest request, OccCapacityRequest.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOccCapacityRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOccCapacityRequestRequest, GetOccCapacityRequestResponse> forOccCapacityRequest(GetOccCapacityRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OccCapacityRequest.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOccCapacityRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOccCapacityRequestRequest, GetOccCapacityRequestResponse> forOccCapacityRequest(BmcGenericWaiter waiter, GetOccCapacityRequestRequest request, OccCapacityRequest.LifecycleState ... targetStates) {
        final HashSet<OccCapacityRequest.LifecycleState> targetStatesSet = new HashSet<OccCapacityRequest.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOccCapacityRequestRequest, GetOccCapacityRequestResponse>(){

            @Override
            public GetOccCapacityRequestResponse apply(GetOccCapacityRequestRequest request) {
                return CapacityManagementWaiters.this.client.getOccCapacityRequest(request);
            }
        }, (Predicate)new Predicate<GetOccCapacityRequestResponse>(){

            @Override
            public boolean test(GetOccCapacityRequestResponse response) {
                return targetStatesSet.contains((Object)response.getOccCapacityRequest().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OccCapacityRequest.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOccCustomerGroupRequest, GetOccCustomerGroupResponse> forOccCustomerGroup(GetOccCustomerGroupRequest request, OccCustomerGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOccCustomerGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOccCustomerGroupRequest, GetOccCustomerGroupResponse> forOccCustomerGroup(GetOccCustomerGroupRequest request, OccCustomerGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOccCustomerGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOccCustomerGroupRequest, GetOccCustomerGroupResponse> forOccCustomerGroup(GetOccCustomerGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OccCustomerGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOccCustomerGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOccCustomerGroupRequest, GetOccCustomerGroupResponse> forOccCustomerGroup(BmcGenericWaiter waiter, GetOccCustomerGroupRequest request, OccCustomerGroup.LifecycleState ... targetStates) {
        final HashSet<OccCustomerGroup.LifecycleState> targetStatesSet = new HashSet<OccCustomerGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOccCustomerGroupRequest, GetOccCustomerGroupResponse>(){

            @Override
            public GetOccCustomerGroupResponse apply(GetOccCustomerGroupRequest request) {
                return CapacityManagementWaiters.this.client.getOccCustomerGroup(request);
            }
        }, (Predicate)new Predicate<GetOccCustomerGroupResponse>(){

            @Override
            public boolean test(GetOccCustomerGroupResponse response) {
                return targetStatesSet.contains((Object)response.getOccCustomerGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OccCustomerGroup.LifecycleState.Deleted)), (Object)request);
    }
}

