/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.capacitymanagement.model.Namespace;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OccAvailabilitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="catalogId")
    private final String catalogId;
    @JsonProperty(value="namespace")
    private final Namespace namespace;
    @JsonProperty(value="dateFinalCustomerOrder")
    private final Date dateFinalCustomerOrder;
    @JsonProperty(value="dateExpectedCapacityHandover")
    private final Date dateExpectedCapacityHandover;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="workloadType")
    private final String workloadType;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="availableQuantity")
    private final Long availableQuantity;
    @JsonProperty(value="totalAvailableQuantity")
    private final Long totalAvailableQuantity;
    @JsonProperty(value="demandedQuantity")
    private final Long demandedQuantity;
    @JsonProperty(value="unit")
    private final String unit;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"catalogId", "namespace", "dateFinalCustomerOrder", "dateExpectedCapacityHandover", "resourceType", "workloadType", "resourceName", "availableQuantity", "totalAvailableQuantity", "demandedQuantity", "unit", "systemTags"})
    public OccAvailabilitySummary(String catalogId, Namespace namespace, Date dateFinalCustomerOrder, Date dateExpectedCapacityHandover, String resourceType, String workloadType, String resourceName, Long availableQuantity, Long totalAvailableQuantity, Long demandedQuantity, String unit, Map<String, Map<String, Object>> systemTags) {
        this.catalogId = catalogId;
        this.namespace = namespace;
        this.dateFinalCustomerOrder = dateFinalCustomerOrder;
        this.dateExpectedCapacityHandover = dateExpectedCapacityHandover;
        this.resourceType = resourceType;
        this.workloadType = workloadType;
        this.resourceName = resourceName;
        this.availableQuantity = availableQuantity;
        this.totalAvailableQuantity = totalAvailableQuantity;
        this.demandedQuantity = demandedQuantity;
        this.unit = unit;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Date getDateFinalCustomerOrder() {
        return this.dateFinalCustomerOrder;
    }

    public Date getDateExpectedCapacityHandover() {
        return this.dateExpectedCapacityHandover;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Long getAvailableQuantity() {
        return this.availableQuantity;
    }

    public Long getTotalAvailableQuantity() {
        return this.totalAvailableQuantity;
    }

    public Long getDemandedQuantity() {
        return this.demandedQuantity;
    }

    public String getUnit() {
        return this.unit;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OccAvailabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("catalogId=").append(String.valueOf(this.catalogId));
        sb.append(", namespace=").append(String.valueOf((Object)this.namespace));
        sb.append(", dateFinalCustomerOrder=").append(String.valueOf(this.dateFinalCustomerOrder));
        sb.append(", dateExpectedCapacityHandover=").append(String.valueOf(this.dateExpectedCapacityHandover));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", workloadType=").append(String.valueOf(this.workloadType));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", availableQuantity=").append(String.valueOf(this.availableQuantity));
        sb.append(", totalAvailableQuantity=").append(String.valueOf(this.totalAvailableQuantity));
        sb.append(", demandedQuantity=").append(String.valueOf(this.demandedQuantity));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OccAvailabilitySummary)) {
            return false;
        }
        OccAvailabilitySummary other = (OccAvailabilitySummary)((Object)o);
        return Objects.equals(this.catalogId, other.catalogId) && Objects.equals((Object)this.namespace, (Object)other.namespace) && Objects.equals(this.dateFinalCustomerOrder, other.dateFinalCustomerOrder) && Objects.equals(this.dateExpectedCapacityHandover, other.dateExpectedCapacityHandover) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.workloadType, other.workloadType) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.availableQuantity, other.availableQuantity) && Objects.equals(this.totalAvailableQuantity, other.totalAvailableQuantity) && Objects.equals(this.demandedQuantity, other.demandedQuantity) && Objects.equals(this.unit, other.unit) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.catalogId == null ? 43 : this.catalogId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.dateFinalCustomerOrder == null ? 43 : this.dateFinalCustomerOrder.hashCode());
        result = result * 59 + (this.dateExpectedCapacityHandover == null ? 43 : this.dateExpectedCapacityHandover.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.availableQuantity == null ? 43 : this.availableQuantity.hashCode());
        result = result * 59 + (this.totalAvailableQuantity == null ? 43 : this.totalAvailableQuantity.hashCode());
        result = result * 59 + (this.demandedQuantity == null ? 43 : this.demandedQuantity.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="catalogId")
        private String catalogId;
        @JsonProperty(value="namespace")
        private Namespace namespace;
        @JsonProperty(value="dateFinalCustomerOrder")
        private Date dateFinalCustomerOrder;
        @JsonProperty(value="dateExpectedCapacityHandover")
        private Date dateExpectedCapacityHandover;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="workloadType")
        private String workloadType;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="availableQuantity")
        private Long availableQuantity;
        @JsonProperty(value="totalAvailableQuantity")
        private Long totalAvailableQuantity;
        @JsonProperty(value="demandedQuantity")
        private Long demandedQuantity;
        @JsonProperty(value="unit")
        private String unit;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.__explicitlySet__.add("catalogId");
            return this;
        }

        public Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder dateFinalCustomerOrder(Date dateFinalCustomerOrder) {
            this.dateFinalCustomerOrder = dateFinalCustomerOrder;
            this.__explicitlySet__.add("dateFinalCustomerOrder");
            return this;
        }

        public Builder dateExpectedCapacityHandover(Date dateExpectedCapacityHandover) {
            this.dateExpectedCapacityHandover = dateExpectedCapacityHandover;
            this.__explicitlySet__.add("dateExpectedCapacityHandover");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder availableQuantity(Long availableQuantity) {
            this.availableQuantity = availableQuantity;
            this.__explicitlySet__.add("availableQuantity");
            return this;
        }

        public Builder totalAvailableQuantity(Long totalAvailableQuantity) {
            this.totalAvailableQuantity = totalAvailableQuantity;
            this.__explicitlySet__.add("totalAvailableQuantity");
            return this;
        }

        public Builder demandedQuantity(Long demandedQuantity) {
            this.demandedQuantity = demandedQuantity;
            this.__explicitlySet__.add("demandedQuantity");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public OccAvailabilitySummary build() {
            OccAvailabilitySummary model = new OccAvailabilitySummary(this.catalogId, this.namespace, this.dateFinalCustomerOrder, this.dateExpectedCapacityHandover, this.resourceType, this.workloadType, this.resourceName, this.availableQuantity, this.totalAvailableQuantity, this.demandedQuantity, this.unit, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OccAvailabilitySummary model) {
            if (model.wasPropertyExplicitlySet("catalogId")) {
                this.catalogId(model.getCatalogId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("dateFinalCustomerOrder")) {
                this.dateFinalCustomerOrder(model.getDateFinalCustomerOrder());
            }
            if (model.wasPropertyExplicitlySet("dateExpectedCapacityHandover")) {
                this.dateExpectedCapacityHandover(model.getDateExpectedCapacityHandover());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("availableQuantity")) {
                this.availableQuantity(model.getAvailableQuantity());
            }
            if (model.wasPropertyExplicitlySet("totalAvailableQuantity")) {
                this.totalAvailableQuantity(model.getTotalAvailableQuantity());
            }
            if (model.wasPropertyExplicitlySet("demandedQuantity")) {
                this.demandedQuantity(model.getDemandedQuantity());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

