/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.capacitymanagement.model.AssociatedOccHandoverResourceBlock;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OccCapacityRequestBaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="workloadType")
    private final String workloadType;
    @JsonProperty(value="sourceWorkloadType")
    private final String sourceWorkloadType;
    @JsonProperty(value="expectedHandoverQuantity")
    private final Long expectedHandoverQuantity;
    @JsonProperty(value="dateExpectedHandover")
    private final Date dateExpectedHandover;
    @JsonProperty(value="actualHandoverQuantity")
    private final Long actualHandoverQuantity;
    @JsonProperty(value="dateActualHandover")
    private final Date dateActualHandover;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="associatedOccHandoverResourceBlockList")
    private final List<AssociatedOccHandoverResourceBlock> associatedOccHandoverResourceBlockList;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="demandQuantity")
    private final Long demandQuantity;

    @Deprecated
    @ConstructorProperties(value={"resourceType", "workloadType", "sourceWorkloadType", "expectedHandoverQuantity", "dateExpectedHandover", "actualHandoverQuantity", "dateActualHandover", "availabilityDomain", "associatedOccHandoverResourceBlockList", "resourceName", "demandQuantity"})
    public OccCapacityRequestBaseDetails(String resourceType, String workloadType, String sourceWorkloadType, Long expectedHandoverQuantity, Date dateExpectedHandover, Long actualHandoverQuantity, Date dateActualHandover, String availabilityDomain, List<AssociatedOccHandoverResourceBlock> associatedOccHandoverResourceBlockList, String resourceName, Long demandQuantity) {
        this.resourceType = resourceType;
        this.workloadType = workloadType;
        this.sourceWorkloadType = sourceWorkloadType;
        this.expectedHandoverQuantity = expectedHandoverQuantity;
        this.dateExpectedHandover = dateExpectedHandover;
        this.actualHandoverQuantity = actualHandoverQuantity;
        this.dateActualHandover = dateActualHandover;
        this.availabilityDomain = availabilityDomain;
        this.associatedOccHandoverResourceBlockList = associatedOccHandoverResourceBlockList;
        this.resourceName = resourceName;
        this.demandQuantity = demandQuantity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public String getSourceWorkloadType() {
        return this.sourceWorkloadType;
    }

    public Long getExpectedHandoverQuantity() {
        return this.expectedHandoverQuantity;
    }

    public Date getDateExpectedHandover() {
        return this.dateExpectedHandover;
    }

    public Long getActualHandoverQuantity() {
        return this.actualHandoverQuantity;
    }

    public Date getDateActualHandover() {
        return this.dateActualHandover;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public List<AssociatedOccHandoverResourceBlock> getAssociatedOccHandoverResourceBlockList() {
        return this.associatedOccHandoverResourceBlockList;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Long getDemandQuantity() {
        return this.demandQuantity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OccCapacityRequestBaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", workloadType=").append(String.valueOf(this.workloadType));
        sb.append(", sourceWorkloadType=").append(String.valueOf(this.sourceWorkloadType));
        sb.append(", expectedHandoverQuantity=").append(String.valueOf(this.expectedHandoverQuantity));
        sb.append(", dateExpectedHandover=").append(String.valueOf(this.dateExpectedHandover));
        sb.append(", actualHandoverQuantity=").append(String.valueOf(this.actualHandoverQuantity));
        sb.append(", dateActualHandover=").append(String.valueOf(this.dateActualHandover));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", associatedOccHandoverResourceBlockList=").append(String.valueOf(this.associatedOccHandoverResourceBlockList));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", demandQuantity=").append(String.valueOf(this.demandQuantity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OccCapacityRequestBaseDetails)) {
            return false;
        }
        OccCapacityRequestBaseDetails other = (OccCapacityRequestBaseDetails)((Object)o);
        return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.workloadType, other.workloadType) && Objects.equals(this.sourceWorkloadType, other.sourceWorkloadType) && Objects.equals(this.expectedHandoverQuantity, other.expectedHandoverQuantity) && Objects.equals(this.dateExpectedHandover, other.dateExpectedHandover) && Objects.equals(this.actualHandoverQuantity, other.actualHandoverQuantity) && Objects.equals(this.dateActualHandover, other.dateActualHandover) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.associatedOccHandoverResourceBlockList, other.associatedOccHandoverResourceBlockList) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.demandQuantity, other.demandQuantity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.sourceWorkloadType == null ? 43 : this.sourceWorkloadType.hashCode());
        result = result * 59 + (this.expectedHandoverQuantity == null ? 43 : this.expectedHandoverQuantity.hashCode());
        result = result * 59 + (this.dateExpectedHandover == null ? 43 : this.dateExpectedHandover.hashCode());
        result = result * 59 + (this.actualHandoverQuantity == null ? 43 : this.actualHandoverQuantity.hashCode());
        result = result * 59 + (this.dateActualHandover == null ? 43 : this.dateActualHandover.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.associatedOccHandoverResourceBlockList == null ? 43 : this.associatedOccHandoverResourceBlockList.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.demandQuantity == null ? 43 : this.demandQuantity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="workloadType")
        private String workloadType;
        @JsonProperty(value="sourceWorkloadType")
        private String sourceWorkloadType;
        @JsonProperty(value="expectedHandoverQuantity")
        private Long expectedHandoverQuantity;
        @JsonProperty(value="dateExpectedHandover")
        private Date dateExpectedHandover;
        @JsonProperty(value="actualHandoverQuantity")
        private Long actualHandoverQuantity;
        @JsonProperty(value="dateActualHandover")
        private Date dateActualHandover;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="associatedOccHandoverResourceBlockList")
        private List<AssociatedOccHandoverResourceBlock> associatedOccHandoverResourceBlockList;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="demandQuantity")
        private Long demandQuantity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            this.__explicitlySet__.add("workloadType");
            return this;
        }

        public Builder sourceWorkloadType(String sourceWorkloadType) {
            this.sourceWorkloadType = sourceWorkloadType;
            this.__explicitlySet__.add("sourceWorkloadType");
            return this;
        }

        public Builder expectedHandoverQuantity(Long expectedHandoverQuantity) {
            this.expectedHandoverQuantity = expectedHandoverQuantity;
            this.__explicitlySet__.add("expectedHandoverQuantity");
            return this;
        }

        public Builder dateExpectedHandover(Date dateExpectedHandover) {
            this.dateExpectedHandover = dateExpectedHandover;
            this.__explicitlySet__.add("dateExpectedHandover");
            return this;
        }

        public Builder actualHandoverQuantity(Long actualHandoverQuantity) {
            this.actualHandoverQuantity = actualHandoverQuantity;
            this.__explicitlySet__.add("actualHandoverQuantity");
            return this;
        }

        public Builder dateActualHandover(Date dateActualHandover) {
            this.dateActualHandover = dateActualHandover;
            this.__explicitlySet__.add("dateActualHandover");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder associatedOccHandoverResourceBlockList(List<AssociatedOccHandoverResourceBlock> associatedOccHandoverResourceBlockList) {
            this.associatedOccHandoverResourceBlockList = associatedOccHandoverResourceBlockList;
            this.__explicitlySet__.add("associatedOccHandoverResourceBlockList");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder demandQuantity(Long demandQuantity) {
            this.demandQuantity = demandQuantity;
            this.__explicitlySet__.add("demandQuantity");
            return this;
        }

        public OccCapacityRequestBaseDetails build() {
            OccCapacityRequestBaseDetails model = new OccCapacityRequestBaseDetails(this.resourceType, this.workloadType, this.sourceWorkloadType, this.expectedHandoverQuantity, this.dateExpectedHandover, this.actualHandoverQuantity, this.dateActualHandover, this.availabilityDomain, this.associatedOccHandoverResourceBlockList, this.resourceName, this.demandQuantity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OccCapacityRequestBaseDetails model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("workloadType")) {
                this.workloadType(model.getWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("sourceWorkloadType")) {
                this.sourceWorkloadType(model.getSourceWorkloadType());
            }
            if (model.wasPropertyExplicitlySet("expectedHandoverQuantity")) {
                this.expectedHandoverQuantity(model.getExpectedHandoverQuantity());
            }
            if (model.wasPropertyExplicitlySet("dateExpectedHandover")) {
                this.dateExpectedHandover(model.getDateExpectedHandover());
            }
            if (model.wasPropertyExplicitlySet("actualHandoverQuantity")) {
                this.actualHandoverQuantity(model.getActualHandoverQuantity());
            }
            if (model.wasPropertyExplicitlySet("dateActualHandover")) {
                this.dateActualHandover(model.getDateActualHandover());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("associatedOccHandoverResourceBlockList")) {
                this.associatedOccHandoverResourceBlockList(model.getAssociatedOccHandoverResourceBlockList());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("demandQuantity")) {
                this.demandQuantity(model.getDemandQuantity());
            }
            return this;
        }
    }
}

