/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.capacitymanagement.model.AssociatedCapacityRequestDetails;
import com.oracle.bmc.capacitymanagement.model.Namespace;
import com.oracle.bmc.capacitymanagement.model.PlacementDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OccHandoverResourceBlockSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="namespace")
    private final Namespace namespace;
    @JsonProperty(value="occCustomerGroupId")
    private final String occCustomerGroupId;
    @JsonProperty(value="handoverDate")
    private final Date handoverDate;
    @JsonProperty(value="handoverResourceName")
    private final String handoverResourceName;
    @JsonProperty(value="totalHandoverQuantity")
    private final Long totalHandoverQuantity;
    @JsonProperty(value="associatedCapacityRequests")
    private final List<AssociatedCapacityRequestDetails> associatedCapacityRequests;
    @JsonProperty(value="placementDetails")
    private final PlacementDetails placementDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "namespace", "occCustomerGroupId", "handoverDate", "handoverResourceName", "totalHandoverQuantity", "associatedCapacityRequests", "placementDetails"})
    public OccHandoverResourceBlockSummary(String id, String compartmentId, Namespace namespace, String occCustomerGroupId, Date handoverDate, String handoverResourceName, Long totalHandoverQuantity, List<AssociatedCapacityRequestDetails> associatedCapacityRequests, PlacementDetails placementDetails) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.namespace = namespace;
        this.occCustomerGroupId = occCustomerGroupId;
        this.handoverDate = handoverDate;
        this.handoverResourceName = handoverResourceName;
        this.totalHandoverQuantity = totalHandoverQuantity;
        this.associatedCapacityRequests = associatedCapacityRequests;
        this.placementDetails = placementDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getOccCustomerGroupId() {
        return this.occCustomerGroupId;
    }

    public Date getHandoverDate() {
        return this.handoverDate;
    }

    public String getHandoverResourceName() {
        return this.handoverResourceName;
    }

    public Long getTotalHandoverQuantity() {
        return this.totalHandoverQuantity;
    }

    public List<AssociatedCapacityRequestDetails> getAssociatedCapacityRequests() {
        return this.associatedCapacityRequests;
    }

    public PlacementDetails getPlacementDetails() {
        return this.placementDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OccHandoverResourceBlockSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", namespace=").append(String.valueOf((Object)this.namespace));
        sb.append(", occCustomerGroupId=").append(String.valueOf(this.occCustomerGroupId));
        sb.append(", handoverDate=").append(String.valueOf(this.handoverDate));
        sb.append(", handoverResourceName=").append(String.valueOf(this.handoverResourceName));
        sb.append(", totalHandoverQuantity=").append(String.valueOf(this.totalHandoverQuantity));
        sb.append(", associatedCapacityRequests=").append(String.valueOf(this.associatedCapacityRequests));
        sb.append(", placementDetails=").append(String.valueOf((Object)this.placementDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OccHandoverResourceBlockSummary)) {
            return false;
        }
        OccHandoverResourceBlockSummary other = (OccHandoverResourceBlockSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.namespace, (Object)other.namespace) && Objects.equals(this.occCustomerGroupId, other.occCustomerGroupId) && Objects.equals(this.handoverDate, other.handoverDate) && Objects.equals(this.handoverResourceName, other.handoverResourceName) && Objects.equals(this.totalHandoverQuantity, other.totalHandoverQuantity) && Objects.equals(this.associatedCapacityRequests, other.associatedCapacityRequests) && Objects.equals((Object)this.placementDetails, (Object)other.placementDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.occCustomerGroupId == null ? 43 : this.occCustomerGroupId.hashCode());
        result = result * 59 + (this.handoverDate == null ? 43 : this.handoverDate.hashCode());
        result = result * 59 + (this.handoverResourceName == null ? 43 : this.handoverResourceName.hashCode());
        result = result * 59 + (this.totalHandoverQuantity == null ? 43 : this.totalHandoverQuantity.hashCode());
        result = result * 59 + (this.associatedCapacityRequests == null ? 43 : this.associatedCapacityRequests.hashCode());
        result = result * 59 + (this.placementDetails == null ? 43 : this.placementDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="namespace")
        private Namespace namespace;
        @JsonProperty(value="occCustomerGroupId")
        private String occCustomerGroupId;
        @JsonProperty(value="handoverDate")
        private Date handoverDate;
        @JsonProperty(value="handoverResourceName")
        private String handoverResourceName;
        @JsonProperty(value="totalHandoverQuantity")
        private Long totalHandoverQuantity;
        @JsonProperty(value="associatedCapacityRequests")
        private List<AssociatedCapacityRequestDetails> associatedCapacityRequests;
        @JsonProperty(value="placementDetails")
        private PlacementDetails placementDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder occCustomerGroupId(String occCustomerGroupId) {
            this.occCustomerGroupId = occCustomerGroupId;
            this.__explicitlySet__.add("occCustomerGroupId");
            return this;
        }

        public Builder handoverDate(Date handoverDate) {
            this.handoverDate = handoverDate;
            this.__explicitlySet__.add("handoverDate");
            return this;
        }

        public Builder handoverResourceName(String handoverResourceName) {
            this.handoverResourceName = handoverResourceName;
            this.__explicitlySet__.add("handoverResourceName");
            return this;
        }

        public Builder totalHandoverQuantity(Long totalHandoverQuantity) {
            this.totalHandoverQuantity = totalHandoverQuantity;
            this.__explicitlySet__.add("totalHandoverQuantity");
            return this;
        }

        public Builder associatedCapacityRequests(List<AssociatedCapacityRequestDetails> associatedCapacityRequests) {
            this.associatedCapacityRequests = associatedCapacityRequests;
            this.__explicitlySet__.add("associatedCapacityRequests");
            return this;
        }

        public Builder placementDetails(PlacementDetails placementDetails) {
            this.placementDetails = placementDetails;
            this.__explicitlySet__.add("placementDetails");
            return this;
        }

        public OccHandoverResourceBlockSummary build() {
            OccHandoverResourceBlockSummary model = new OccHandoverResourceBlockSummary(this.id, this.compartmentId, this.namespace, this.occCustomerGroupId, this.handoverDate, this.handoverResourceName, this.totalHandoverQuantity, this.associatedCapacityRequests, this.placementDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OccHandoverResourceBlockSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("occCustomerGroupId")) {
                this.occCustomerGroupId(model.getOccCustomerGroupId());
            }
            if (model.wasPropertyExplicitlySet("handoverDate")) {
                this.handoverDate(model.getHandoverDate());
            }
            if (model.wasPropertyExplicitlySet("handoverResourceName")) {
                this.handoverResourceName(model.getHandoverResourceName());
            }
            if (model.wasPropertyExplicitlySet("totalHandoverQuantity")) {
                this.totalHandoverQuantity(model.getTotalHandoverQuantity());
            }
            if (model.wasPropertyExplicitlySet("associatedCapacityRequests")) {
                this.associatedCapacityRequests(model.getAssociatedCapacityRequests());
            }
            if (model.wasPropertyExplicitlySet("placementDetails")) {
                this.placementDetails(model.getPlacementDetails());
            }
            return this;
        }
    }
}

