/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OccOverviewSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="periodValue")
    private final String periodValue;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="totalAvailable")
    private final Long totalAvailable;
    @JsonProperty(value="totalDemanded")
    private final Long totalDemanded;
    @JsonProperty(value="totalSupplied")
    private final Long totalSupplied;
    @JsonProperty(value="totalRejected")
    private final Long totalRejected;
    @JsonProperty(value="totalCancelled")
    private final Long totalCancelled;
    @JsonProperty(value="totalUnfulfilled")
    private final Long totalUnfulfilled;
    @JsonProperty(value="workloadTypeBreakdownBlob")
    private final String workloadTypeBreakdownBlob;
    @JsonProperty(value="capacityRequestsBlob")
    private final String capacityRequestsBlob;
    @JsonProperty(value="unit")
    private final String unit;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "periodValue", "resourceName", "totalAvailable", "totalDemanded", "totalSupplied", "totalRejected", "totalCancelled", "totalUnfulfilled", "workloadTypeBreakdownBlob", "capacityRequestsBlob", "unit"})
    public OccOverviewSummary(String compartmentId, String periodValue, String resourceName, Long totalAvailable, Long totalDemanded, Long totalSupplied, Long totalRejected, Long totalCancelled, Long totalUnfulfilled, String workloadTypeBreakdownBlob, String capacityRequestsBlob, String unit) {
        this.compartmentId = compartmentId;
        this.periodValue = periodValue;
        this.resourceName = resourceName;
        this.totalAvailable = totalAvailable;
        this.totalDemanded = totalDemanded;
        this.totalSupplied = totalSupplied;
        this.totalRejected = totalRejected;
        this.totalCancelled = totalCancelled;
        this.totalUnfulfilled = totalUnfulfilled;
        this.workloadTypeBreakdownBlob = workloadTypeBreakdownBlob;
        this.capacityRequestsBlob = capacityRequestsBlob;
        this.unit = unit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPeriodValue() {
        return this.periodValue;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Long getTotalAvailable() {
        return this.totalAvailable;
    }

    public Long getTotalDemanded() {
        return this.totalDemanded;
    }

    public Long getTotalSupplied() {
        return this.totalSupplied;
    }

    public Long getTotalRejected() {
        return this.totalRejected;
    }

    public Long getTotalCancelled() {
        return this.totalCancelled;
    }

    public Long getTotalUnfulfilled() {
        return this.totalUnfulfilled;
    }

    public String getWorkloadTypeBreakdownBlob() {
        return this.workloadTypeBreakdownBlob;
    }

    public String getCapacityRequestsBlob() {
        return this.capacityRequestsBlob;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OccOverviewSummary(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", periodValue=").append(String.valueOf(this.periodValue));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", totalAvailable=").append(String.valueOf(this.totalAvailable));
        sb.append(", totalDemanded=").append(String.valueOf(this.totalDemanded));
        sb.append(", totalSupplied=").append(String.valueOf(this.totalSupplied));
        sb.append(", totalRejected=").append(String.valueOf(this.totalRejected));
        sb.append(", totalCancelled=").append(String.valueOf(this.totalCancelled));
        sb.append(", totalUnfulfilled=").append(String.valueOf(this.totalUnfulfilled));
        sb.append(", workloadTypeBreakdownBlob=").append(String.valueOf(this.workloadTypeBreakdownBlob));
        sb.append(", capacityRequestsBlob=").append(String.valueOf(this.capacityRequestsBlob));
        sb.append(", unit=").append(String.valueOf(this.unit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OccOverviewSummary)) {
            return false;
        }
        OccOverviewSummary other = (OccOverviewSummary)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.periodValue, other.periodValue) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.totalAvailable, other.totalAvailable) && Objects.equals(this.totalDemanded, other.totalDemanded) && Objects.equals(this.totalSupplied, other.totalSupplied) && Objects.equals(this.totalRejected, other.totalRejected) && Objects.equals(this.totalCancelled, other.totalCancelled) && Objects.equals(this.totalUnfulfilled, other.totalUnfulfilled) && Objects.equals(this.workloadTypeBreakdownBlob, other.workloadTypeBreakdownBlob) && Objects.equals(this.capacityRequestsBlob, other.capacityRequestsBlob) && Objects.equals(this.unit, other.unit) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.periodValue == null ? 43 : this.periodValue.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.totalAvailable == null ? 43 : this.totalAvailable.hashCode());
        result = result * 59 + (this.totalDemanded == null ? 43 : this.totalDemanded.hashCode());
        result = result * 59 + (this.totalSupplied == null ? 43 : this.totalSupplied.hashCode());
        result = result * 59 + (this.totalRejected == null ? 43 : this.totalRejected.hashCode());
        result = result * 59 + (this.totalCancelled == null ? 43 : this.totalCancelled.hashCode());
        result = result * 59 + (this.totalUnfulfilled == null ? 43 : this.totalUnfulfilled.hashCode());
        result = result * 59 + (this.workloadTypeBreakdownBlob == null ? 43 : this.workloadTypeBreakdownBlob.hashCode());
        result = result * 59 + (this.capacityRequestsBlob == null ? 43 : this.capacityRequestsBlob.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="periodValue")
        private String periodValue;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="totalAvailable")
        private Long totalAvailable;
        @JsonProperty(value="totalDemanded")
        private Long totalDemanded;
        @JsonProperty(value="totalSupplied")
        private Long totalSupplied;
        @JsonProperty(value="totalRejected")
        private Long totalRejected;
        @JsonProperty(value="totalCancelled")
        private Long totalCancelled;
        @JsonProperty(value="totalUnfulfilled")
        private Long totalUnfulfilled;
        @JsonProperty(value="workloadTypeBreakdownBlob")
        private String workloadTypeBreakdownBlob;
        @JsonProperty(value="capacityRequestsBlob")
        private String capacityRequestsBlob;
        @JsonProperty(value="unit")
        private String unit;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder periodValue(String periodValue) {
            this.periodValue = periodValue;
            this.__explicitlySet__.add("periodValue");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder totalAvailable(Long totalAvailable) {
            this.totalAvailable = totalAvailable;
            this.__explicitlySet__.add("totalAvailable");
            return this;
        }

        public Builder totalDemanded(Long totalDemanded) {
            this.totalDemanded = totalDemanded;
            this.__explicitlySet__.add("totalDemanded");
            return this;
        }

        public Builder totalSupplied(Long totalSupplied) {
            this.totalSupplied = totalSupplied;
            this.__explicitlySet__.add("totalSupplied");
            return this;
        }

        public Builder totalRejected(Long totalRejected) {
            this.totalRejected = totalRejected;
            this.__explicitlySet__.add("totalRejected");
            return this;
        }

        public Builder totalCancelled(Long totalCancelled) {
            this.totalCancelled = totalCancelled;
            this.__explicitlySet__.add("totalCancelled");
            return this;
        }

        public Builder totalUnfulfilled(Long totalUnfulfilled) {
            this.totalUnfulfilled = totalUnfulfilled;
            this.__explicitlySet__.add("totalUnfulfilled");
            return this;
        }

        public Builder workloadTypeBreakdownBlob(String workloadTypeBreakdownBlob) {
            this.workloadTypeBreakdownBlob = workloadTypeBreakdownBlob;
            this.__explicitlySet__.add("workloadTypeBreakdownBlob");
            return this;
        }

        public Builder capacityRequestsBlob(String capacityRequestsBlob) {
            this.capacityRequestsBlob = capacityRequestsBlob;
            this.__explicitlySet__.add("capacityRequestsBlob");
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public OccOverviewSummary build() {
            OccOverviewSummary model = new OccOverviewSummary(this.compartmentId, this.periodValue, this.resourceName, this.totalAvailable, this.totalDemanded, this.totalSupplied, this.totalRejected, this.totalCancelled, this.totalUnfulfilled, this.workloadTypeBreakdownBlob, this.capacityRequestsBlob, this.unit);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OccOverviewSummary model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("periodValue")) {
                this.periodValue(model.getPeriodValue());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("totalAvailable")) {
                this.totalAvailable(model.getTotalAvailable());
            }
            if (model.wasPropertyExplicitlySet("totalDemanded")) {
                this.totalDemanded(model.getTotalDemanded());
            }
            if (model.wasPropertyExplicitlySet("totalSupplied")) {
                this.totalSupplied(model.getTotalSupplied());
            }
            if (model.wasPropertyExplicitlySet("totalRejected")) {
                this.totalRejected(model.getTotalRejected());
            }
            if (model.wasPropertyExplicitlySet("totalCancelled")) {
                this.totalCancelled(model.getTotalCancelled());
            }
            if (model.wasPropertyExplicitlySet("totalUnfulfilled")) {
                this.totalUnfulfilled(model.getTotalUnfulfilled());
            }
            if (model.wasPropertyExplicitlySet("workloadTypeBreakdownBlob")) {
                this.workloadTypeBreakdownBlob(model.getWorkloadTypeBreakdownBlob());
            }
            if (model.wasPropertyExplicitlySet("capacityRequestsBlob")) {
                this.capacityRequestsBlob(model.getCapacityRequestsBlob());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            return this;
        }
    }
}

