/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOccCustomerGroupRequest
extends BmcRequest<Void> {
    private String occCustomerGroupId;
    private String opcRequestId;

    public String getOccCustomerGroupId() {
        return this.occCustomerGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().occCustomerGroupId(this.occCustomerGroupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",occCustomerGroupId=").append(String.valueOf(this.occCustomerGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOccCustomerGroupRequest)) {
            return false;
        }
        GetOccCustomerGroupRequest other = (GetOccCustomerGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.occCustomerGroupId, other.occCustomerGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.occCustomerGroupId == null ? 43 : this.occCustomerGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOccCustomerGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String occCustomerGroupId = null;
        private String opcRequestId = null;

        public Builder occCustomerGroupId(String occCustomerGroupId) {
            this.occCustomerGroupId = occCustomerGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOccCustomerGroupRequest o) {
            this.occCustomerGroupId(o.getOccCustomerGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOccCustomerGroupRequest build() {
            GetOccCustomerGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOccCustomerGroupRequest buildWithoutInvocationCallback() {
            GetOccCustomerGroupRequest request = new GetOccCustomerGroupRequest();
            request.occCustomerGroupId = this.occCustomerGroupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

