/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.capacitymanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOccAvailabilitiesRequest
extends BmcRequest<Void> {
    private String occAvailabilityCatalogId;
    private String dateExpectedCapacityHandover;
    private String resourceName;
    private String resourceType;
    private String workloadType;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public String getOccAvailabilityCatalogId() {
        return this.occAvailabilityCatalogId;
    }

    public String getDateExpectedCapacityHandover() {
        return this.dateExpectedCapacityHandover;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().occAvailabilityCatalogId(this.occAvailabilityCatalogId).dateExpectedCapacityHandover(this.dateExpectedCapacityHandover).resourceName(this.resourceName).resourceType(this.resourceType).workloadType(this.workloadType).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",occAvailabilityCatalogId=").append(String.valueOf(this.occAvailabilityCatalogId));
        sb.append(",dateExpectedCapacityHandover=").append(String.valueOf(this.dateExpectedCapacityHandover));
        sb.append(",resourceName=").append(String.valueOf(this.resourceName));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(",workloadType=").append(String.valueOf(this.workloadType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOccAvailabilitiesRequest)) {
            return false;
        }
        ListOccAvailabilitiesRequest other = (ListOccAvailabilitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.occAvailabilityCatalogId, other.occAvailabilityCatalogId) && Objects.equals(this.dateExpectedCapacityHandover, other.dateExpectedCapacityHandover) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.workloadType, other.workloadType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.occAvailabilityCatalogId == null ? 43 : this.occAvailabilityCatalogId.hashCode());
        result = result * 59 + (this.dateExpectedCapacityHandover == null ? 43 : this.dateExpectedCapacityHandover.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOccAvailabilitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String occAvailabilityCatalogId = null;
        private String dateExpectedCapacityHandover = null;
        private String resourceName = null;
        private String resourceType = null;
        private String workloadType = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder occAvailabilityCatalogId(String occAvailabilityCatalogId) {
            this.occAvailabilityCatalogId = occAvailabilityCatalogId;
            return this;
        }

        public Builder dateExpectedCapacityHandover(String dateExpectedCapacityHandover) {
            this.dateExpectedCapacityHandover = dateExpectedCapacityHandover;
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOccAvailabilitiesRequest o) {
            this.occAvailabilityCatalogId(o.getOccAvailabilityCatalogId());
            this.dateExpectedCapacityHandover(o.getDateExpectedCapacityHandover());
            this.resourceName(o.getResourceName());
            this.resourceType(o.getResourceType());
            this.workloadType(o.getWorkloadType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOccAvailabilitiesRequest build() {
            ListOccAvailabilitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOccAvailabilitiesRequest buildWithoutInvocationCallback() {
            ListOccAvailabilitiesRequest request = new ListOccAvailabilitiesRequest();
            request.occAvailabilityCatalogId = this.occAvailabilityCatalogId;
            request.dateExpectedCapacityHandover = this.dateExpectedCapacityHandover;
            request.resourceName = this.resourceName;
            request.resourceType = this.resourceType;
            request.workloadType = this.workloadType;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DateExpectedCapacityHandover("dateExpectedCapacityHandover"),
        ResourceName("resourceName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

