/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.capacitymanagement.model.Namespace;
import com.oracle.bmc.capacitymanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOccHandoverResourceBlocksRequest
extends BmcRequest<Void> {
    private Namespace namespace;
    private String compartmentId;
    private String handoverResourceName;
    private Date handoverDateGreaterThanOrEqualTo;
    private Date handoverDateLessThanOrEqualTo;
    private String occHandoverResourceBlockId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getHandoverResourceName() {
        return this.handoverResourceName;
    }

    public Date getHandoverDateGreaterThanOrEqualTo() {
        return this.handoverDateGreaterThanOrEqualTo;
    }

    public Date getHandoverDateLessThanOrEqualTo() {
        return this.handoverDateLessThanOrEqualTo;
    }

    public String getOccHandoverResourceBlockId() {
        return this.occHandoverResourceBlockId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().namespace(this.namespace).compartmentId(this.compartmentId).handoverResourceName(this.handoverResourceName).handoverDateGreaterThanOrEqualTo(this.handoverDateGreaterThanOrEqualTo).handoverDateLessThanOrEqualTo(this.handoverDateLessThanOrEqualTo).occHandoverResourceBlockId(this.occHandoverResourceBlockId).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespace=").append(String.valueOf((Object)this.namespace));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",handoverResourceName=").append(String.valueOf(this.handoverResourceName));
        sb.append(",handoverDateGreaterThanOrEqualTo=").append(String.valueOf(this.handoverDateGreaterThanOrEqualTo));
        sb.append(",handoverDateLessThanOrEqualTo=").append(String.valueOf(this.handoverDateLessThanOrEqualTo));
        sb.append(",occHandoverResourceBlockId=").append(String.valueOf(this.occHandoverResourceBlockId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOccHandoverResourceBlocksRequest)) {
            return false;
        }
        ListOccHandoverResourceBlocksRequest other = (ListOccHandoverResourceBlocksRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.namespace, (Object)other.namespace) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.handoverResourceName, other.handoverResourceName) && Objects.equals(this.handoverDateGreaterThanOrEqualTo, other.handoverDateGreaterThanOrEqualTo) && Objects.equals(this.handoverDateLessThanOrEqualTo, other.handoverDateLessThanOrEqualTo) && Objects.equals(this.occHandoverResourceBlockId, other.occHandoverResourceBlockId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.handoverResourceName == null ? 43 : this.handoverResourceName.hashCode());
        result = result * 59 + (this.handoverDateGreaterThanOrEqualTo == null ? 43 : this.handoverDateGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.handoverDateLessThanOrEqualTo == null ? 43 : this.handoverDateLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.occHandoverResourceBlockId == null ? 43 : this.occHandoverResourceBlockId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOccHandoverResourceBlocksRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Namespace namespace = null;
        private String compartmentId = null;
        private String handoverResourceName = null;
        private Date handoverDateGreaterThanOrEqualTo = null;
        private Date handoverDateLessThanOrEqualTo = null;
        private String occHandoverResourceBlockId = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder handoverResourceName(String handoverResourceName) {
            this.handoverResourceName = handoverResourceName;
            return this;
        }

        public Builder handoverDateGreaterThanOrEqualTo(Date handoverDateGreaterThanOrEqualTo) {
            this.handoverDateGreaterThanOrEqualTo = handoverDateGreaterThanOrEqualTo;
            return this;
        }

        public Builder handoverDateLessThanOrEqualTo(Date handoverDateLessThanOrEqualTo) {
            this.handoverDateLessThanOrEqualTo = handoverDateLessThanOrEqualTo;
            return this;
        }

        public Builder occHandoverResourceBlockId(String occHandoverResourceBlockId) {
            this.occHandoverResourceBlockId = occHandoverResourceBlockId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOccHandoverResourceBlocksRequest o) {
            this.namespace(o.getNamespace());
            this.compartmentId(o.getCompartmentId());
            this.handoverResourceName(o.getHandoverResourceName());
            this.handoverDateGreaterThanOrEqualTo(o.getHandoverDateGreaterThanOrEqualTo());
            this.handoverDateLessThanOrEqualTo(o.getHandoverDateLessThanOrEqualTo());
            this.occHandoverResourceBlockId(o.getOccHandoverResourceBlockId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOccHandoverResourceBlocksRequest build() {
            ListOccHandoverResourceBlocksRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOccHandoverResourceBlocksRequest buildWithoutInvocationCallback() {
            ListOccHandoverResourceBlocksRequest request = new ListOccHandoverResourceBlocksRequest();
            request.namespace = this.namespace;
            request.compartmentId = this.compartmentId;
            request.handoverResourceName = this.handoverResourceName;
            request.handoverDateGreaterThanOrEqualTo = this.handoverDateGreaterThanOrEqualTo;
            request.handoverDateLessThanOrEqualTo = this.handoverDateLessThanOrEqualTo;
            request.occHandoverResourceBlockId = this.occHandoverResourceBlockId;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        HandoverDate("handoverDate");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

