/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.capacitymanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.capacitymanagement.model.Namespace;
import com.oracle.bmc.capacitymanagement.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOccOverviewsRequest
extends BmcRequest<Void> {
    private Namespace namespace;
    private String compartmentId;
    private Date from;
    private Date to;
    private String workloadType;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().namespace(this.namespace).compartmentId(this.compartmentId).from(this.from).to(this.to).workloadType(this.workloadType).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespace=").append(String.valueOf((Object)this.namespace));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",from=").append(String.valueOf(this.from));
        sb.append(",to=").append(String.valueOf(this.to));
        sb.append(",workloadType=").append(String.valueOf(this.workloadType));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOccOverviewsRequest)) {
            return false;
        }
        ListOccOverviewsRequest other = (ListOccOverviewsRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.namespace, (Object)other.namespace) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.workloadType, other.workloadType) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.from == null ? 43 : this.from.hashCode());
        result = result * 59 + (this.to == null ? 43 : this.to.hashCode());
        result = result * 59 + (this.workloadType == null ? 43 : this.workloadType.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOccOverviewsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private Namespace namespace = null;
        private String compartmentId = null;
        private Date from = null;
        private Date to = null;
        private String workloadType = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOccOverviewsRequest o) {
            this.namespace(o.getNamespace());
            this.compartmentId(o.getCompartmentId());
            this.from(o.getFrom());
            this.to(o.getTo());
            this.workloadType(o.getWorkloadType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOccOverviewsRequest build() {
            ListOccOverviewsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOccOverviewsRequest buildWithoutInvocationCallback() {
            ListOccOverviewsRequest request = new ListOccOverviewsRequest();
            request.namespace = this.namespace;
            request.compartmentId = this.compartmentId;
            request.from = this.from;
            request.to = this.to;
            request.workloadType = this.workloadType;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        PeriodValue("periodValue");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

