/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetCertificateBundleRequest
extends BmcRequest<Void> {
    private String certificateId;
    private String opcRequestId;
    private Long versionNumber;
    private String certificateVersionName;
    private Stage stage;
    private CertificateBundleType certificateBundleType;

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getCertificateVersionName() {
        return this.certificateVersionName;
    }

    public Stage getStage() {
        return this.stage;
    }

    public CertificateBundleType getCertificateBundleType() {
        return this.certificateBundleType;
    }

    public Builder toBuilder() {
        return new Builder().certificateId(this.certificateId).opcRequestId(this.opcRequestId).versionNumber(this.versionNumber).certificateVersionName(this.certificateVersionName).stage(this.stage).certificateBundleType(this.certificateBundleType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateId=").append(String.valueOf(this.certificateId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(",certificateVersionName=").append(String.valueOf(this.certificateVersionName));
        sb.append(",stage=").append(String.valueOf((Object)this.stage));
        sb.append(",certificateBundleType=").append(String.valueOf((Object)this.certificateBundleType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCertificateBundleRequest)) {
            return false;
        }
        GetCertificateBundleRequest other = (GetCertificateBundleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.certificateVersionName, other.certificateVersionName) && Objects.equals((Object)this.stage, (Object)other.stage) && Objects.equals((Object)this.certificateBundleType, (Object)other.certificateBundleType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.certificateVersionName == null ? 43 : this.certificateVersionName.hashCode());
        result = result * 59 + (this.stage == null ? 43 : this.stage.hashCode());
        result = result * 59 + (this.certificateBundleType == null ? 43 : this.certificateBundleType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCertificateBundleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateId = null;
        private String opcRequestId = null;
        private Long versionNumber = null;
        private String certificateVersionName = null;
        private Stage stage = null;
        private CertificateBundleType certificateBundleType = null;

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder certificateVersionName(String certificateVersionName) {
            this.certificateVersionName = certificateVersionName;
            return this;
        }

        public Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public Builder certificateBundleType(CertificateBundleType certificateBundleType) {
            this.certificateBundleType = certificateBundleType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCertificateBundleRequest o) {
            this.certificateId(o.getCertificateId());
            this.opcRequestId(o.getOpcRequestId());
            this.versionNumber(o.getVersionNumber());
            this.certificateVersionName(o.getCertificateVersionName());
            this.stage(o.getStage());
            this.certificateBundleType(o.getCertificateBundleType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCertificateBundleRequest build() {
            GetCertificateBundleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCertificateBundleRequest buildWithoutInvocationCallback() {
            GetCertificateBundleRequest request = new GetCertificateBundleRequest();
            request.certificateId = this.certificateId;
            request.opcRequestId = this.opcRequestId;
            request.versionNumber = this.versionNumber;
            request.certificateVersionName = this.certificateVersionName;
            request.stage = this.stage;
            request.certificateBundleType = this.certificateBundleType;
            return request;
        }
    }

    public static enum CertificateBundleType implements BmcEnum
    {
        CertificateContentPublicOnly("CERTIFICATE_CONTENT_PUBLIC_ONLY"),
        CertificateContentWithPrivateKey("CERTIFICATE_CONTENT_WITH_PRIVATE_KEY");

        private final String value;
        private static Map<String, CertificateBundleType> map;

        private CertificateBundleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CertificateBundleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CertificateBundleType: " + key);
        }

        static {
            map = new HashMap<String, CertificateBundleType>();
            for (CertificateBundleType v : CertificateBundleType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Stage implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED");

        private final String value;
        private static Map<String, Stage> map;

        private Stage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Stage: " + key);
        }

        static {
            map = new HashMap<String, Stage>();
            for (Stage v : Stage.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

