/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificates.model.RevocationStatus;
import com.oracle.bmc.certificates.model.Validity;
import com.oracle.bmc.certificates.model.VersionStage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CertificateAuthorityBundle
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateAuthorityId")
    private final String certificateAuthorityId;
    @JsonProperty(value="certificateAuthorityName")
    private final String certificateAuthorityName;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="certificatePem")
    private final String certificatePem;
    @JsonProperty(value="certChainPem")
    private final String certChainPem;
    @JsonProperty(value="versionName")
    private final String versionName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="validity")
    private final Validity validity;
    @JsonProperty(value="stages")
    private final List<VersionStage> stages;
    @JsonProperty(value="revocationStatus")
    private final RevocationStatus revocationStatus;

    @Deprecated
    @ConstructorProperties(value={"certificateAuthorityId", "certificateAuthorityName", "serialNumber", "certificatePem", "certChainPem", "versionName", "timeCreated", "versionNumber", "validity", "stages", "revocationStatus"})
    public CertificateAuthorityBundle(String certificateAuthorityId, String certificateAuthorityName, String serialNumber, String certificatePem, String certChainPem, String versionName, Date timeCreated, Long versionNumber, Validity validity, List<VersionStage> stages, RevocationStatus revocationStatus) {
        this.certificateAuthorityId = certificateAuthorityId;
        this.certificateAuthorityName = certificateAuthorityName;
        this.serialNumber = serialNumber;
        this.certificatePem = certificatePem;
        this.certChainPem = certChainPem;
        this.versionName = versionName;
        this.timeCreated = timeCreated;
        this.versionNumber = versionNumber;
        this.validity = validity;
        this.stages = stages;
        this.revocationStatus = revocationStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificateAuthorityId() {
        return this.certificateAuthorityId;
    }

    public String getCertificateAuthorityName() {
        return this.certificateAuthorityName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public String getCertChainPem() {
        return this.certChainPem;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public List<VersionStage> getStages() {
        return this.stages;
    }

    public RevocationStatus getRevocationStatus() {
        return this.revocationStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateAuthorityBundle(");
        sb.append("super=").append(super.toString());
        sb.append("certificateAuthorityId=").append(String.valueOf(this.certificateAuthorityId));
        sb.append(", certificateAuthorityName=").append(String.valueOf(this.certificateAuthorityName));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", certificatePem=").append(String.valueOf(this.certificatePem));
        sb.append(", certChainPem=").append(String.valueOf(this.certChainPem));
        sb.append(", versionName=").append(String.valueOf(this.versionName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", validity=").append(String.valueOf((Object)this.validity));
        sb.append(", stages=").append(String.valueOf(this.stages));
        sb.append(", revocationStatus=").append(String.valueOf((Object)this.revocationStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateAuthorityBundle)) {
            return false;
        }
        CertificateAuthorityBundle other = (CertificateAuthorityBundle)((Object)o);
        return Objects.equals(this.certificateAuthorityId, other.certificateAuthorityId) && Objects.equals(this.certificateAuthorityName, other.certificateAuthorityName) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.certificatePem, other.certificatePem) && Objects.equals(this.certChainPem, other.certChainPem) && Objects.equals(this.versionName, other.versionName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals((Object)this.validity, (Object)other.validity) && Objects.equals(this.stages, other.stages) && Objects.equals((Object)this.revocationStatus, (Object)other.revocationStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateAuthorityId == null ? 43 : this.certificateAuthorityId.hashCode());
        result = result * 59 + (this.certificateAuthorityName == null ? 43 : this.certificateAuthorityName.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.certificatePem == null ? 43 : this.certificatePem.hashCode());
        result = result * 59 + (this.certChainPem == null ? 43 : this.certChainPem.hashCode());
        result = result * 59 + (this.versionName == null ? 43 : this.versionName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.validity == null ? 43 : this.validity.hashCode());
        result = result * 59 + (this.stages == null ? 43 : this.stages.hashCode());
        result = result * 59 + (this.revocationStatus == null ? 43 : this.revocationStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificateAuthorityId")
        private String certificateAuthorityId;
        @JsonProperty(value="certificateAuthorityName")
        private String certificateAuthorityName;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="certificatePem")
        private String certificatePem;
        @JsonProperty(value="certChainPem")
        private String certChainPem;
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="versionNumber")
        private Long versionNumber;
        @JsonProperty(value="validity")
        private Validity validity;
        @JsonProperty(value="stages")
        private List<VersionStage> stages;
        @JsonProperty(value="revocationStatus")
        private RevocationStatus revocationStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
            this.__explicitlySet__.add("certificateAuthorityId");
            return this;
        }

        public Builder certificateAuthorityName(String certificateAuthorityName) {
            this.certificateAuthorityName = certificateAuthorityName;
            this.__explicitlySet__.add("certificateAuthorityName");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            this.__explicitlySet__.add("certificatePem");
            return this;
        }

        public Builder certChainPem(String certChainPem) {
            this.certChainPem = certChainPem;
            this.__explicitlySet__.add("certChainPem");
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder validity(Validity validity) {
            this.validity = validity;
            this.__explicitlySet__.add("validity");
            return this;
        }

        public Builder stages(List<VersionStage> stages) {
            this.stages = stages;
            this.__explicitlySet__.add("stages");
            return this;
        }

        public Builder revocationStatus(RevocationStatus revocationStatus) {
            this.revocationStatus = revocationStatus;
            this.__explicitlySet__.add("revocationStatus");
            return this;
        }

        public CertificateAuthorityBundle build() {
            CertificateAuthorityBundle model = new CertificateAuthorityBundle(this.certificateAuthorityId, this.certificateAuthorityName, this.serialNumber, this.certificatePem, this.certChainPem, this.versionName, this.timeCreated, this.versionNumber, this.validity, this.stages, this.revocationStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateAuthorityBundle model) {
            if (model.wasPropertyExplicitlySet("certificateAuthorityId")) {
                this.certificateAuthorityId(model.getCertificateAuthorityId());
            }
            if (model.wasPropertyExplicitlySet("certificateAuthorityName")) {
                this.certificateAuthorityName(model.getCertificateAuthorityName());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("certificatePem")) {
                this.certificatePem(model.getCertificatePem());
            }
            if (model.wasPropertyExplicitlySet("certChainPem")) {
                this.certChainPem(model.getCertChainPem());
            }
            if (model.wasPropertyExplicitlySet("versionName")) {
                this.versionName(model.getVersionName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("validity")) {
                this.validity(model.getValidity());
            }
            if (model.wasPropertyExplicitlySet("stages")) {
                this.stages(model.getStages());
            }
            if (model.wasPropertyExplicitlySet("revocationStatus")) {
                this.revocationStatus(model.getRevocationStatus());
            }
            return this;
        }
    }
}

