/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetCertificateAuthorityBundleRequest
extends BmcRequest<Void> {
    private String certificateAuthorityId;
    private String opcRequestId;
    private Long versionNumber;
    private String certificateAuthorityVersionName;
    private Stage stage;

    public String getCertificateAuthorityId() {
        return this.certificateAuthorityId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getCertificateAuthorityVersionName() {
        return this.certificateAuthorityVersionName;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new Builder().certificateAuthorityId(this.certificateAuthorityId).opcRequestId(this.opcRequestId).versionNumber(this.versionNumber).certificateAuthorityVersionName(this.certificateAuthorityVersionName).stage(this.stage);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateAuthorityId=").append(String.valueOf(this.certificateAuthorityId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(",certificateAuthorityVersionName=").append(String.valueOf(this.certificateAuthorityVersionName));
        sb.append(",stage=").append(String.valueOf((Object)this.stage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCertificateAuthorityBundleRequest)) {
            return false;
        }
        GetCertificateAuthorityBundleRequest other = (GetCertificateAuthorityBundleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateAuthorityId, other.certificateAuthorityId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.certificateAuthorityVersionName, other.certificateAuthorityVersionName) && Objects.equals((Object)this.stage, (Object)other.stage);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateAuthorityId == null ? 43 : this.certificateAuthorityId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.certificateAuthorityVersionName == null ? 43 : this.certificateAuthorityVersionName.hashCode());
        result = result * 59 + (this.stage == null ? 43 : this.stage.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCertificateAuthorityBundleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateAuthorityId = null;
        private String opcRequestId = null;
        private Long versionNumber = null;
        private String certificateAuthorityVersionName = null;
        private Stage stage = null;

        public Builder certificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder certificateAuthorityVersionName(String certificateAuthorityVersionName) {
            this.certificateAuthorityVersionName = certificateAuthorityVersionName;
            return this;
        }

        public Builder stage(Stage stage) {
            this.stage = stage;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCertificateAuthorityBundleRequest o) {
            this.certificateAuthorityId(o.getCertificateAuthorityId());
            this.opcRequestId(o.getOpcRequestId());
            this.versionNumber(o.getVersionNumber());
            this.certificateAuthorityVersionName(o.getCertificateAuthorityVersionName());
            this.stage(o.getStage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCertificateAuthorityBundleRequest build() {
            GetCertificateAuthorityBundleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCertificateAuthorityBundleRequest buildWithoutInvocationCallback() {
            GetCertificateAuthorityBundleRequest request = new GetCertificateAuthorityBundleRequest();
            request.certificateAuthorityId = this.certificateAuthorityId;
            request.opcRequestId = this.opcRequestId;
            request.versionNumber = this.versionNumber;
            request.certificateAuthorityVersionName = this.certificateAuthorityVersionName;
            request.stage = this.stage;
            return request;
        }
    }

    public static enum Stage implements BmcEnum
    {
        Current("CURRENT"),
        Pending("PENDING"),
        Latest("LATEST"),
        Previous("PREVIOUS"),
        Deprecated("DEPRECATED");

        private final String value;
        private static Map<String, Stage> map;

        private Stage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Stage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Stage: " + key);
        }

        static {
            map = new HashMap<String, Stage>();
            for (Stage v : Stage.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

