/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.certificates.model.CertificateBundlePublicOnly;
import com.oracle.bmc.certificates.model.CertificateBundleWithPrivateKey;
import com.oracle.bmc.certificates.model.RevocationStatus;
import com.oracle.bmc.certificates.model.Validity;
import com.oracle.bmc.certificates.model.VersionStage;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="certificateBundleType", defaultImpl=CertificateBundle.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CertificateBundlePublicOnly.class, name="CERTIFICATE_CONTENT_PUBLIC_ONLY"), @JsonSubTypes.Type(value=CertificateBundleWithPrivateKey.class, name="CERTIFICATE_CONTENT_WITH_PRIVATE_KEY")})
@JsonFilter(value="explicitlySetFilter")
public class CertificateBundle
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificateId")
    private final String certificateId;
    @JsonProperty(value="certificateName")
    private final String certificateName;
    @JsonProperty(value="versionNumber")
    private final Long versionNumber;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="certificatePem")
    private final String certificatePem;
    @JsonProperty(value="certChainPem")
    private final String certChainPem;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="validity")
    private final Validity validity;
    @JsonProperty(value="versionName")
    private final String versionName;
    @JsonProperty(value="stages")
    private final List<VersionStage> stages;
    @JsonProperty(value="revocationStatus")
    private final RevocationStatus revocationStatus;

    @Deprecated
    @ConstructorProperties(value={"certificateId", "certificateName", "versionNumber", "serialNumber", "certificatePem", "certChainPem", "timeCreated", "validity", "versionName", "stages", "revocationStatus"})
    protected CertificateBundle(String certificateId, String certificateName, Long versionNumber, String serialNumber, String certificatePem, String certChainPem, Date timeCreated, Validity validity, String versionName, List<VersionStage> stages, RevocationStatus revocationStatus) {
        this.certificateId = certificateId;
        this.certificateName = certificateName;
        this.versionNumber = versionNumber;
        this.serialNumber = serialNumber;
        this.certificatePem = certificatePem;
        this.certChainPem = certChainPem;
        this.timeCreated = timeCreated;
        this.validity = validity;
        this.versionName = versionName;
        this.stages = stages;
        this.revocationStatus = revocationStatus;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public String getCertChainPem() {
        return this.certChainPem;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public List<VersionStage> getStages() {
        return this.stages;
    }

    public RevocationStatus getRevocationStatus() {
        return this.revocationStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateBundle(");
        sb.append("super=").append(super.toString());
        sb.append("certificateId=").append(String.valueOf(this.certificateId));
        sb.append(", certificateName=").append(String.valueOf(this.certificateName));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", certificatePem=").append(String.valueOf(this.certificatePem));
        sb.append(", certChainPem=").append(String.valueOf(this.certChainPem));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", validity=").append(String.valueOf((Object)this.validity));
        sb.append(", versionName=").append(String.valueOf(this.versionName));
        sb.append(", stages=").append(String.valueOf(this.stages));
        sb.append(", revocationStatus=").append(String.valueOf((Object)this.revocationStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateBundle)) {
            return false;
        }
        CertificateBundle other = (CertificateBundle)((Object)o);
        return Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.certificateName, other.certificateName) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.certificatePem, other.certificatePem) && Objects.equals(this.certChainPem, other.certChainPem) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.validity, (Object)other.validity) && Objects.equals(this.versionName, other.versionName) && Objects.equals(this.stages, other.stages) && Objects.equals((Object)this.revocationStatus, (Object)other.revocationStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.certificateName == null ? 43 : this.certificateName.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.certificatePem == null ? 43 : this.certificatePem.hashCode());
        result = result * 59 + (this.certChainPem == null ? 43 : this.certChainPem.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.validity == null ? 43 : this.validity.hashCode());
        result = result * 59 + (this.versionName == null ? 43 : this.versionName.hashCode());
        result = result * 59 + (this.stages == null ? 43 : this.stages.hashCode());
        result = result * 59 + (this.revocationStatus == null ? 43 : this.revocationStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CertificateBundleType implements BmcEnum
    {
        CertificateContentPublicOnly("CERTIFICATE_CONTENT_PUBLIC_ONLY"),
        CertificateContentWithPrivateKey("CERTIFICATE_CONTENT_WITH_PRIVATE_KEY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CertificateBundleType> map;

        private CertificateBundleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CertificateBundleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CertificateBundleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CertificateBundleType.class);
            map = new HashMap<String, CertificateBundleType>();
            for (CertificateBundleType v : CertificateBundleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

