/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CertificateRule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonFilter(value="explicitlySetFilter")
public final class CertificateRenewalRule
extends CertificateRule {
    @JsonProperty(value="renewalInterval")
    private final String renewalInterval;
    @JsonProperty(value="advanceRenewalPeriod")
    private final String advanceRenewalPeriod;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CertificateRenewalRule(String renewalInterval, String advanceRenewalPeriod) {
        this.renewalInterval = renewalInterval;
        this.advanceRenewalPeriod = advanceRenewalPeriod;
    }

    public String getRenewalInterval() {
        return this.renewalInterval;
    }

    public String getAdvanceRenewalPeriod() {
        return this.advanceRenewalPeriod;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateRenewalRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", renewalInterval=").append(String.valueOf(this.renewalInterval));
        sb.append(", advanceRenewalPeriod=").append(String.valueOf(this.advanceRenewalPeriod));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateRenewalRule)) {
            return false;
        }
        CertificateRenewalRule other = (CertificateRenewalRule)((Object)o);
        return Objects.equals(this.renewalInterval, other.renewalInterval) && Objects.equals(this.advanceRenewalPeriod, other.advanceRenewalPeriod) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.renewalInterval == null ? 43 : this.renewalInterval.hashCode());
        result = result * 59 + (this.advanceRenewalPeriod == null ? 43 : this.advanceRenewalPeriod.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="renewalInterval")
        private String renewalInterval;
        @JsonProperty(value="advanceRenewalPeriod")
        private String advanceRenewalPeriod;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder renewalInterval(String renewalInterval) {
            this.renewalInterval = renewalInterval;
            this.__explicitlySet__.add("renewalInterval");
            return this;
        }

        public Builder advanceRenewalPeriod(String advanceRenewalPeriod) {
            this.advanceRenewalPeriod = advanceRenewalPeriod;
            this.__explicitlySet__.add("advanceRenewalPeriod");
            return this;
        }

        public CertificateRenewalRule build() {
            CertificateRenewalRule model = new CertificateRenewalRule(this.renewalInterval, this.advanceRenewalPeriod);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CertificateRenewalRule model) {
            if (model.wasPropertyExplicitlySet("renewalInterval")) {
                this.renewalInterval(model.getRenewalInterval());
            }
            if (model.wasPropertyExplicitlySet("advanceRenewalPeriod")) {
                this.advanceRenewalPeriod(model.getAdvanceRenewalPeriod());
            }
            return this;
        }
    }
}

