/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CertificateRule;
import com.oracle.bmc.certificatesmanagement.model.UpdateCertificateConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateCertificateDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="currentVersionNumber")
    private final Long currentVersionNumber;
    @JsonProperty(value="certificateConfig")
    private final UpdateCertificateConfigDetails certificateConfig;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="certificateRules")
    private final List<CertificateRule> certificateRules;

    @Deprecated
    @ConstructorProperties(value={"description", "currentVersionNumber", "certificateConfig", "freeformTags", "definedTags", "certificateRules"})
    public UpdateCertificateDetails(String description, Long currentVersionNumber, UpdateCertificateConfigDetails certificateConfig, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<CertificateRule> certificateRules) {
        this.description = description;
        this.currentVersionNumber = currentVersionNumber;
        this.certificateConfig = certificateConfig;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.certificateRules = certificateRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public Long getCurrentVersionNumber() {
        return this.currentVersionNumber;
    }

    public UpdateCertificateConfigDetails getCertificateConfig() {
        return this.certificateConfig;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<CertificateRule> getCertificateRules() {
        return this.certificateRules;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateCertificateDetails(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", currentVersionNumber=").append(String.valueOf(this.currentVersionNumber));
        sb.append(", certificateConfig=").append(String.valueOf((Object)this.certificateConfig));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", certificateRules=").append(String.valueOf(this.certificateRules));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCertificateDetails)) {
            return false;
        }
        UpdateCertificateDetails other = (UpdateCertificateDetails)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.currentVersionNumber, other.currentVersionNumber) && Objects.equals((Object)this.certificateConfig, (Object)other.certificateConfig) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.certificateRules, other.certificateRules) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.currentVersionNumber == null ? 43 : this.currentVersionNumber.hashCode());
        result = result * 59 + (this.certificateConfig == null ? 43 : this.certificateConfig.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.certificateRules == null ? 43 : this.certificateRules.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="currentVersionNumber")
        private Long currentVersionNumber;
        @JsonProperty(value="certificateConfig")
        private UpdateCertificateConfigDetails certificateConfig;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="certificateRules")
        private List<CertificateRule> certificateRules;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder currentVersionNumber(Long currentVersionNumber) {
            this.currentVersionNumber = currentVersionNumber;
            this.__explicitlySet__.add("currentVersionNumber");
            return this;
        }

        public Builder certificateConfig(UpdateCertificateConfigDetails certificateConfig) {
            this.certificateConfig = certificateConfig;
            this.__explicitlySet__.add("certificateConfig");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder certificateRules(List<CertificateRule> certificateRules) {
            this.certificateRules = certificateRules;
            this.__explicitlySet__.add("certificateRules");
            return this;
        }

        public UpdateCertificateDetails build() {
            UpdateCertificateDetails model = new UpdateCertificateDetails(this.description, this.currentVersionNumber, this.certificateConfig, this.freeformTags, this.definedTags, this.certificateRules);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateCertificateDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("currentVersionNumber")) {
                this.currentVersionNumber(model.getCurrentVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("certificateConfig")) {
                this.certificateConfig(model.getCertificateConfig());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("certificateRules")) {
                this.certificateRules(model.getCertificateRules());
            }
            return this;
        }
    }
}

