/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CertificateConfigType;
import com.oracle.bmc.certificatesmanagement.model.CertificateLifecycleState;
import com.oracle.bmc.certificatesmanagement.model.CertificateProfileType;
import com.oracle.bmc.certificatesmanagement.model.CertificateRevocationListDetails;
import com.oracle.bmc.certificatesmanagement.model.CertificateRule;
import com.oracle.bmc.certificatesmanagement.model.CertificateSubject;
import com.oracle.bmc.certificatesmanagement.model.CertificateVersionSummary;
import com.oracle.bmc.certificatesmanagement.model.KeyAlgorithm;
import com.oracle.bmc.certificatesmanagement.model.SignatureAlgorithm;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Certificate
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="issuerCertificateAuthorityId")
    private final String issuerCertificateAuthorityId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="certificateRules")
    private final List<CertificateRule> certificateRules;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfDeletion")
    private final Date timeOfDeletion;
    @JsonProperty(value="lifecycleState")
    private final CertificateLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="currentVersion")
    private final CertificateVersionSummary currentVersion;
    @JsonProperty(value="subject")
    private final CertificateSubject subject;
    @JsonProperty(value="certificateRevocationListDetails")
    private final CertificateRevocationListDetails certificateRevocationListDetails;
    @JsonProperty(value="configType")
    private final CertificateConfigType configType;
    @JsonProperty(value="keyAlgorithm")
    private final KeyAlgorithm keyAlgorithm;
    @JsonProperty(value="signatureAlgorithm")
    private final SignatureAlgorithm signatureAlgorithm;
    @JsonProperty(value="certificateProfileType")
    private final CertificateProfileType certificateProfileType;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "issuerCertificateAuthorityId", "name", "description", "certificateRules", "timeCreated", "timeOfDeletion", "lifecycleState", "lifecycleDetails", "compartmentId", "currentVersion", "subject", "certificateRevocationListDetails", "configType", "keyAlgorithm", "signatureAlgorithm", "certificateProfileType", "freeformTags", "definedTags"})
    public Certificate(String id, String issuerCertificateAuthorityId, String name, String description, List<CertificateRule> certificateRules, Date timeCreated, Date timeOfDeletion, CertificateLifecycleState lifecycleState, String lifecycleDetails, String compartmentId, CertificateVersionSummary currentVersion, CertificateSubject subject, CertificateRevocationListDetails certificateRevocationListDetails, CertificateConfigType configType, KeyAlgorithm keyAlgorithm, SignatureAlgorithm signatureAlgorithm, CertificateProfileType certificateProfileType, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
        this.name = name;
        this.description = description;
        this.certificateRules = certificateRules;
        this.timeCreated = timeCreated;
        this.timeOfDeletion = timeOfDeletion;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.compartmentId = compartmentId;
        this.currentVersion = currentVersion;
        this.subject = subject;
        this.certificateRevocationListDetails = certificateRevocationListDetails;
        this.configType = configType;
        this.keyAlgorithm = keyAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
        this.certificateProfileType = certificateProfileType;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getIssuerCertificateAuthorityId() {
        return this.issuerCertificateAuthorityId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CertificateRule> getCertificateRules() {
        return this.certificateRules;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfDeletion() {
        return this.timeOfDeletion;
    }

    public CertificateLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public CertificateVersionSummary getCurrentVersion() {
        return this.currentVersion;
    }

    public CertificateSubject getSubject() {
        return this.subject;
    }

    public CertificateRevocationListDetails getCertificateRevocationListDetails() {
        return this.certificateRevocationListDetails;
    }

    public CertificateConfigType getConfigType() {
        return this.configType;
    }

    public KeyAlgorithm getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public CertificateProfileType getCertificateProfileType() {
        return this.certificateProfileType;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", issuerCertificateAuthorityId=").append(String.valueOf(this.issuerCertificateAuthorityId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", certificateRules=").append(String.valueOf(this.certificateRules));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfDeletion=").append(String.valueOf(this.timeOfDeletion));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", currentVersion=").append(String.valueOf((Object)this.currentVersion));
        sb.append(", subject=").append(String.valueOf((Object)this.subject));
        sb.append(", certificateRevocationListDetails=").append(String.valueOf((Object)this.certificateRevocationListDetails));
        sb.append(", configType=").append(String.valueOf((Object)this.configType));
        sb.append(", keyAlgorithm=").append(String.valueOf((Object)this.keyAlgorithm));
        sb.append(", signatureAlgorithm=").append(String.valueOf((Object)this.signatureAlgorithm));
        sb.append(", certificateProfileType=").append(String.valueOf((Object)this.certificateProfileType));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.issuerCertificateAuthorityId, other.issuerCertificateAuthorityId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.certificateRules, other.certificateRules) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfDeletion, other.timeOfDeletion) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.currentVersion, (Object)other.currentVersion) && Objects.equals((Object)this.subject, (Object)other.subject) && Objects.equals((Object)this.certificateRevocationListDetails, (Object)other.certificateRevocationListDetails) && Objects.equals((Object)this.configType, (Object)other.configType) && Objects.equals((Object)this.keyAlgorithm, (Object)other.keyAlgorithm) && Objects.equals((Object)this.signatureAlgorithm, (Object)other.signatureAlgorithm) && Objects.equals((Object)this.certificateProfileType, (Object)other.certificateProfileType) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.issuerCertificateAuthorityId == null ? 43 : this.issuerCertificateAuthorityId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.certificateRules == null ? 43 : this.certificateRules.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfDeletion == null ? 43 : this.timeOfDeletion.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.currentVersion == null ? 43 : this.currentVersion.hashCode());
        result = result * 59 + (this.subject == null ? 43 : this.subject.hashCode());
        result = result * 59 + (this.certificateRevocationListDetails == null ? 43 : this.certificateRevocationListDetails.hashCode());
        result = result * 59 + (this.configType == null ? 43 : this.configType.hashCode());
        result = result * 59 + (this.keyAlgorithm == null ? 43 : this.keyAlgorithm.hashCode());
        result = result * 59 + (this.signatureAlgorithm == null ? 43 : this.signatureAlgorithm.hashCode());
        result = result * 59 + (this.certificateProfileType == null ? 43 : this.certificateProfileType.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="issuerCertificateAuthorityId")
        private String issuerCertificateAuthorityId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="certificateRules")
        private List<CertificateRule> certificateRules;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfDeletion")
        private Date timeOfDeletion;
        @JsonProperty(value="lifecycleState")
        private CertificateLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="currentVersion")
        private CertificateVersionSummary currentVersion;
        @JsonProperty(value="subject")
        private CertificateSubject subject;
        @JsonProperty(value="certificateRevocationListDetails")
        private CertificateRevocationListDetails certificateRevocationListDetails;
        @JsonProperty(value="configType")
        private CertificateConfigType configType;
        @JsonProperty(value="keyAlgorithm")
        private KeyAlgorithm keyAlgorithm;
        @JsonProperty(value="signatureAlgorithm")
        private SignatureAlgorithm signatureAlgorithm;
        @JsonProperty(value="certificateProfileType")
        private CertificateProfileType certificateProfileType;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder issuerCertificateAuthorityId(String issuerCertificateAuthorityId) {
            this.issuerCertificateAuthorityId = issuerCertificateAuthorityId;
            this.__explicitlySet__.add("issuerCertificateAuthorityId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder certificateRules(List<CertificateRule> certificateRules) {
            this.certificateRules = certificateRules;
            this.__explicitlySet__.add("certificateRules");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfDeletion(Date timeOfDeletion) {
            this.timeOfDeletion = timeOfDeletion;
            this.__explicitlySet__.add("timeOfDeletion");
            return this;
        }

        public Builder lifecycleState(CertificateLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder currentVersion(CertificateVersionSummary currentVersion) {
            this.currentVersion = currentVersion;
            this.__explicitlySet__.add("currentVersion");
            return this;
        }

        public Builder subject(CertificateSubject subject) {
            this.subject = subject;
            this.__explicitlySet__.add("subject");
            return this;
        }

        public Builder certificateRevocationListDetails(CertificateRevocationListDetails certificateRevocationListDetails) {
            this.certificateRevocationListDetails = certificateRevocationListDetails;
            this.__explicitlySet__.add("certificateRevocationListDetails");
            return this;
        }

        public Builder configType(CertificateConfigType configType) {
            this.configType = configType;
            this.__explicitlySet__.add("configType");
            return this;
        }

        public Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.__explicitlySet__.add("keyAlgorithm");
            return this;
        }

        public Builder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            this.__explicitlySet__.add("signatureAlgorithm");
            return this;
        }

        public Builder certificateProfileType(CertificateProfileType certificateProfileType) {
            this.certificateProfileType = certificateProfileType;
            this.__explicitlySet__.add("certificateProfileType");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Certificate build() {
            Certificate model = new Certificate(this.id, this.issuerCertificateAuthorityId, this.name, this.description, this.certificateRules, this.timeCreated, this.timeOfDeletion, this.lifecycleState, this.lifecycleDetails, this.compartmentId, this.currentVersion, this.subject, this.certificateRevocationListDetails, this.configType, this.keyAlgorithm, this.signatureAlgorithm, this.certificateProfileType, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Certificate model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("issuerCertificateAuthorityId")) {
                this.issuerCertificateAuthorityId(model.getIssuerCertificateAuthorityId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("certificateRules")) {
                this.certificateRules(model.getCertificateRules());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfDeletion")) {
                this.timeOfDeletion(model.getTimeOfDeletion());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("currentVersion")) {
                this.currentVersion(model.getCurrentVersion());
            }
            if (model.wasPropertyExplicitlySet("subject")) {
                this.subject(model.getSubject());
            }
            if (model.wasPropertyExplicitlySet("certificateRevocationListDetails")) {
                this.certificateRevocationListDetails(model.getCertificateRevocationListDetails());
            }
            if (model.wasPropertyExplicitlySet("configType")) {
                this.configType(model.getConfigType());
            }
            if (model.wasPropertyExplicitlySet("keyAlgorithm")) {
                this.keyAlgorithm(model.getKeyAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("signatureAlgorithm")) {
                this.signatureAlgorithm(model.getSignatureAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("certificateProfileType")) {
                this.certificateProfileType(model.getCertificateProfileType());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

