/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SignatureAlgorithm implements BmcEnum
{
    Sha256WithRsa("SHA256_WITH_RSA"),
    Sha384WithRsa("SHA384_WITH_RSA"),
    Sha512WithRsa("SHA512_WITH_RSA"),
    Sha256WithEcdsa("SHA256_WITH_ECDSA"),
    Sha384WithEcdsa("SHA384_WITH_ECDSA"),
    Sha512WithEcdsa("SHA512_WITH_ECDSA"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, SignatureAlgorithm> map;

    private SignatureAlgorithm(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static SignatureAlgorithm create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'SignatureAlgorithm', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(SignatureAlgorithm.class);
        map = new HashMap<String, SignatureAlgorithm>();
        for (SignatureAlgorithm v : SignatureAlgorithm.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

