/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.certificatesmanagement.model.ScheduleCertificateDeletionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ScheduleCertificateDeletionRequest
extends BmcRequest<ScheduleCertificateDeletionDetails> {
    private String certificateId;
    private ScheduleCertificateDeletionDetails scheduleCertificateDeletionDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getCertificateId() {
        return this.certificateId;
    }

    public ScheduleCertificateDeletionDetails getScheduleCertificateDeletionDetails() {
        return this.scheduleCertificateDeletionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ScheduleCertificateDeletionDetails getBody$() {
        return this.scheduleCertificateDeletionDetails;
    }

    public Builder toBuilder() {
        return new Builder().certificateId(this.certificateId).scheduleCertificateDeletionDetails(this.scheduleCertificateDeletionDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateId=").append(String.valueOf(this.certificateId));
        sb.append(",scheduleCertificateDeletionDetails=").append(String.valueOf((Object)this.scheduleCertificateDeletionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleCertificateDeletionRequest)) {
            return false;
        }
        ScheduleCertificateDeletionRequest other = (ScheduleCertificateDeletionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals((Object)this.scheduleCertificateDeletionDetails, (Object)other.scheduleCertificateDeletionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.scheduleCertificateDeletionDetails == null ? 43 : this.scheduleCertificateDeletionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ScheduleCertificateDeletionRequest, ScheduleCertificateDeletionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateId = null;
        private ScheduleCertificateDeletionDetails scheduleCertificateDeletionDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder scheduleCertificateDeletionDetails(ScheduleCertificateDeletionDetails scheduleCertificateDeletionDetails) {
            this.scheduleCertificateDeletionDetails = scheduleCertificateDeletionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ScheduleCertificateDeletionRequest o) {
            this.certificateId(o.getCertificateId());
            this.scheduleCertificateDeletionDetails(o.getScheduleCertificateDeletionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ScheduleCertificateDeletionRequest build() {
            ScheduleCertificateDeletionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ScheduleCertificateDeletionDetails body) {
            this.scheduleCertificateDeletionDetails(body);
            return this;
        }

        public ScheduleCertificateDeletionRequest buildWithoutInvocationCallback() {
            ScheduleCertificateDeletionRequest request = new ScheduleCertificateDeletionRequest();
            request.certificateId = this.certificateId;
            request.scheduleCertificateDeletionDetails = this.scheduleCertificateDeletionDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

