/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.cims.model.ValidationResponse;
import com.oracle.bmc.cims.requests.ValidateUserRequest;
import com.oracle.bmc.cims.responses.ValidateUserResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUserConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateUserConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ValidateUserRequest interceptRequest(ValidateUserRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ValidateUserRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCsi(), (String)"csi is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getOcid(), (String)"ocid is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181231").path("v2").path("incidents").path("user").path("validate");
        if (request.getProblemType() != null) {
            target = target.queryParam("problemType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getProblemType())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        ib.header("csi", (Object)request.getCsi());
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        ib.header("ocid", (Object)request.getOcid());
        if (request.getHomeregion() != null) {
            ib.header("homeregion", (Object)request.getHomeregion());
        }
        return ib;
    }

    public static Function<Response, ValidateUserResponse> fromResponse() {
        Function<Response, ValidateUserResponse> transformer = new Function<Response, ValidateUserResponse>(){

            public ValidateUserResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.cims.responses.ValidateUserResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ValidationResponse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ValidateUserResponse.Builder builder = ValidateUserResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.validationResponse((ValidationResponse)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ValidateUserResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

