/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetIncidentRequest
extends BmcRequest<Void> {
    private String incidentKey;
    private String csi;
    private String ocid;
    private String opcRequestId;
    private String homeregion;
    private String problemType;

    @ConstructorProperties(value={"incidentKey", "csi", "ocid", "opcRequestId", "homeregion", "problemType"})
    GetIncidentRequest(String incidentKey, String csi, String ocid, String opcRequestId, String homeregion, String problemType) {
        this.incidentKey = incidentKey;
        this.csi = csi;
        this.ocid = ocid;
        this.opcRequestId = opcRequestId;
        this.homeregion = homeregion;
        this.problemType = problemType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIncidentKey() {
        return this.incidentKey;
    }

    public String getCsi() {
        return this.csi;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIncidentRequest, Void> {
        private String incidentKey;
        private String csi;
        private String ocid;
        private String opcRequestId;
        private String homeregion;
        private String problemType;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIncidentRequest o) {
            this.incidentKey(o.getIncidentKey());
            this.csi(o.getCsi());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.homeregion(o.getHomeregion());
            this.problemType(o.getProblemType());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIncidentRequest build() {
            GetIncidentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder incidentKey(String incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public GetIncidentRequest buildWithoutInvocationCallback() {
            return new GetIncidentRequest(this.incidentKey, this.csi, this.ocid, this.opcRequestId, this.homeregion, this.problemType);
        }

        public String toString() {
            return "GetIncidentRequest.Builder(incidentKey=" + this.incidentKey + ", csi=" + this.csi + ", ocid=" + this.ocid + ", opcRequestId=" + this.opcRequestId + ", homeregion=" + this.homeregion + ", problemType=" + this.problemType + ")";
        }
    }
}

