/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.Category;
import com.oracle.bmc.cims.model.IssueType;
import com.oracle.bmc.cims.model.Item;
import com.oracle.bmc.cims.model.SubCategory;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class LimitItem
extends Item {
    @JsonProperty(value="currentLimit")
    private final Integer currentLimit;
    @JsonProperty(value="currentUsage")
    private final Integer currentUsage;
    @JsonProperty(value="requestedLimit")
    private final Integer requestedLimit;
    @JsonProperty(value="limitStatus")
    private final LimitStatus limitStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public LimitItem(String itemKey, String name, Category category, SubCategory subCategory, IssueType issueType, Integer currentLimit, Integer currentUsage, Integer requestedLimit, LimitStatus limitStatus) {
        super(itemKey, name, category, subCategory, issueType);
        this.currentLimit = currentLimit;
        this.currentUsage = currentUsage;
        this.requestedLimit = requestedLimit;
        this.limitStatus = limitStatus;
    }

    public Integer getCurrentLimit() {
        return this.currentLimit;
    }

    public Integer getCurrentUsage() {
        return this.currentUsage;
    }

    public Integer getRequestedLimit() {
        return this.requestedLimit;
    }

    public LimitStatus getLimitStatus() {
        return this.limitStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LimitItem(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", currentLimit=").append(String.valueOf(this.currentLimit));
        sb.append(", currentUsage=").append(String.valueOf(this.currentUsage));
        sb.append(", requestedLimit=").append(String.valueOf(this.requestedLimit));
        sb.append(", limitStatus=").append(String.valueOf((Object)this.limitStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LimitItem)) {
            return false;
        }
        LimitItem other = (LimitItem)((Object)o);
        return Objects.equals(this.currentLimit, other.currentLimit) && Objects.equals(this.currentUsage, other.currentUsage) && Objects.equals(this.requestedLimit, other.requestedLimit) && Objects.equals((Object)this.limitStatus, (Object)other.limitStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.currentLimit == null ? 43 : this.currentLimit.hashCode());
        result = result * 59 + (this.currentUsage == null ? 43 : this.currentUsage.hashCode());
        result = result * 59 + (this.requestedLimit == null ? 43 : this.requestedLimit.hashCode());
        result = result * 59 + (this.limitStatus == null ? 43 : this.limitStatus.hashCode());
        return result;
    }

    public static enum LimitStatus implements BmcEnum
    {
        Approved("APPROVED"),
        PartiallyApproved("PARTIALLY_APPROVED"),
        NotApproved("NOT_APPROVED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LimitStatus> map;

        private LimitStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LimitStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LimitStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LimitStatus.class);
            map = new HashMap<String, LimitStatus>();
            for (LimitStatus v : LimitStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="itemKey")
        private String itemKey;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="subCategory")
        private SubCategory subCategory;
        @JsonProperty(value="issueType")
        private IssueType issueType;
        @JsonProperty(value="currentLimit")
        private Integer currentLimit;
        @JsonProperty(value="currentUsage")
        private Integer currentUsage;
        @JsonProperty(value="requestedLimit")
        private Integer requestedLimit;
        @JsonProperty(value="limitStatus")
        private LimitStatus limitStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder itemKey(String itemKey) {
            this.itemKey = itemKey;
            this.__explicitlySet__.add("itemKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            this.__explicitlySet__.add("subCategory");
            return this;
        }

        public Builder issueType(IssueType issueType) {
            this.issueType = issueType;
            this.__explicitlySet__.add("issueType");
            return this;
        }

        public Builder currentLimit(Integer currentLimit) {
            this.currentLimit = currentLimit;
            this.__explicitlySet__.add("currentLimit");
            return this;
        }

        public Builder currentUsage(Integer currentUsage) {
            this.currentUsage = currentUsage;
            this.__explicitlySet__.add("currentUsage");
            return this;
        }

        public Builder requestedLimit(Integer requestedLimit) {
            this.requestedLimit = requestedLimit;
            this.__explicitlySet__.add("requestedLimit");
            return this;
        }

        public Builder limitStatus(LimitStatus limitStatus) {
            this.limitStatus = limitStatus;
            this.__explicitlySet__.add("limitStatus");
            return this;
        }

        public LimitItem build() {
            LimitItem model = new LimitItem(this.itemKey, this.name, this.category, this.subCategory, this.issueType, this.currentLimit, this.currentUsage, this.requestedLimit, this.limitStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LimitItem model) {
            if (model.wasPropertyExplicitlySet("itemKey")) {
                this.itemKey(model.getItemKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("subCategory")) {
                this.subCategory(model.getSubCategory());
            }
            if (model.wasPropertyExplicitlySet("issueType")) {
                this.issueType(model.getIssueType());
            }
            if (model.wasPropertyExplicitlySet("currentLimit")) {
                this.currentLimit(model.getCurrentLimit());
            }
            if (model.wasPropertyExplicitlySet("currentUsage")) {
                this.currentUsage(model.getCurrentUsage());
            }
            if (model.wasPropertyExplicitlySet("requestedLimit")) {
                this.requestedLimit(model.getRequestedLimit());
            }
            if (model.wasPropertyExplicitlySet("limitStatus")) {
                this.limitStatus(model.getLimitStatus());
            }
            return this;
        }
    }
}

