/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStatusRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String ocid;
    private String homeregion;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).ocid(this.ocid).homeregion(this.homeregion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStatusRequest)) {
            return false;
        }
        GetStatusRequest other = (GetStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.homeregion, other.homeregion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStatusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String ocid = null;
        private String homeregion = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStatusRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.ocid(o.getOcid());
            this.homeregion(o.getHomeregion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStatusRequest build() {
            GetStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStatusRequest buildWithoutInvocationCallback() {
            GetStatusRequest request = new GetStatusRequest();
            request.opcRequestId = this.opcRequestId;
            request.ocid = this.ocid;
            request.homeregion = this.homeregion;
            return request;
        }
    }
}

