/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.cims.model.SortBy;
import com.oracle.bmc.cims.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListIncidentResourceTypesRequest
extends BmcRequest<Void> {
    private String problemType;
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String name;
    private String csi;
    private String ocid;
    private String homeregion;
    private String domainid;

    public String getProblemType() {
        return this.problemType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public String getCsi() {
        return this.csi;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getDomainid() {
        return this.domainid;
    }

    public Builder toBuilder() {
        return new Builder().problemType(this.problemType).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).name(this.name).csi(this.csi).ocid(this.ocid).homeregion(this.homeregion).domainid(this.domainid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",problemType=").append(String.valueOf(this.problemType));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(",domainid=").append(String.valueOf(this.domainid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIncidentResourceTypesRequest)) {
            return false;
        }
        ListIncidentResourceTypesRequest other = (ListIncidentResourceTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.problemType, other.problemType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.name, other.name) && Objects.equals(this.csi, other.csi) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.homeregion, other.homeregion) && Objects.equals(this.domainid, other.domainid);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        result = result * 59 + (this.domainid == null ? 43 : this.domainid.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIncidentResourceTypesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String problemType = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String name = null;
        private String csi = null;
        private String ocid = null;
        private String homeregion = null;
        private String domainid = null;

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder domainid(String domainid) {
            this.domainid = domainid;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIncidentResourceTypesRequest o) {
            this.problemType(o.getProblemType());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.name(o.getName());
            this.csi(o.getCsi());
            this.ocid(o.getOcid());
            this.homeregion(o.getHomeregion());
            this.domainid(o.getDomainid());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIncidentResourceTypesRequest build() {
            ListIncidentResourceTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIncidentResourceTypesRequest buildWithoutInvocationCallback() {
            ListIncidentResourceTypesRequest request = new ListIncidentResourceTypesRequest();
            request.problemType = this.problemType;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.name = this.name;
            request.csi = this.csi;
            request.ocid = this.ocid;
            request.homeregion = this.homeregion;
            request.domainid = this.domainid;
            return request;
        }
    }
}

