/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.cims.model.ProblemType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateUserRequest
extends BmcRequest<Void> {
    private String csi;
    private String opcRequestId;
    private ProblemType problemType;
    private String ocid;
    private String homeregion;
    private String bearertokentype;
    private String bearertoken;
    private String idtoken;
    private String domainid;

    public String getCsi() {
        return this.csi;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getBearertokentype() {
        return this.bearertokentype;
    }

    public String getBearertoken() {
        return this.bearertoken;
    }

    public String getIdtoken() {
        return this.idtoken;
    }

    public String getDomainid() {
        return this.domainid;
    }

    public Builder toBuilder() {
        return new Builder().csi(this.csi).opcRequestId(this.opcRequestId).problemType(this.problemType).ocid(this.ocid).homeregion(this.homeregion).bearertokentype(this.bearertokentype).bearertoken(this.bearertoken).idtoken(this.idtoken).domainid(this.domainid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",problemType=").append(String.valueOf((Object)this.problemType));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(",bearertokentype=").append(String.valueOf(this.bearertokentype));
        sb.append(",bearertoken=").append(String.valueOf(this.bearertoken));
        sb.append(",idtoken=").append(String.valueOf(this.idtoken));
        sb.append(",domainid=").append(String.valueOf(this.domainid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateUserRequest)) {
            return false;
        }
        ValidateUserRequest other = (ValidateUserRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.csi, other.csi) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.problemType, (Object)other.problemType) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.homeregion, other.homeregion) && Objects.equals(this.bearertokentype, other.bearertokentype) && Objects.equals(this.bearertoken, other.bearertoken) && Objects.equals(this.idtoken, other.idtoken) && Objects.equals(this.domainid, other.domainid);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        result = result * 59 + (this.bearertokentype == null ? 43 : this.bearertokentype.hashCode());
        result = result * 59 + (this.bearertoken == null ? 43 : this.bearertoken.hashCode());
        result = result * 59 + (this.idtoken == null ? 43 : this.idtoken.hashCode());
        result = result * 59 + (this.domainid == null ? 43 : this.domainid.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateUserRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String csi = null;
        private String opcRequestId = null;
        private ProblemType problemType = null;
        private String ocid = null;
        private String homeregion = null;
        private String bearertokentype = null;
        private String bearertoken = null;
        private String idtoken = null;
        private String domainid = null;

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder problemType(ProblemType problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder bearertokentype(String bearertokentype) {
            this.bearertokentype = bearertokentype;
            return this;
        }

        public Builder bearertoken(String bearertoken) {
            this.bearertoken = bearertoken;
            return this;
        }

        public Builder idtoken(String idtoken) {
            this.idtoken = idtoken;
            return this;
        }

        public Builder domainid(String domainid) {
            this.domainid = domainid;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateUserRequest o) {
            this.csi(o.getCsi());
            this.opcRequestId(o.getOpcRequestId());
            this.problemType(o.getProblemType());
            this.ocid(o.getOcid());
            this.homeregion(o.getHomeregion());
            this.bearertokentype(o.getBearertokentype());
            this.bearertoken(o.getBearertoken());
            this.idtoken(o.getIdtoken());
            this.domainid(o.getDomainid());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateUserRequest build() {
            ValidateUserRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ValidateUserRequest buildWithoutInvocationCallback() {
            ValidateUserRequest request = new ValidateUserRequest();
            request.csi = this.csi;
            request.opcRequestId = this.opcRequestId;
            request.problemType = this.problemType;
            request.ocid = this.ocid;
            request.homeregion = this.homeregion;
            request.bearertokentype = this.bearertokentype;
            request.bearertoken = this.bearertoken;
            request.idtoken = this.idtoken;
            request.domainid = this.domainid;
            return request;
        }
    }
}

