/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.ContextualData;
import com.oracle.bmc.cims.model.CreateResourceDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateTicketDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="resourceList")
    private final List<CreateResourceDetails> resourceList;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="contextualData")
    private final ContextualData contextualData;

    @Deprecated
    @ConstructorProperties(value={"severity", "resourceList", "title", "description", "contextualData"})
    public CreateTicketDetails(Severity severity, List<CreateResourceDetails> resourceList, String title, String description, ContextualData contextualData) {
        this.severity = severity;
        this.resourceList = resourceList;
        this.title = title;
        this.description = description;
        this.contextualData = contextualData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<CreateResourceDetails> getResourceList() {
        return this.resourceList;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public ContextualData getContextualData() {
        return this.contextualData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTicketDetails(");
        sb.append("super=").append(super.toString());
        sb.append("severity=").append(String.valueOf((Object)this.severity));
        sb.append(", resourceList=").append(String.valueOf(this.resourceList));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", contextualData=").append(String.valueOf((Object)this.contextualData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTicketDetails)) {
            return false;
        }
        CreateTicketDetails other = (CreateTicketDetails)((Object)o);
        return Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.resourceList, other.resourceList) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.contextualData, (Object)other.contextualData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.resourceList == null ? 43 : this.resourceList.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.contextualData == null ? 43 : this.contextualData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        Highest("HIGHEST"),
        High("HIGH"),
        Medium("MEDIUM"),
        Low("LOW");

        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Severity: " + key);
        }

        static {
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="resourceList")
        private List<CreateResourceDetails> resourceList;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="contextualData")
        private ContextualData contextualData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder resourceList(List<CreateResourceDetails> resourceList) {
            this.resourceList = resourceList;
            this.__explicitlySet__.add("resourceList");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder contextualData(ContextualData contextualData) {
            this.contextualData = contextualData;
            this.__explicitlySet__.add("contextualData");
            return this;
        }

        public CreateTicketDetails build() {
            CreateTicketDetails model = new CreateTicketDetails(this.severity, this.resourceList, this.title, this.description, this.contextualData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTicketDetails model) {
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("resourceList")) {
                this.resourceList(model.getResourceList());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("contextualData")) {
                this.contextualData(model.getContextualData());
            }
            return this;
        }
    }
}

