/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.ServiceCategories;
import com.oracle.bmc.cims.model.ServiceCategory;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IncidentResourceType
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceTypeKey")
    private final String resourceTypeKey;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="serviceCategoryList")
    private final List<ServiceCategory> serviceCategoryList;
    @JsonProperty(value="service")
    private final Map<String, String> service;
    @JsonProperty(value="serviceCategories")
    private final List<ServiceCategories> serviceCategories;

    @Deprecated
    @ConstructorProperties(value={"resourceTypeKey", "name", "label", "description", "serviceCategoryList", "service", "serviceCategories"})
    public IncidentResourceType(String resourceTypeKey, String name, String label, String description, List<ServiceCategory> serviceCategoryList, Map<String, String> service, List<ServiceCategories> serviceCategories) {
        this.resourceTypeKey = resourceTypeKey;
        this.name = name;
        this.label = label;
        this.description = description;
        this.serviceCategoryList = serviceCategoryList;
        this.service = service;
        this.serviceCategories = serviceCategories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceTypeKey() {
        return this.resourceTypeKey;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ServiceCategory> getServiceCategoryList() {
        return this.serviceCategoryList;
    }

    public Map<String, String> getService() {
        return this.service;
    }

    public List<ServiceCategories> getServiceCategories() {
        return this.serviceCategories;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IncidentResourceType(");
        sb.append("super=").append(super.toString());
        sb.append("resourceTypeKey=").append(String.valueOf(this.resourceTypeKey));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", label=").append(String.valueOf(this.label));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", serviceCategoryList=").append(String.valueOf(this.serviceCategoryList));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", serviceCategories=").append(String.valueOf(this.serviceCategories));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncidentResourceType)) {
            return false;
        }
        IncidentResourceType other = (IncidentResourceType)((Object)o);
        return Objects.equals(this.resourceTypeKey, other.resourceTypeKey) && Objects.equals(this.name, other.name) && Objects.equals(this.label, other.label) && Objects.equals(this.description, other.description) && Objects.equals(this.serviceCategoryList, other.serviceCategoryList) && Objects.equals(this.service, other.service) && Objects.equals(this.serviceCategories, other.serviceCategories) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceTypeKey == null ? 43 : this.resourceTypeKey.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.serviceCategoryList == null ? 43 : this.serviceCategoryList.hashCode());
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.serviceCategories == null ? 43 : this.serviceCategories.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceTypeKey")
        private String resourceTypeKey;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="serviceCategoryList")
        private List<ServiceCategory> serviceCategoryList;
        @JsonProperty(value="service")
        private Map<String, String> service;
        @JsonProperty(value="serviceCategories")
        private List<ServiceCategories> serviceCategories;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceTypeKey(String resourceTypeKey) {
            this.resourceTypeKey = resourceTypeKey;
            this.__explicitlySet__.add("resourceTypeKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder serviceCategoryList(List<ServiceCategory> serviceCategoryList) {
            this.serviceCategoryList = serviceCategoryList;
            this.__explicitlySet__.add("serviceCategoryList");
            return this;
        }

        public Builder service(Map<String, String> service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder serviceCategories(List<ServiceCategories> serviceCategories) {
            this.serviceCategories = serviceCategories;
            this.__explicitlySet__.add("serviceCategories");
            return this;
        }

        public IncidentResourceType build() {
            IncidentResourceType model = new IncidentResourceType(this.resourceTypeKey, this.name, this.label, this.description, this.serviceCategoryList, this.service, this.serviceCategories);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IncidentResourceType model) {
            if (model.wasPropertyExplicitlySet("resourceTypeKey")) {
                this.resourceTypeKey(model.getResourceTypeKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("serviceCategoryList")) {
                this.serviceCategoryList(model.getServiceCategoryList());
            }
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("serviceCategories")) {
                this.serviceCategories(model.getServiceCategories());
            }
            return this;
        }
    }
}

