/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIncidentRequest
extends BmcRequest<Void> {
    private String incidentKey;
    private String opcRequestId;
    private String csi;
    private String ocid;
    private String homeregion;
    private String compartmentId;
    private String problemtype;
    private String bearertokentype;
    private String bearertoken;
    private String idtoken;
    private String domainid;

    public String getIncidentKey() {
        return this.incidentKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCsi() {
        return this.csi;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getProblemtype() {
        return this.problemtype;
    }

    public String getBearertokentype() {
        return this.bearertokentype;
    }

    public String getBearertoken() {
        return this.bearertoken;
    }

    public String getIdtoken() {
        return this.idtoken;
    }

    public String getDomainid() {
        return this.domainid;
    }

    public Builder toBuilder() {
        return new Builder().incidentKey(this.incidentKey).opcRequestId(this.opcRequestId).csi(this.csi).ocid(this.ocid).homeregion(this.homeregion).compartmentId(this.compartmentId).problemtype(this.problemtype).bearertokentype(this.bearertokentype).bearertoken(this.bearertoken).idtoken(this.idtoken).domainid(this.domainid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",incidentKey=").append(String.valueOf(this.incidentKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",problemtype=").append(String.valueOf(this.problemtype));
        sb.append(",bearertokentype=").append(String.valueOf(this.bearertokentype));
        sb.append(",bearertoken=").append(String.valueOf(this.bearertoken));
        sb.append(",idtoken=").append(String.valueOf(this.idtoken));
        sb.append(",domainid=").append(String.valueOf(this.domainid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIncidentRequest)) {
            return false;
        }
        GetIncidentRequest other = (GetIncidentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.incidentKey, other.incidentKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.csi, other.csi) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.homeregion, other.homeregion) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.problemtype, other.problemtype) && Objects.equals(this.bearertokentype, other.bearertokentype) && Objects.equals(this.bearertoken, other.bearertoken) && Objects.equals(this.idtoken, other.idtoken) && Objects.equals(this.domainid, other.domainid);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.incidentKey == null ? 43 : this.incidentKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.problemtype == null ? 43 : this.problemtype.hashCode());
        result = result * 59 + (this.bearertokentype == null ? 43 : this.bearertokentype.hashCode());
        result = result * 59 + (this.bearertoken == null ? 43 : this.bearertoken.hashCode());
        result = result * 59 + (this.idtoken == null ? 43 : this.idtoken.hashCode());
        result = result * 59 + (this.domainid == null ? 43 : this.domainid.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIncidentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String incidentKey = null;
        private String opcRequestId = null;
        private String csi = null;
        private String ocid = null;
        private String homeregion = null;
        private String compartmentId = null;
        private String problemtype = null;
        private String bearertokentype = null;
        private String bearertoken = null;
        private String idtoken = null;
        private String domainid = null;

        public Builder incidentKey(String incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder problemtype(String problemtype) {
            this.problemtype = problemtype;
            return this;
        }

        public Builder bearertokentype(String bearertokentype) {
            this.bearertokentype = bearertokentype;
            return this;
        }

        public Builder bearertoken(String bearertoken) {
            this.bearertoken = bearertoken;
            return this;
        }

        public Builder idtoken(String idtoken) {
            this.idtoken = idtoken;
            return this;
        }

        public Builder domainid(String domainid) {
            this.domainid = domainid;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIncidentRequest o) {
            this.incidentKey(o.getIncidentKey());
            this.opcRequestId(o.getOpcRequestId());
            this.csi(o.getCsi());
            this.ocid(o.getOcid());
            this.homeregion(o.getHomeregion());
            this.compartmentId(o.getCompartmentId());
            this.problemtype(o.getProblemtype());
            this.bearertokentype(o.getBearertokentype());
            this.bearertoken(o.getBearertoken());
            this.idtoken(o.getIdtoken());
            this.domainid(o.getDomainid());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIncidentRequest build() {
            GetIncidentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIncidentRequest buildWithoutInvocationCallback() {
            GetIncidentRequest request = new GetIncidentRequest();
            request.incidentKey = this.incidentKey;
            request.opcRequestId = this.opcRequestId;
            request.csi = this.csi;
            request.ocid = this.ocid;
            request.homeregion = this.homeregion;
            request.compartmentId = this.compartmentId;
            request.problemtype = this.problemtype;
            request.bearertokentype = this.bearertokentype;
            request.bearertoken = this.bearertoken;
            request.idtoken = this.idtoken;
            request.domainid = this.domainid;
            return request;
        }
    }
}

