/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.cims.model.LifecycleState;
import com.oracle.bmc.cims.model.SortBy;
import com.oracle.bmc.cims.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListIncidentsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String csi;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private LifecycleState lifecycleState;
    private String page;
    private String opcRequestId;
    private String ocid;
    private String homeregion;
    private String problemType;
    private String bearertokentype;
    private String bearertoken;
    private String idtoken;
    private String domainid;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCsi() {
        return this.csi;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public String getBearertokentype() {
        return this.bearertokentype;
    }

    public String getBearertoken() {
        return this.bearertoken;
    }

    public String getIdtoken() {
        return this.idtoken;
    }

    public String getDomainid() {
        return this.domainid;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).csi(this.csi).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).page(this.page).opcRequestId(this.opcRequestId).ocid(this.ocid).homeregion(this.homeregion).problemType(this.problemType).bearertokentype(this.bearertokentype).bearertoken(this.bearertoken).idtoken(this.idtoken).domainid(this.domainid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(",problemType=").append(String.valueOf(this.problemType));
        sb.append(",bearertokentype=").append(String.valueOf(this.bearertokentype));
        sb.append(",bearertoken=").append(String.valueOf(this.bearertoken));
        sb.append(",idtoken=").append(String.valueOf(this.idtoken));
        sb.append(",domainid=").append(String.valueOf(this.domainid));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIncidentsRequest)) {
            return false;
        }
        ListIncidentsRequest other = (ListIncidentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.csi, other.csi) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.homeregion, other.homeregion) && Objects.equals(this.problemType, other.problemType) && Objects.equals(this.bearertokentype, other.bearertokentype) && Objects.equals(this.bearertoken, other.bearertoken) && Objects.equals(this.idtoken, other.idtoken) && Objects.equals(this.domainid, other.domainid);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        result = result * 59 + (this.bearertokentype == null ? 43 : this.bearertokentype.hashCode());
        result = result * 59 + (this.bearertoken == null ? 43 : this.bearertoken.hashCode());
        result = result * 59 + (this.idtoken == null ? 43 : this.idtoken.hashCode());
        result = result * 59 + (this.domainid == null ? 43 : this.domainid.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIncidentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String csi = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private LifecycleState lifecycleState = null;
        private String page = null;
        private String opcRequestId = null;
        private String ocid = null;
        private String homeregion = null;
        private String problemType = null;
        private String bearertokentype = null;
        private String bearertoken = null;
        private String idtoken = null;
        private String domainid = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder bearertokentype(String bearertokentype) {
            this.bearertokentype = bearertokentype;
            return this;
        }

        public Builder bearertoken(String bearertoken) {
            this.bearertoken = bearertoken;
            return this;
        }

        public Builder idtoken(String idtoken) {
            this.idtoken = idtoken;
            return this;
        }

        public Builder domainid(String domainid) {
            this.domainid = domainid;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIncidentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.csi(o.getCsi());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.ocid(o.getOcid());
            this.homeregion(o.getHomeregion());
            this.problemType(o.getProblemType());
            this.bearertokentype(o.getBearertokentype());
            this.bearertoken(o.getBearertoken());
            this.idtoken(o.getIdtoken());
            this.domainid(o.getDomainid());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIncidentsRequest build() {
            ListIncidentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIncidentsRequest buildWithoutInvocationCallback() {
            ListIncidentsRequest request = new ListIncidentsRequest();
            request.compartmentId = this.compartmentId;
            request.csi = this.csi;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.ocid = this.ocid;
            request.homeregion = this.homeregion;
            request.problemType = this.problemType;
            request.bearertokentype = this.bearertokentype;
            request.bearertoken = this.bearertoken;
            request.idtoken = this.idtoken;
            request.domainid = this.domainid;
            return request;
        }
    }
}

