/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.responses;

import com.oracle.bmc.cims.model.IncidentSummary;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListIncidentsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcPrevPage;
    private String asOfTime;
    private List<IncidentSummary> items;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public String getAsOfTime() {
        return this.asOfTime;
    }

    public List<IncidentSummary> getItems() {
        return this.items;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "opcPrevPage", "asOfTime", "items"})
    private ListIncidentsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, String opcPrevPage, String asOfTime, List<IncidentSummary> items) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.asOfTime = asOfTime;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcPrevPage=").append(String.valueOf(this.opcPrevPage));
        sb.append(",asOfTime=").append(String.valueOf(this.asOfTime));
        sb.append(",items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIncidentsResponse)) {
            return false;
        }
        ListIncidentsResponse other = (ListIncidentsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcPrevPage, other.opcPrevPage) && Objects.equals(this.asOfTime, other.asOfTime) && Objects.equals(this.items, other.items);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcPrevPage == null ? 43 : this.opcPrevPage.hashCode());
        result = result * 59 + (this.asOfTime == null ? 43 : this.asOfTime.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListIncidentsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private String opcPrevPage;
        private String asOfTime;
        private List<IncidentSummary> items;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder asOfTime(String asOfTime) {
            this.asOfTime = asOfTime;
            return this;
        }

        public Builder items(List<IncidentSummary> items) {
            this.items = items;
            return this;
        }

        public Builder copy(ListIncidentsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.asOfTime(o.getAsOfTime());
            this.items(o.getItems());
            return this;
        }

        public ListIncidentsResponse build() {
            return new ListIncidentsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.opcPrevPage, this.asOfTime, this.items);
        }
    }
}

