/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.Discovery;
import com.oracle.bmc.cloudbridge.DiscoveryPaginators;
import com.oracle.bmc.cloudbridge.DiscoveryWaiters;
import com.oracle.bmc.cloudbridge.model.AssetSource;
import com.oracle.bmc.cloudbridge.model.AssetSourceCollection;
import com.oracle.bmc.cloudbridge.model.AssetSourceConnectionCollection;
import com.oracle.bmc.cloudbridge.model.DiscoverySchedule;
import com.oracle.bmc.cloudbridge.model.DiscoveryScheduleCollection;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetSourceCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeDiscoveryScheduleCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.CreateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.GetDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourceConnectionsRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourcesRequest;
import com.oracle.bmc.cloudbridge.requests.ListDiscoverySchedulesRequest;
import com.oracle.bmc.cloudbridge.requests.RefreshAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetSourceCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeDiscoveryScheduleCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.CreateDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.GetDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourceConnectionsResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourcesResponse;
import com.oracle.bmc.cloudbridge.responses.ListDiscoverySchedulesResponse;
import com.oracle.bmc.cloudbridge.responses.RefreshAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateDiscoveryScheduleResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryClient
extends BaseSyncClient
implements Discovery {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DISCOVERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryClient.class);
    private final DiscoveryWaiters waiters;
    private final DiscoveryPaginators paginators;

    DiscoveryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Discovery-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DiscoveryWaiters(executorService, this);
        this.paginators = new DiscoveryPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeAssetSourceCompartmentResponse changeAssetSourceCompartment(ChangeAssetSourceCompartmentRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetSourceCompartmentDetails(), "changeAssetSourceCompartmentDetails is required");
        return (ChangeAssetSourceCompartmentResponse)this.clientCall(request, ChangeAssetSourceCompartmentResponse::builder).logger(LOG, "changeAssetSourceCompartment").serviceDetails("Discovery", "ChangeAssetSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ChangeAssetSourceCompartment").method(Method.POST).requestBuilder(ChangeAssetSourceCompartmentRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeAssetSourceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDiscoveryScheduleCompartmentResponse changeDiscoveryScheduleCompartment(ChangeDiscoveryScheduleCompartmentRequest request) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDiscoveryScheduleCompartmentDetails(), "changeDiscoveryScheduleCompartmentDetails is required");
        return (ChangeDiscoveryScheduleCompartmentResponse)this.clientCall(request, ChangeDiscoveryScheduleCompartmentResponse::builder).logger(LOG, "changeDiscoveryScheduleCompartment").serviceDetails("Discovery", "ChangeDiscoveryScheduleCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/ChangeDiscoveryScheduleCompartment").method(Method.POST).requestBuilder(ChangeDiscoveryScheduleCompartmentRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeDiscoveryScheduleCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateAssetSourceResponse createAssetSource(CreateAssetSourceRequest request) {
        Objects.requireNonNull(request.getCreateAssetSourceDetails(), "createAssetSourceDetails is required");
        return (CreateAssetSourceResponse)this.clientCall(request, CreateAssetSourceResponse::builder).logger(LOG, "createAssetSource").serviceDetails("Discovery", "CreateAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/CreateAssetSource").method(Method.POST).requestBuilder(CreateAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(AssetSource.class, CreateAssetSourceResponse.Builder::assetSource).handleResponseHeaderString("etag", CreateAssetSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAssetSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreateAssetSourceResponse.Builder::location).callSync();
    }

    @Override
    public CreateDiscoveryScheduleResponse createDiscoverySchedule(CreateDiscoveryScheduleRequest request) {
        Objects.requireNonNull(request.getCreateDiscoveryScheduleDetails(), "createDiscoveryScheduleDetails is required");
        return (CreateDiscoveryScheduleResponse)this.clientCall(request, CreateDiscoveryScheduleResponse::builder).logger(LOG, "createDiscoverySchedule").serviceDetails("Discovery", "CreateDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/CreateDiscoverySchedule").method(Method.POST).requestBuilder(CreateDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DiscoverySchedule.class, CreateDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", CreateDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDiscoveryScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteAssetSourceResponse deleteAssetSource(DeleteAssetSourceRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return (DeleteAssetSourceResponse)this.clientCall(request, DeleteAssetSourceResponse::builder).logger(LOG, "deleteAssetSource").serviceDetails("Discovery", "DeleteAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/DeleteAssetSource").method(Method.DELETE).requestBuilder(DeleteAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAssetSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteDiscoveryScheduleResponse deleteDiscoverySchedule(DeleteDiscoveryScheduleRequest request) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return (DeleteDiscoveryScheduleResponse)this.clientCall(request, DeleteDiscoveryScheduleResponse::builder).logger(LOG, "deleteDiscoverySchedule").serviceDetails("Discovery", "DeleteDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/DeleteDiscoverySchedule").method(Method.DELETE).requestBuilder(DeleteDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteDiscoveryScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetAssetSourceResponse getAssetSource(GetAssetSourceRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return (GetAssetSourceResponse)this.clientCall(request, GetAssetSourceResponse::builder).logger(LOG, "getAssetSource").serviceDetails("Discovery", "GetAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/GetAssetSource").method(Method.GET).requestBuilder(GetAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AssetSource.class, GetAssetSourceResponse.Builder::assetSource).handleResponseHeaderString("etag", GetAssetSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAssetSourceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDiscoveryScheduleResponse getDiscoverySchedule(GetDiscoveryScheduleRequest request) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return (GetDiscoveryScheduleResponse)this.clientCall(request, GetDiscoveryScheduleResponse::builder).logger(LOG, "getDiscoverySchedule").serviceDetails("Discovery", "GetDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/GetDiscoverySchedule").method(Method.GET).requestBuilder(GetDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DiscoverySchedule.class, GetDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", GetDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDiscoveryScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListAssetSourceConnectionsResponse listAssetSourceConnections(ListAssetSourceConnectionsRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return (ListAssetSourceConnectionsResponse)this.clientCall(request, ListAssetSourceConnectionsResponse::builder).logger(LOG, "listAssetSourceConnections").serviceDetails("Discovery", "ListAssetSourceConnections", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ListAssetSourceConnections").method(Method.POST).requestBuilder(ListAssetSourceConnectionsRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("listConnections").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AssetSourceConnectionCollection.class, ListAssetSourceConnectionsResponse.Builder::assetSourceConnectionCollection).handleResponseHeaderString("opc-request-id", ListAssetSourceConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetSourceConnectionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAssetSourcesResponse listAssetSources(ListAssetSourcesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListAssetSourcesResponse)this.clientCall(request, ListAssetSourcesResponse::builder).logger(LOG, "listAssetSources").serviceDetails("Discovery", "ListAssetSources", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ListAssetSources").method(Method.GET).requestBuilder(ListAssetSourcesRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendQueryParam("assetSourceId", (Object)request.getAssetSourceId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AssetSourceCollection.class, ListAssetSourcesResponse.Builder::assetSourceCollection).handleResponseHeaderString("opc-request-id", ListAssetSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetSourcesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDiscoverySchedulesResponse listDiscoverySchedules(ListDiscoverySchedulesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDiscoverySchedulesResponse)this.clientCall(request, ListDiscoverySchedulesResponse::builder).logger(LOG, "listDiscoverySchedules").serviceDetails("Discovery", "ListDiscoverySchedules", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/ListDiscoverySchedules").method(Method.GET).requestBuilder(ListDiscoverySchedulesRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendQueryParam("discoveryScheduleId", (Object)request.getDiscoveryScheduleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DiscoveryScheduleCollection.class, ListDiscoverySchedulesResponse.Builder::discoveryScheduleCollection).handleResponseHeaderString("opc-request-id", ListDiscoverySchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDiscoverySchedulesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RefreshAssetSourceResponse refreshAssetSource(RefreshAssetSourceRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return (RefreshAssetSourceResponse)this.clientCall(request, RefreshAssetSourceResponse::builder).logger(LOG, "refreshAssetSource").serviceDetails("Discovery", "RefreshAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/RefreshAssetSource").method(Method.POST).requestBuilder(RefreshAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", RefreshAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RefreshAssetSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateAssetSourceResponse updateAssetSource(UpdateAssetSourceRequest request) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAssetSourceDetails(), "updateAssetSourceDetails is required");
        return (UpdateAssetSourceResponse)this.clientCall(request, UpdateAssetSourceResponse::builder).logger(LOG, "updateAssetSource").serviceDetails("Discovery", "UpdateAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/UpdateAssetSource").method(Method.PUT).requestBuilder(UpdateAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAssetSourceResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateDiscoveryScheduleResponse updateDiscoverySchedule(UpdateDiscoveryScheduleRequest request) {
        Objects.requireNonNull(request.getUpdateDiscoveryScheduleDetails(), "updateDiscoveryScheduleDetails is required");
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return (UpdateDiscoveryScheduleResponse)this.clientCall(request, UpdateDiscoveryScheduleResponse::builder).logger(LOG, "updateDiscoverySchedule").serviceDetails("Discovery", "UpdateDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/UpdateDiscoverySchedule").method(Method.PUT).requestBuilder(UpdateDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DiscoverySchedule.class, UpdateDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", UpdateDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDiscoveryScheduleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DiscoveryWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DiscoveryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DiscoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DiscoveryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DiscoveryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DiscoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DiscoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DiscoveryClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "cloudbridge";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"cloudbridge");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DiscoveryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DiscoveryClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

