/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.OcbAgentSvcAsync;
import com.oracle.bmc.cloudbridge.model.Agent;
import com.oracle.bmc.cloudbridge.model.AgentCollection;
import com.oracle.bmc.cloudbridge.model.AgentDependency;
import com.oracle.bmc.cloudbridge.model.AgentDependencyCollection;
import com.oracle.bmc.cloudbridge.model.ApplianceImageCollection;
import com.oracle.bmc.cloudbridge.model.Environment;
import com.oracle.bmc.cloudbridge.model.EnvironmentCollection;
import com.oracle.bmc.cloudbridge.model.Plugin;
import com.oracle.bmc.cloudbridge.requests.AddAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentDependencyCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeEnvironmentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentRequest;
import com.oracle.bmc.cloudbridge.requests.GetEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetPluginRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentDependenciesRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentsRequest;
import com.oracle.bmc.cloudbridge.requests.ListApplianceImagesRequest;
import com.oracle.bmc.cloudbridge.requests.ListEnvironmentsRequest;
import com.oracle.bmc.cloudbridge.requests.RemoveAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdatePluginRequest;
import com.oracle.bmc.cloudbridge.responses.AddAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentDependencyCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeEnvironmentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentResponse;
import com.oracle.bmc.cloudbridge.responses.GetEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetPluginResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentDependenciesResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentsResponse;
import com.oracle.bmc.cloudbridge.responses.ListApplianceImagesResponse;
import com.oracle.bmc.cloudbridge.responses.ListEnvironmentsResponse;
import com.oracle.bmc.cloudbridge.responses.RemoveAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdatePluginResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcbAgentSvcAsyncClient
extends BaseAsyncClient
implements OcbAgentSvcAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCBAGENTSVC").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OcbAgentSvcAsyncClient.class);

    OcbAgentSvcAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddAgentDependencyResponse> addAgentDependency(AddAgentDependencyRequest request, AsyncHandler<AddAgentDependencyRequest, AddAgentDependencyResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddAgentDependencyDetails(), "addAgentDependencyDetails is required");
        return this.clientCall(request, AddAgentDependencyResponse::builder).logger(LOG, "addAgentDependency").serviceDetails("OcbAgentSvc", "AddAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/AddAgentDependency").method(Method.POST).requestBuilder(AddAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("addAgentDependency").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, AddAgentDependencyResponse.Builder::environment).handleResponseHeaderString("etag", AddAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddAgentDependencyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAgentCompartmentResponse> changeAgentCompartment(ChangeAgentCompartmentRequest request, AsyncHandler<ChangeAgentCompartmentRequest, ChangeAgentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentCompartmentDetails(), "changeAgentCompartmentDetails is required");
        return this.clientCall(request, ChangeAgentCompartmentResponse::builder).logger(LOG, "changeAgentCompartment").serviceDetails("OcbAgentSvc", "ChangeAgentCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/ChangeAgentCompartment").method(Method.POST).requestBuilder(ChangeAgentCompartmentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeAgentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeAgentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeAgentDependencyCompartmentResponse> changeAgentDependencyCompartment(ChangeAgentDependencyCompartmentRequest request, AsyncHandler<ChangeAgentDependencyCompartmentRequest, ChangeAgentDependencyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAgentDependencyCompartmentDetails(), "changeAgentDependencyCompartmentDetails is required");
        return this.clientCall(request, ChangeAgentDependencyCompartmentResponse::builder).logger(LOG, "changeAgentDependencyCompartment").serviceDetails("OcbAgentSvc", "ChangeAgentDependencyCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/ChangeAgentDependencyCompartment").method(Method.POST).requestBuilder(ChangeAgentDependencyCompartmentRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAgentDependencyCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeEnvironmentCompartmentResponse> changeEnvironmentCompartment(ChangeEnvironmentCompartmentRequest request, AsyncHandler<ChangeEnvironmentCompartmentRequest, ChangeEnvironmentCompartmentResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeEnvironmentCompartmentDetails(), "changeEnvironmentCompartmentDetails is required");
        return this.clientCall(request, ChangeEnvironmentCompartmentResponse::builder).logger(LOG, "changeEnvironmentCompartment").serviceDetails("OcbAgentSvc", "ChangeEnvironmentCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/ChangeEnvironmentCompartment").method(Method.POST).requestBuilder(ChangeEnvironmentCompartmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeEnvironmentCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeEnvironmentCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAgentResponse> createAgent(CreateAgentRequest request, AsyncHandler<CreateAgentRequest, CreateAgentResponse> handler) {
        Objects.requireNonNull(request.getCreateAgentDetails(), "createAgentDetails is required");
        return this.clientCall(request, CreateAgentResponse::builder).logger(LOG, "createAgent").serviceDetails("OcbAgentSvc", "CreateAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/CreateAgent").method(Method.POST).requestBuilder(CreateAgentRequest::builder).basePath("/20220509").appendPathParam("agents").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Agent.class, CreateAgentResponse.Builder::agent).handleResponseHeaderString("etag", CreateAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAgentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAgentDependencyResponse> createAgentDependency(CreateAgentDependencyRequest request, AsyncHandler<CreateAgentDependencyRequest, CreateAgentDependencyResponse> handler) {
        Objects.requireNonNull(request.getCreateAgentDependencyDetails(), "createAgentDependencyDetails is required");
        return this.clientCall(request, CreateAgentDependencyResponse::builder).logger(LOG, "createAgentDependency").serviceDetails("OcbAgentSvc", "CreateAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/CreateAgentDependency").method(Method.POST).requestBuilder(CreateAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AgentDependency.class, CreateAgentDependencyResponse.Builder::agentDependency).handleResponseHeaderString("etag", CreateAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAgentDependencyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAgentDependencyResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest request, AsyncHandler<CreateEnvironmentRequest, CreateEnvironmentResponse> handler) {
        Objects.requireNonNull(request.getCreateEnvironmentDetails(), "createEnvironmentDetails is required");
        return this.clientCall(request, CreateEnvironmentResponse::builder).logger(LOG, "createEnvironment").serviceDetails("OcbAgentSvc", "CreateEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/CreateEnvironment").method(Method.POST).requestBuilder(CreateEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, CreateEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", CreateEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAgentResponse> deleteAgent(DeleteAgentRequest request, AsyncHandler<DeleteAgentRequest, DeleteAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAgentResponse::builder).logger(LOG, "deleteAgent").serviceDetails("OcbAgentSvc", "DeleteAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/DeleteAgent").method(Method.DELETE).requestBuilder(DeleteAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteAgentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAgentDependencyResponse> deleteAgentDependency(DeleteAgentDependencyRequest request, AsyncHandler<DeleteAgentDependencyRequest, DeleteAgentDependencyResponse> handler) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAgentDependencyResponse::builder).logger(LOG, "deleteAgentDependency").serviceDetails("OcbAgentSvc", "DeleteAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/DeleteAgentDependency").method(Method.DELETE).requestBuilder(DeleteAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAgentDependencyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest request, AsyncHandler<DeleteEnvironmentRequest, DeleteEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteEnvironmentResponse::builder).logger(LOG, "deleteEnvironment").serviceDetails("OcbAgentSvc", "DeleteEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/DeleteEnvironment").method(Method.DELETE).requestBuilder(DeleteEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAgentResponse> getAgent(GetAgentRequest request, AsyncHandler<GetAgentRequest, GetAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAgentResponse::builder).logger(LOG, "getAgent").serviceDetails("OcbAgentSvc", "GetAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/GetAgent").method(Method.GET).requestBuilder(GetAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Agent.class, GetAgentResponse.Builder::agent).handleResponseHeaderString("etag", GetAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAgentDependencyResponse> getAgentDependency(GetAgentDependencyRequest request, AsyncHandler<GetAgentDependencyRequest, GetAgentDependencyResponse> handler) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAgentDependencyResponse::builder).logger(LOG, "getAgentDependency").serviceDetails("OcbAgentSvc", "GetAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/GetAgentDependency").method(Method.GET).requestBuilder(GetAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentDependency.class, GetAgentDependencyResponse.Builder::agentDependency).handleResponseHeaderString("etag", GetAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAgentDependencyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest request, AsyncHandler<GetEnvironmentRequest, GetEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetEnvironmentResponse::builder).logger(LOG, "getEnvironment").serviceDetails("OcbAgentSvc", "GetEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/GetEnvironment").method(Method.GET).requestBuilder(GetEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Environment.class, GetEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", GetEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPluginResponse> getPlugin(GetPluginRequest request, AsyncHandler<GetPluginRequest, GetPluginResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPluginName(), (String)"pluginName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetPluginResponse::builder).logger(LOG, "getPlugin").serviceDetails("OcbAgentSvc", "GetPlugin", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Plugin/GetPlugin").method(Method.GET).requestBuilder(GetPluginRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("plugins").appendPathParam(request.getPluginName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Plugin.class, GetPluginResponse.Builder::plugin).handleResponseHeaderString("etag", GetPluginResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPluginResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAgentDependenciesResponse> listAgentDependencies(ListAgentDependenciesRequest request, AsyncHandler<ListAgentDependenciesRequest, ListAgentDependenciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAgentDependenciesResponse::builder).logger(LOG, "listAgentDependencies").serviceDetails("OcbAgentSvc", "ListAgentDependencies", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependencyCollection/ListAgentDependencies").method(Method.GET).requestBuilder(ListAgentDependenciesRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("agentId", (Object)request.getAgentId()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentDependencyCollection.class, ListAgentDependenciesResponse.Builder::agentDependencyCollection).handleResponseHeaderString("opc-request-id", ListAgentDependenciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentDependenciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAgentsResponse> listAgents(ListAgentsRequest request, AsyncHandler<ListAgentsRequest, ListAgentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAgentsResponse::builder).logger(LOG, "listAgents").serviceDetails("OcbAgentSvc", "ListAgents", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentCollection/ListAgents").method(Method.GET).requestBuilder(ListAgentsRequest::builder).basePath("/20220509").appendPathParam("agents").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("agentId", (Object)request.getAgentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AgentCollection.class, ListAgentsResponse.Builder::agentCollection).handleResponseHeaderString("opc-request-id", ListAgentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListApplianceImagesResponse> listApplianceImages(ListApplianceImagesRequest request, AsyncHandler<ListApplianceImagesRequest, ListApplianceImagesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListApplianceImagesResponse::builder).logger(LOG, "listApplianceImages").serviceDetails("OcbAgentSvc", "ListApplianceImages", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/ApplianceImageCollection/ListApplianceImages").method(Method.GET).requestBuilder(ListApplianceImagesRequest::builder).basePath("/20220509").appendPathParam("applianceImages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ApplianceImageCollection.class, ListApplianceImagesResponse.Builder::applianceImageCollection).handleResponseHeaderString("opc-request-id", ListApplianceImagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplianceImagesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest request, AsyncHandler<ListEnvironmentsRequest, ListEnvironmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListEnvironmentsResponse::builder).logger(LOG, "listEnvironments").serviceDetails("OcbAgentSvc", "ListEnvironments", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/EnvironmentCollection/ListEnvironments").method(Method.GET).requestBuilder(ListEnvironmentsRequest::builder).basePath("/20220509").appendPathParam("environments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("environmentId", (Object)request.getEnvironmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EnvironmentCollection.class, ListEnvironmentsResponse.Builder::environmentCollection).handleResponseHeaderString("opc-request-id", ListEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEnvironmentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RemoveAgentDependencyResponse> removeAgentDependency(RemoveAgentDependencyRequest request, AsyncHandler<RemoveAgentDependencyRequest, RemoveAgentDependencyResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveAgentDependencyDetails(), "removeAgentDependencyDetails is required");
        return this.clientCall(request, RemoveAgentDependencyResponse::builder).logger(LOG, "removeAgentDependency").serviceDetails("OcbAgentSvc", "RemoveAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/RemoveAgentDependency").method(Method.POST).requestBuilder(RemoveAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).appendPathParam("actions").appendPathParam("removeAgentDependency").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Environment.class, RemoveAgentDependencyResponse.Builder::environment).handleResponseHeaderString("etag", RemoveAgentDependencyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveAgentDependencyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAgentResponse> updateAgent(UpdateAgentRequest request, AsyncHandler<UpdateAgentRequest, UpdateAgentResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDetails(), "updateAgentDetails is required");
        return this.clientCall(request, UpdateAgentResponse::builder).logger(LOG, "updateAgent").serviceDetails("OcbAgentSvc", "UpdateAgent", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Agent/UpdateAgent").method(Method.PUT).requestBuilder(UpdateAgentRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Agent.class, UpdateAgentResponse.Builder::agent).handleResponseHeaderString("etag", UpdateAgentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAgentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAgentDependencyResponse> updateAgentDependency(UpdateAgentDependencyRequest request, AsyncHandler<UpdateAgentDependencyRequest, UpdateAgentDependencyResponse> handler) {
        Validate.notBlank((String)request.getAgentDependencyId(), (String)"agentDependencyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAgentDependencyDetails(), "updateAgentDependencyDetails is required");
        return this.clientCall(request, UpdateAgentDependencyResponse::builder).logger(LOG, "updateAgentDependency").serviceDetails("OcbAgentSvc", "UpdateAgentDependency", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AgentDependency/UpdateAgentDependency").method(Method.PUT).requestBuilder(UpdateAgentDependencyRequest::builder).basePath("/20220509").appendPathParam("agentDependencies").appendPathParam(request.getAgentDependencyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAgentDependencyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAgentDependencyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest request, AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResponse> handler) {
        Validate.notBlank((String)request.getEnvironmentId(), (String)"environmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEnvironmentDetails(), "updateEnvironmentDetails is required");
        return this.clientCall(request, UpdateEnvironmentResponse::builder).logger(LOG, "updateEnvironment").serviceDetails("OcbAgentSvc", "UpdateEnvironment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Environment/UpdateEnvironment").method(Method.PUT).requestBuilder(UpdateEnvironmentRequest::builder).basePath("/20220509").appendPathParam("environments").appendPathParam(request.getEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Environment.class, UpdateEnvironmentResponse.Builder::environment).handleResponseHeaderString("etag", UpdateEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEnvironmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePluginResponse> updatePlugin(UpdatePluginRequest request, AsyncHandler<UpdatePluginRequest, UpdatePluginResponse> handler) {
        Validate.notBlank((String)request.getAgentId(), (String)"agentId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPluginName(), (String)"pluginName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePluginDetails(), "updatePluginDetails is required");
        return this.clientCall(request, UpdatePluginResponse::builder).logger(LOG, "updatePlugin").serviceDetails("OcbAgentSvc", "UpdatePlugin", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/Plugin/UpdatePlugin").method(Method.PUT).requestBuilder(UpdatePluginRequest::builder).basePath("/20220509").appendPathParam("agents").appendPathParam(request.getAgentId()).appendPathParam("plugins").appendPathParam(request.getPluginName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Plugin.class, UpdatePluginResponse.Builder::plugin).handleResponseHeaderString("etag", UpdatePluginResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePluginResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OcbAgentSvcAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OcbAgentSvcAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OcbAgentSvcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OcbAgentSvcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OcbAgentSvcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OcbAgentSvcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OcbAgentSvcAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OcbAgentSvcAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OcbAgentSvcAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "cloudbridge";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"cloudbridge");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OcbAgentSvcAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OcbAgentSvcAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

