/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudbridge.model.UpdatePluginDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePluginRequest
extends BmcRequest<UpdatePluginDetails> {
    private String agentId;
    private String pluginName;
    private UpdatePluginDetails updatePluginDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getAgentId() {
        return this.agentId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public UpdatePluginDetails getUpdatePluginDetails() {
        return this.updatePluginDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePluginDetails getBody$() {
        return this.updatePluginDetails;
    }

    public Builder toBuilder() {
        return new Builder().agentId(this.agentId).pluginName(this.pluginName).updatePluginDetails(this.updatePluginDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",agentId=").append(String.valueOf(this.agentId));
        sb.append(",pluginName=").append(String.valueOf(this.pluginName));
        sb.append(",updatePluginDetails=").append(String.valueOf((Object)this.updatePluginDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePluginRequest)) {
            return false;
        }
        UpdatePluginRequest other = (UpdatePluginRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.pluginName, other.pluginName) && Objects.equals((Object)this.updatePluginDetails, (Object)other.updatePluginDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.pluginName == null ? 43 : this.pluginName.hashCode());
        result = result * 59 + (this.updatePluginDetails == null ? 43 : this.updatePluginDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePluginRequest, UpdatePluginDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String agentId = null;
        private String pluginName = null;
        private UpdatePluginDetails updatePluginDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder updatePluginDetails(UpdatePluginDetails updatePluginDetails) {
            this.updatePluginDetails = updatePluginDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePluginRequest o) {
            this.agentId(o.getAgentId());
            this.pluginName(o.getPluginName());
            this.updatePluginDetails(o.getUpdatePluginDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePluginRequest build() {
            UpdatePluginRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePluginDetails body) {
            this.updatePluginDetails(body);
            return this;
        }

        public UpdatePluginRequest buildWithoutInvocationCallback() {
            UpdatePluginRequest request = new UpdatePluginRequest();
            request.agentId = this.agentId;
            request.pluginName = this.pluginName;
            request.updatePluginDetails = this.updatePluginDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

