/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.Inventory;
import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.Inventory;
import com.oracle.bmc.cloudbridge.requests.GetAssetRequest;
import com.oracle.bmc.cloudbridge.requests.GetInventoryRequest;
import com.oracle.bmc.cloudbridge.responses.GetAssetResponse;
import com.oracle.bmc.cloudbridge.responses.GetInventoryResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class InventoryWaiters {
    private final ExecutorService executorService;
    private final Inventory client;

    public InventoryWaiters(ExecutorService executorService, Inventory client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAssetRequest, GetAssetResponse> forAsset(GetAssetRequest request, Asset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAsset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAssetRequest, GetAssetResponse> forAsset(GetAssetRequest request, Asset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAssetRequest, GetAssetResponse> forAsset(GetAssetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Asset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAsset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAssetRequest, GetAssetResponse> forAsset(BmcGenericWaiter waiter, GetAssetRequest request, Asset.LifecycleState ... targetStates) {
        final HashSet<Asset.LifecycleState> targetStatesSet = new HashSet<Asset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAssetRequest, GetAssetResponse>(){

            @Override
            public GetAssetResponse apply(GetAssetRequest request) {
                return InventoryWaiters.this.client.getAsset(request);
            }
        }, (Predicate)new Predicate<GetAssetResponse>(){

            @Override
            public boolean test(GetAssetResponse response) {
                return targetStatesSet.contains((Object)response.getAsset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Asset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetInventoryRequest, GetInventoryResponse> forInventory(GetInventoryRequest request, Inventory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInventory(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInventoryRequest, GetInventoryResponse> forInventory(GetInventoryRequest request, Inventory.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInventory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInventoryRequest, GetInventoryResponse> forInventory(GetInventoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Inventory.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInventory(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInventoryRequest, GetInventoryResponse> forInventory(BmcGenericWaiter waiter, GetInventoryRequest request, Inventory.LifecycleState ... targetStates) {
        final HashSet<Inventory.LifecycleState> targetStatesSet = new HashSet<Inventory.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInventoryRequest, GetInventoryResponse>(){

            @Override
            public GetInventoryResponse apply(GetInventoryRequest request) {
                return InventoryWaiters.this.client.getInventory(request);
            }
        }, (Predicate)new Predicate<GetInventoryResponse>(){

            @Override
            public boolean test(GetInventoryResponse response) {
                return targetStatesSet.contains((Object)response.getInventory().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Inventory.LifecycleState.Deleted)), (Object)request);
    }
}

