/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.OcbAgentSvc;
import com.oracle.bmc.cloudbridge.model.Agent;
import com.oracle.bmc.cloudbridge.model.AgentDependency;
import com.oracle.bmc.cloudbridge.model.Environment;
import com.oracle.bmc.cloudbridge.model.Plugin;
import com.oracle.bmc.cloudbridge.requests.GetAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentRequest;
import com.oracle.bmc.cloudbridge.requests.GetEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetPluginRequest;
import com.oracle.bmc.cloudbridge.responses.GetAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentResponse;
import com.oracle.bmc.cloudbridge.responses.GetEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetPluginResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OcbAgentSvcWaiters {
    private final ExecutorService executorService;
    private final OcbAgentSvc client;

    public OcbAgentSvcWaiters(ExecutorService executorService, OcbAgentSvc client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, Agent.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAgent(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, Agent.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAgent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAgentRequest, GetAgentResponse> forAgent(GetAgentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Agent.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAgent(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAgentRequest, GetAgentResponse> forAgent(BmcGenericWaiter waiter, GetAgentRequest request, Agent.LifecycleState ... targetStates) {
        final HashSet<Agent.LifecycleState> targetStatesSet = new HashSet<Agent.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAgentRequest, GetAgentResponse>(){

            @Override
            public GetAgentResponse apply(GetAgentRequest request) {
                return OcbAgentSvcWaiters.this.client.getAgent(request);
            }
        }, (Predicate)new Predicate<GetAgentResponse>(){

            @Override
            public boolean test(GetAgentResponse response) {
                return targetStatesSet.contains((Object)response.getAgent().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Agent.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAgentDependencyRequest, GetAgentDependencyResponse> forAgentDependency(GetAgentDependencyRequest request, AgentDependency.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAgentDependency(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAgentDependencyRequest, GetAgentDependencyResponse> forAgentDependency(GetAgentDependencyRequest request, AgentDependency.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAgentDependency(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAgentDependencyRequest, GetAgentDependencyResponse> forAgentDependency(GetAgentDependencyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AgentDependency.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAgentDependency(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAgentDependencyRequest, GetAgentDependencyResponse> forAgentDependency(BmcGenericWaiter waiter, GetAgentDependencyRequest request, AgentDependency.LifecycleState ... targetStates) {
        final HashSet<AgentDependency.LifecycleState> targetStatesSet = new HashSet<AgentDependency.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAgentDependencyRequest, GetAgentDependencyResponse>(){

            @Override
            public GetAgentDependencyResponse apply(GetAgentDependencyRequest request) {
                return OcbAgentSvcWaiters.this.client.getAgentDependency(request);
            }
        }, (Predicate)new Predicate<GetAgentDependencyResponse>(){

            @Override
            public boolean test(GetAgentDependencyResponse response) {
                return targetStatesSet.contains((Object)response.getAgentDependency().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AgentDependency.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetEnvironmentRequest, GetEnvironmentResponse> forEnvironment(GetEnvironmentRequest request, Environment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEnvironment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEnvironmentRequest, GetEnvironmentResponse> forEnvironment(GetEnvironmentRequest request, Environment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEnvironmentRequest, GetEnvironmentResponse> forEnvironment(GetEnvironmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Environment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEnvironmentRequest, GetEnvironmentResponse> forEnvironment(BmcGenericWaiter waiter, GetEnvironmentRequest request, Environment.LifecycleState ... targetStates) {
        final HashSet<Environment.LifecycleState> targetStatesSet = new HashSet<Environment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEnvironmentRequest, GetEnvironmentResponse>(){

            @Override
            public GetEnvironmentResponse apply(GetEnvironmentRequest request) {
                return OcbAgentSvcWaiters.this.client.getEnvironment(request);
            }
        }, (Predicate)new Predicate<GetEnvironmentResponse>(){

            @Override
            public boolean test(GetEnvironmentResponse response) {
                return targetStatesSet.contains((Object)response.getEnvironment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Environment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPluginRequest, GetPluginResponse> forPlugin(GetPluginRequest request, Plugin.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPlugin(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPluginRequest, GetPluginResponse> forPlugin(GetPluginRequest request, Plugin.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPlugin(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPluginRequest, GetPluginResponse> forPlugin(GetPluginRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Plugin.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPlugin(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPluginRequest, GetPluginResponse> forPlugin(BmcGenericWaiter waiter, GetPluginRequest request, Plugin.LifecycleState ... targetStates) {
        final HashSet<Plugin.LifecycleState> targetStatesSet = new HashSet<Plugin.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPluginRequest, GetPluginResponse>(){

            @Override
            public GetPluginResponse apply(GetPluginRequest request) {
                return OcbAgentSvcWaiters.this.client.getPlugin(request);
            }
        }, (Predicate)new Predicate<GetPluginResponse>(){

            @Override
            public boolean test(GetPluginResponse response) {
                return targetStatesSet.contains((Object)response.getPlugin().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Plugin.LifecycleState.Deleted)), (Object)request);
    }
}

